/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.DefaultAccessibilityProperties;
import com.itextpdf.layout.IPropertyContainer;

public class FormDefaultAccessibilityProperties
extends DefaultAccessibilityProperties {
    public static final String FORM_FIELD_RADIO = "rb";
    public static final String FORM_FIELD_CHECK = "cb";
    public static final String FORM_FIELD_PUSH_BUTTON = "pb";
    public static final String FORM_FIELD_LIST_BOX = "lb";
    public static final String FORM_FIELD_TEXT = "tv";
    private static final String ROLE_NAME = "Role";
    private static final String OWNER_PRINT_FIELD_NAME = "PrintField";
    private static final String ATTRIBUTE_CHECKED = "Checked";
    private static final String ATTRIBUTE_ON = "on";
    private static final String ATTRIBUTE_OFF = "off";
    private static final String[] ALLOWED_VALUES = new String[]{"tv", "rb", "cb", "lb", "pb"};

    public FormDefaultAccessibilityProperties(String formFieldType) {
        super("Form");
        FormDefaultAccessibilityProperties.checkIfFormFieldTypeIsAllowed(formFieldType);
        PdfStructureAttributes attrs = new PdfStructureAttributes(OWNER_PRINT_FIELD_NAME);
        attrs.addEnumAttribute(ROLE_NAME, formFieldType);
        super.addAttributes(attrs);
        if (FORM_FIELD_RADIO.equals(formFieldType) || FORM_FIELD_CHECK.equals(formFieldType)) {
            PdfStructureAttributes checkedState = new PdfStructureAttributes(OWNER_PRINT_FIELD_NAME);
            checkedState.addEnumAttribute(ATTRIBUTE_CHECKED, ATTRIBUTE_OFF);
            super.addAttributes(checkedState);
        }
    }

    public void updateCheckedValue(IPropertyContainer element) {
        for (PdfStructureAttributes pdfStructureAttributes : this.getAttributesList()) {
            if (pdfStructureAttributes.getAttributeAsEnum(ATTRIBUTE_CHECKED) == null) continue;
            String checkedValue = Boolean.TRUE.equals(element.getProperty(0x200007)) ? ATTRIBUTE_ON : ATTRIBUTE_OFF;
            pdfStructureAttributes.addEnumAttribute(ATTRIBUTE_CHECKED, checkedValue);
        }
    }

    private static void checkIfFormFieldTypeIsAllowed(String formFieldType) {
        for (String allowedValue : ALLOWED_VALUES) {
            if (!allowedValue.equals(formFieldType)) continue;
            return;
        }
        String allowedValues = String.join((CharSequence)", ", ALLOWED_VALUES);
        String message = MessageFormatUtil.format("Invalid formfield type: {0}, only following values are allowed {1}.", formFieldType, allowedValues);
        throw new PdfException(message);
    }
}

