/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields.merging;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfFormFieldMergeUtil;
import com.itextpdf.forms.fields.merging.OnDuplicateFormFieldNameStrategy;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeFieldsStrategy
implements OnDuplicateFormFieldNameStrategy {
    @Override
    public boolean execute(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        PdfName firstFieldFormType = firstField.getFormType();
        PdfObject firstFieldValue = firstField.getValue();
        PdfObject secondFieldValue = secondField.getValue();
        PdfObject firstFieldDefaultValue = firstField.getDefaultValue();
        PdfObject secondFieldDefaultValue = secondField.getDefaultValue();
        if (firstFieldFormType != null && !firstFieldFormType.equals(secondField.getFormType()) || firstFieldValue != null && secondFieldValue != null && !firstFieldValue.equals(secondFieldValue) || firstFieldDefaultValue != null && secondFieldDefaultValue != null && !firstFieldDefaultValue.equals(secondFieldDefaultValue)) {
            if (throwExceptionOnError) {
                throw new PdfException(MessageFormatUtil.format("Cannot merge form fields with the same names. Partial name is {0}. Field dictionaries with the same fully qualified field name shall have the same field type (FT), value (V), and default value (DV).", firstField.getPartialFieldName()));
            }
            Logger logger = LoggerFactory.getLogger(MergeFieldsStrategy.class);
            logger.warn(MessageFormatUtil.format("Cannot merge form fields with the same fully qualified names. Partial name is {0}. Field type (FT), value (V), and default value (DV) should be the same", firstField.getPartialFieldName()));
            return false;
        }
        PdfFormFieldMergeUtil.mergeFormFields(firstField, secondField, throwExceptionOnError);
        return true;
    }
}

