/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.otf.GposAnchor;
import com.itextpdf.io.font.otf.GposValueRecord;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfMarkRecord;
import com.itextpdf.io.font.otf.PosLookupRecord;
import com.itextpdf.io.font.otf.SubstLookupRecord;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OtfReadCommon {
    public static int[] readUShortArray(RandomAccessFileOrArray rf, int size, int location) throws IOException {
        int[] ret = new int[size];
        for (int k = 0; k < size; ++k) {
            int offset = rf.readUnsignedShort();
            ret[k] = offset == 0 ? offset : offset + location;
        }
        return ret;
    }

    public static int[] readUShortArray(RandomAccessFileOrArray rf, int size) throws IOException {
        return OtfReadCommon.readUShortArray(rf, size, 0);
    }

    public static void readCoverages(RandomAccessFileOrArray rf, int[] locations, List<Set<Integer>> coverage) throws IOException {
        for (int location : locations) {
            coverage.add(new HashSet<Integer>(OtfReadCommon.readCoverageFormat(rf, location)));
        }
    }

    public static List<Integer> readCoverageFormat(RandomAccessFileOrArray rf, int coverageLocation) throws IOException {
        ArrayList<Integer> glyphIds;
        rf.seek(coverageLocation);
        short coverageFormat = rf.readShort();
        if (coverageFormat == 1) {
            int glyphCount = rf.readUnsignedShort();
            glyphIds = new ArrayList<Integer>(glyphCount);
            for (int i = 0; i < glyphCount; ++i) {
                int coverageGlyphId = rf.readUnsignedShort();
                glyphIds.add(coverageGlyphId);
            }
        } else if (coverageFormat == 2) {
            int rangeCount = rf.readUnsignedShort();
            glyphIds = new ArrayList();
            for (int i = 0; i < rangeCount; ++i) {
                OtfReadCommon.readRangeRecord(rf, glyphIds);
            }
        } else {
            throw new UnsupportedOperationException(MessageFormatUtil.format("Invalid coverage format: {0}", coverageFormat));
        }
        return Collections.unmodifiableList(glyphIds);
    }

    private static void readRangeRecord(RandomAccessFileOrArray rf, List<Integer> glyphIds) throws IOException {
        int startGlyphId = rf.readUnsignedShort();
        int endGlyphId = rf.readUnsignedShort();
        short startCoverageIndex = rf.readShort();
        for (int glyphId = startGlyphId; glyphId <= endGlyphId; ++glyphId) {
            glyphIds.add(glyphId);
        }
    }

    public static GposValueRecord readGposValueRecord(OpenTypeFontTableReader tableReader, int mask) throws IOException {
        GposValueRecord vr = new GposValueRecord();
        if ((mask & 1) != 0) {
            vr.setXPlacement(FontProgram.convertGlyphSpaceToTextSpace(tableReader.rf.readShort()) / tableReader.getUnitsPerEm());
        }
        if ((mask & 2) != 0) {
            vr.setYPlacement(FontProgram.convertGlyphSpaceToTextSpace(tableReader.rf.readShort()) / tableReader.getUnitsPerEm());
        }
        if ((mask & 4) != 0) {
            vr.setXAdvance(FontProgram.convertGlyphSpaceToTextSpace(tableReader.rf.readShort()) / tableReader.getUnitsPerEm());
        }
        if ((mask & 8) != 0) {
            vr.setYAdvance(FontProgram.convertGlyphSpaceToTextSpace(tableReader.rf.readShort()) / tableReader.getUnitsPerEm());
        }
        if ((mask & 0x10) != 0) {
            tableReader.rf.skip(2L);
        }
        if ((mask & 0x20) != 0) {
            tableReader.rf.skip(2L);
        }
        if ((mask & 0x40) != 0) {
            tableReader.rf.skip(2L);
        }
        if ((mask & 0x80) != 0) {
            tableReader.rf.skip(2L);
        }
        return vr;
    }

    public static GposAnchor readGposAnchor(OpenTypeFontTableReader tableReader, int location) throws IOException {
        if (location == 0) {
            return null;
        }
        tableReader.rf.seek(location);
        int format = tableReader.rf.readUnsignedShort();
        GposAnchor t = null;
        switch (format) {
            default: 
        }
        t = new GposAnchor();
        t.setXCoordinate(FontProgram.convertGlyphSpaceToTextSpace(tableReader.rf.readShort()) / tableReader.getUnitsPerEm());
        t.setYCoordinate(FontProgram.convertGlyphSpaceToTextSpace(tableReader.rf.readShort()) / tableReader.getUnitsPerEm());
        return t;
    }

    public static List<OtfMarkRecord> readMarkArray(OpenTypeFontTableReader tableReader, int location) throws IOException {
        tableReader.rf.seek(location);
        int markCount = tableReader.rf.readUnsignedShort();
        int[] classes = new int[markCount];
        int[] locations = new int[markCount];
        for (int k = 0; k < markCount; ++k) {
            classes[k] = tableReader.rf.readUnsignedShort();
            int offset = tableReader.rf.readUnsignedShort();
            locations[k] = location + offset;
        }
        ArrayList<OtfMarkRecord> marks = new ArrayList<OtfMarkRecord>();
        for (int k = 0; k < markCount; ++k) {
            OtfMarkRecord rec = new OtfMarkRecord();
            rec.setMarkClass(classes[k]);
            rec.setAnchor(OtfReadCommon.readGposAnchor(tableReader, locations[k]));
            marks.add(rec);
        }
        return marks;
    }

    public static SubstLookupRecord[] readSubstLookupRecords(RandomAccessFileOrArray rf, int substCount) throws IOException {
        SubstLookupRecord[] substLookUpRecords = new SubstLookupRecord[substCount];
        for (int i = 0; i < substCount; ++i) {
            SubstLookupRecord slr = new SubstLookupRecord();
            slr.sequenceIndex = rf.readUnsignedShort();
            slr.lookupListIndex = rf.readUnsignedShort();
            substLookUpRecords[i] = slr;
        }
        return substLookUpRecords;
    }

    public static PosLookupRecord[] readPosLookupRecords(RandomAccessFileOrArray rf, int recordCount) throws IOException {
        PosLookupRecord[] posLookUpRecords = new PosLookupRecord[recordCount];
        for (int i = 0; i < recordCount; ++i) {
            PosLookupRecord lookupRecord = new PosLookupRecord();
            lookupRecord.sequenceIndex = rf.readUnsignedShort();
            lookupRecord.lookupListIndex = rf.readUnsignedShort();
            posLookUpRecords[i] = lookupRecord;
        }
        return posLookUpRecords;
    }

    public static GposAnchor[] readAnchorArray(OpenTypeFontTableReader tableReader, int[] locations, int left, int right) throws IOException {
        GposAnchor[] anchors = new GposAnchor[right - left];
        for (int i = left; i < right; ++i) {
            anchors[i - left] = OtfReadCommon.readGposAnchor(tableReader, locations[i]);
        }
        return anchors;
    }

    public static List<GposAnchor[]> readBaseArray(OpenTypeFontTableReader tableReader, int classCount, int location) throws IOException {
        ArrayList<GposAnchor[]> baseArray = new ArrayList<GposAnchor[]>();
        tableReader.rf.seek(location);
        int baseCount = tableReader.rf.readUnsignedShort();
        int[] anchorLocations = OtfReadCommon.readUShortArray(tableReader.rf, baseCount * classCount, location);
        int idx = 0;
        for (int k = 0; k < baseCount; ++k) {
            baseArray.add(OtfReadCommon.readAnchorArray(tableReader, anchorLocations, idx, idx + classCount));
            idx += classCount;
        }
        return baseArray;
    }

    public static List<List<GposAnchor[]>> readLigatureArray(OpenTypeFontTableReader tableReader, int classCount, int location) throws IOException {
        ArrayList<List<GposAnchor[]>> ligatureArray = new ArrayList<List<GposAnchor[]>>();
        tableReader.rf.seek(location);
        int ligatureCount = tableReader.rf.readUnsignedShort();
        int[] ligatureAttachLocations = OtfReadCommon.readUShortArray(tableReader.rf, ligatureCount, location);
        for (int liga = 0; liga < ligatureCount; ++liga) {
            int ligatureAttachLocation = ligatureAttachLocations[liga];
            ArrayList<GposAnchor[]> ligatureAttach = new ArrayList<GposAnchor[]>();
            tableReader.rf.seek(ligatureAttachLocation);
            int componentCount = tableReader.rf.readUnsignedShort();
            int[] componentRecordsLocation = OtfReadCommon.readUShortArray(tableReader.rf, classCount * componentCount, ligatureAttachLocation);
            int idx = 0;
            for (int k = 0; k < componentCount; ++k) {
                ligatureAttach.add(OtfReadCommon.readAnchorArray(tableReader, componentRecordsLocation, idx, idx + classCount));
                idx += classCount;
            }
            ligatureArray.add(ligatureAttach);
        }
        return ligatureArray;
    }
}

