/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.actions.events;

import com.itextpdf.commons.actions.AbstractITextConfigurationEvent;
import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmedEventWrapper;
import com.itextpdf.commons.actions.confirmations.EventConfirmationType;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.commons.actions.processors.ITextProductEventProcessor;
import com.itextpdf.commons.actions.producer.ProducerBuilder;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.pdf.PdfDocument;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlushPdfDocumentEvent
extends AbstractITextConfigurationEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushPdfDocumentEvent.class);
    private final WeakReference<PdfDocument> document;

    public FlushPdfDocumentEvent(PdfDocument document) {
        this.document = new WeakReference<PdfDocument>(document);
    }

    @Override
    protected void doAction() {
        PdfDocument pdfDocument = (PdfDocument)this.document.get();
        if (pdfDocument == null) {
            return;
        }
        List<AbstractProductProcessITextEvent> events = this.getEvents(pdfDocument.getDocumentIdWrapper());
        if (events == null || events.isEmpty()) {
            ProductData productData = ITextCoreProductData.getInstance();
            String noEventProducer = "iText\u00ae \u00a9" + productData.getSinceCopyrightYear() + "-" + productData.getToCopyrightYear() + " Apryse Group NV (no registered products)";
            pdfDocument.getDocumentInfo().setProducer(noEventProducer);
            return;
        }
        HashSet<String> products = new HashSet<String>();
        for (AbstractProductProcessITextEvent event : events) {
            pdfDocument.getFingerPrint().registerProduct(event.getProductData());
            if (event.getConfirmationType() == EventConfirmationType.ON_CLOSE) {
                EventManager.getInstance().onEvent(new ConfirmEvent(pdfDocument.getDocumentIdWrapper(), event));
            }
            products.add(event.getProductName());
        }
        for (String product : products) {
            ITextProductEventProcessor processor = this.getActiveProcessor(product);
            if (processor != null || !LOGGER.isWarnEnabled()) continue;
            LOGGER.warn(MessageFormatUtil.format("Unknown product {0} was involved into PDF processing. It will be ignored", product));
        }
        String oldProducer = pdfDocument.getDocumentInfo().getProducer();
        String newProducer = ProducerBuilder.modifyProducer(this.getConfirmedEvents(pdfDocument.getDocumentIdWrapper()), oldProducer);
        pdfDocument.getDocumentInfo().setProducer(newProducer);
    }

    private List<ConfirmedEventWrapper> getConfirmedEvents(SequenceId sequenceId) {
        List<AbstractProductProcessITextEvent> events = this.getEvents(sequenceId);
        ArrayList<ConfirmedEventWrapper> confirmedEvents = new ArrayList<ConfirmedEventWrapper>();
        for (AbstractProductProcessITextEvent event : events) {
            if (event instanceof ConfirmedEventWrapper) {
                confirmedEvents.add((ConfirmedEventWrapper)event);
                continue;
            }
            LOGGER.warn(MessageFormatUtil.format("Event for the product {0} with type {1} was reported but was not confirmed. Probably appropriate process fail", event.getProductName(), event.getEventType()));
        }
        return confirmedEvents;
    }
}

