/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.mac;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.MacSignatureContainerReader;
import com.itextpdf.kernel.mac.MacStandaloneContainerReader;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import java.io.ByteArrayInputStream;
import java.io.IOException;

abstract class MacContainerReader {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final byte[] macContainer;
    private final long[] byteRange;
    private final byte[] signature;

    MacContainerReader(PdfDictionary authDictionary) {
        this.macContainer = this.parseMacContainer(authDictionary);
        this.byteRange = this.parseByteRange(authDictionary);
        this.signature = this.parseSignature(authDictionary);
    }

    static MacContainerReader getInstance(PdfDictionary authDictionary) {
        PdfName macLocation = authDictionary.getAsName(PdfName.MACLocation);
        if (PdfName.Standalone.equals(macLocation)) {
            return new MacStandaloneContainerReader(authDictionary);
        }
        if (PdfName.AttachedToSig.equals(macLocation)) {
            return new MacSignatureContainerReader(authDictionary);
        }
        throw new PdfException("AuthCode dictionary doesn't contain MACLocation entry.");
    }

    abstract byte[] parseSignature(PdfDictionary var1);

    abstract long[] parseByteRange(PdfDictionary var1);

    abstract byte[] parseMacContainer(PdfDictionary var1);

    long[] getByteRange() {
        return this.byteRange;
    }

    byte[] getSignature() {
        return this.signature;
    }

    byte[] parseMac() {
        IASN1Sequence authDataSequence = this.getAuthDataSequence();
        return BC_FACTORY.createASN1OctetString(authDataSequence.getObjectAt(6)).getOctets();
    }

    IASN1Set parseAuthAttributes() {
        IASN1Sequence authDataSequence = this.getAuthDataSequence();
        return BC_FACTORY.createASN1Set(BC_FACTORY.createASN1TaggedObject(authDataSequence.getObjectAt(5)), false);
    }

    IASN1Sequence parseMessageDigest() {
        IASN1Set authAttributes = this.parseAuthAttributes();
        return BC_FACTORY.createASN1Sequence(authAttributes.getObjectAt(2));
    }

    byte[] parseMacKey() {
        IASN1Sequence authDataSequence = this.getAuthDataSequence();
        IASN1Sequence recInfo = BC_FACTORY.createASN1Sequence(BC_FACTORY.createASN1TaggedObject(BC_FACTORY.createASN1Set(authDataSequence.getObjectAt(1)).getObjectAt(0)).getObject());
        IASN1OctetString encryptedKey = BC_FACTORY.createASN1OctetString(recInfo.getObjectAt(3));
        return encryptedKey.getOctets();
    }

    String parseDigestAlgorithm() {
        IASN1Sequence authDataSequence = this.getAuthDataSequence();
        IASN1Primitive digestAlgorithmContainer = BC_FACTORY.createASN1TaggedObject(authDataSequence.getObjectAt(3)).getObject();
        IASN1ObjectIdentifier digestAlgorithm = BC_FACTORY.createASN1ObjectIdentifier(digestAlgorithmContainer) != null ? BC_FACTORY.createASN1ObjectIdentifier(digestAlgorithmContainer) : BC_FACTORY.createASN1ObjectIdentifier(BC_FACTORY.createASN1Sequence(digestAlgorithmContainer).getObjectAt(0));
        return digestAlgorithm.getId();
    }

    private IASN1Sequence getAuthDataSequence() {
        IASN1Sequence contentInfoSequence;
        try (IASN1InputStream din = BC_FACTORY.createASN1InputStream(new ByteArrayInputStream(this.macContainer));){
            contentInfoSequence = BC_FACTORY.createASN1Sequence(din.readObject());
        }
        catch (IOException e) {
            throw new PdfException("Exception occurred during MAC container parsing.", e);
        }
        return BC_FACTORY.createASN1Sequence(BC_FACTORY.createASN1TaggedObject(contentInfoSequence.getObjectAt(1)).getObject());
    }
}

