/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfStream;
import org.slf4j.Logger;

final class IndirectFilterUtils {
    private IndirectFilterUtils() {
    }

    static void throwFlushedFilterException(PdfStream stream) {
        throw new PdfException(MessageFormatUtil.format("Stream {0} {1} R contains flushed indirect filter object in encrypted document, try to use PdfStream#flush() stream before PdfDocument#close() to prevent this exception", stream.getIndirectReference().getObjNumber(), stream.getIndirectReference().getGenNumber()));
    }

    static void logFilterWasAlreadyFlushed(Logger logger, PdfStream stream) {
        logger.info(MessageFormatUtil.format("{0} {1} R stream object filter was already flushed, stream compression will remain as in original file. Try to flush object containing filter before the PdfDocument#close() method so that stream compression would be processed as intended.", stream.getIndirectReference().getObjNumber(), stream.getIndirectReference().getGenNumber()));
    }
}

