/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.GenericNameTree;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PdfNameTree
extends GenericNameTree {
    private final PdfCatalog catalog;
    private final PdfName treeType;

    public PdfNameTree(PdfCatalog catalog, PdfName treeType) {
        super(catalog.getDocument());
        this.treeType = treeType;
        this.catalog = catalog;
        this.setItems(this.readFromCatalog());
    }

    public Map<PdfString, PdfObject> getNames() {
        return this.getItems();
    }

    private LinkedHashMap<PdfString, PdfObject> readFromCatalog() {
        PdfDictionary namesDict = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Names);
        PdfDictionary treeRoot = namesDict == null ? null : namesDict.getAsDictionary(this.treeType);
        LinkedHashMap<PdfString, PdfObject> items = treeRoot == null ? new LinkedHashMap() : PdfNameTree.readTree(treeRoot);
        if (this.treeType.equals(PdfName.Dests)) {
            PdfNameTree.normalizeDestinations(items);
            this.insertDestsEntriesFromCatalog(items);
        }
        return items;
    }

    private static void normalizeDestinations(Map<PdfString, PdfObject> items) {
        HashSet<PdfString> keys = new HashSet<PdfString>(items.keySet());
        for (PdfString key : keys) {
            PdfArray arr = PdfNameTree.getDestArray(items.get(key));
            if (arr == null) {
                items.remove(key);
                continue;
            }
            items.put(key, arr);
        }
    }

    private void insertDestsEntriesFromCatalog(Map<PdfString, PdfObject> items) {
        PdfDictionary destinations = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Dests);
        if (destinations != null) {
            Set<PdfName> keys = destinations.keySet();
            for (PdfName key : keys) {
                PdfArray array = PdfNameTree.getDestArray(destinations.get(key));
                if (array == null) continue;
                items.put(new PdfString(key.getValue()), array);
            }
        }
    }

    private static PdfArray getDestArray(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.isArray()) {
            return (PdfArray)obj;
        }
        if (obj.isDictionary()) {
            return ((PdfDictionary)obj).getAsArray(PdfName.D);
        }
        return null;
    }
}

