/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function;

import com.itextpdf.commons.utils.MessageFormatUtil;

public final class BaseInputOutPutConvertors {
    private BaseInputOutPutConvertors() {
    }

    public static IInputConversionFunction getInputConvertor(int wordSize, double scaleFactor) {
        return BaseInputOutPutConvertors.getByteBasedInputConvertor(wordSize, scaleFactor * (double)(1L << wordSize * 8) - 1.0);
    }

    public static IOutputConversionFunction getOutputConvertor(int wordSize, double scaleFactor) {
        return BaseInputOutPutConvertors.getByteBasedOutputConvertor(wordSize, scaleFactor * (double)(1L << wordSize * 8) - 1.0);
    }

    private static IInputConversionFunction getByteBasedInputConvertor(int wordSize, double scale) {
        return (input, o, l) -> {
            if (o + l > input.length) {
                throw new IllegalArgumentException("The offset + length must be lower than or equal to the length of the byte array.");
            }
            if (l % wordSize != 0) {
                throw new IllegalArgumentException(MessageFormatUtil.format("The length must be a multiple of {0}.", wordSize));
            }
            double[] out = new double[l / wordSize];
            int inIndex = o;
            int outIndex = 0;
            while (inIndex < l + o) {
                int val2 = 0;
                for (int wordIndex = 0; wordIndex < wordSize; ++wordIndex) {
                    val2 = (val2 << 8) + (input[inIndex + wordIndex] & 0xFF);
                    ++inIndex;
                }
                out[outIndex] = (double)val2 / scale;
                ++outIndex;
            }
            return out;
        };
    }

    private static IOutputConversionFunction getByteBasedOutputConvertor(int wordSize, double scale) {
        return input -> {
            byte[] out = new byte[input.length * wordSize];
            int outIndex = 0;
            for (int inIndex = 0; inIndex < input.length && outIndex < out.length; ++inIndex) {
                int val2 = (int)(input[inIndex] * scale);
                for (int wordIndex = 0; wordIndex < wordSize; ++wordIndex) {
                    out[outIndex++] = (byte)(val2 >>> wordIndex * 8);
                }
            }
            return out;
        };
    }

    @FunctionalInterface
    public static interface IOutputConversionFunction {
        public byte[] convert(double[] var1);
    }

    @FunctionalInterface
    public static interface IInputConversionFunction {
        public double[] convert(byte[] var1, int var2, int var3);
    }
}

