/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.kernel.pdf.statistics.SizeOfPdfStatisticsAggregator;
import java.util.Collections;
import java.util.List;

public class SizeOfPdfStatisticsEvent
extends AbstractStatisticsEvent {
    private static final String PDF_SIZE_STATISTICS = "pdfSize";
    private final long amountOfBytes;

    public SizeOfPdfStatisticsEvent(long amountOfBytes, ProductData productData) {
        super(productData);
        if (amountOfBytes < 0L) {
            throw new IllegalArgumentException("Amount of bytes in the PDF document cannot be less than zero");
        }
        this.amountOfBytes = amountOfBytes;
    }

    @Override
    public AbstractStatisticsAggregator createStatisticsAggregatorFromName(String statisticsName) {
        if (PDF_SIZE_STATISTICS.equals(statisticsName)) {
            return new SizeOfPdfStatisticsAggregator();
        }
        return super.createStatisticsAggregatorFromName(statisticsName);
    }

    @Override
    public List<String> getStatisticsNames() {
        return Collections.singletonList(PDF_SIZE_STATISTICS);
    }

    public long getAmountOfBytes() {
        return this.amountOfBytes;
    }
}

