/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIteratorFlusher;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.util.HashMap;
import java.util.Map;

public class WaitingTagsManager {
    private final Map<Object, PdfStructElem> associatedObjToWaitingTag = new HashMap<Object, PdfStructElem>();
    private final Map<PdfDictionary, Object> waitingTagToAssociatedObj = new HashMap<PdfDictionary, Object>();

    WaitingTagsManager() {
    }

    public Object assignWaitingState(TagTreePointer pointerToTag, Object associatedObj) {
        if (associatedObj == null) {
            throw new IllegalArgumentException("Passed associated object can not be null.");
        }
        return this.saveAssociatedObjectForWaitingTag(associatedObj, pointerToTag.getCurrentStructElem());
    }

    public boolean isObjectAssociatedWithWaitingTag(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Passed associated object can not be null.");
        }
        return this.associatedObjToWaitingTag.containsKey(obj);
    }

    public boolean tryMovePointerToWaitingTag(TagTreePointer tagPointer, Object associatedObject) {
        if (associatedObject == null) {
            return false;
        }
        PdfStructElem waitingStructElem = this.associatedObjToWaitingTag.get(associatedObject);
        if (waitingStructElem != null) {
            tagPointer.setCurrentStructElem(waitingStructElem);
            return true;
        }
        return false;
    }

    public boolean removeWaitingState(Object associatedObject) {
        if (associatedObject != null) {
            PdfStructElem structElem = this.associatedObjToWaitingTag.remove(associatedObject);
            this.removeWaitingStateAndFlushIfParentFlushed(structElem);
            return structElem != null;
        }
        return false;
    }

    public void removeAllWaitingStates() {
        for (PdfStructElem structElem : this.associatedObjToWaitingTag.values()) {
            this.removeWaitingStateAndFlushIfParentFlushed(structElem);
        }
        this.associatedObjToWaitingTag.clear();
    }

    PdfStructElem getStructForObj(Object associatedObj) {
        return this.associatedObjToWaitingTag.get(associatedObj);
    }

    Object getObjForStructDict(PdfDictionary structDict) {
        return this.waitingTagToAssociatedObj.get(structDict);
    }

    Object saveAssociatedObjectForWaitingTag(Object associatedObj, PdfStructElem structElem) {
        this.associatedObjToWaitingTag.put(associatedObj, structElem);
        return this.waitingTagToAssociatedObj.put((PdfDictionary)structElem.getPdfObject(), associatedObj);
    }

    IStructureNode flushTag(PdfStructElem tagStruct) {
        Object associatedObj = this.waitingTagToAssociatedObj.remove(tagStruct.getPdfObject());
        if (associatedObj != null) {
            this.associatedObjToWaitingTag.remove(associatedObj);
        }
        IStructureNode parent = tagStruct.getParent();
        this.flushStructElementAndItKids(tagStruct);
        return parent;
    }

    private void flushStructElementAndItKids(PdfStructElem elem) {
        if (this.waitingTagToAssociatedObj.containsKey(elem.getPdfObject())) {
            return;
        }
        TagTreeIterator iterator = new TagTreeIterator(elem, TagTreeIterator.TreeTraversalOrder.POST_ORDER);
        iterator.addHandler(new TagTreeIteratorFlusher().setWaitingTags(this.waitingTagToAssociatedObj.keySet()));
        iterator.traverse();
    }

    private void removeWaitingStateAndFlushIfParentFlushed(PdfStructElem structElem) {
        if (structElem != null) {
            this.waitingTagToAssociatedObj.remove(structElem.getPdfObject());
            IStructureNode parent = structElem.getParent();
            if (parent instanceof PdfStructElem && ((PdfStructElem)parent).isFlushed()) {
                this.flushStructElementAndItKids(structElem);
            }
        }
    }
}

