/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.pdf.tagging.StandardNamespaces;
import java.util.HashSet;
import java.util.Set;

class AccessibleTypes {
    static int Unknown = 0;
    static int Grouping = 1;
    static int BlockLevel = 2;
    static int InlineLevel = 3;
    static int Illustration = 4;
    static Set<String> groupingRoles = new HashSet<String>();
    static Set<String> blockLevelRoles = new HashSet<String>();
    static Set<String> inlineLevelRoles = new HashSet<String>();
    static Set<String> illustrationRoles = new HashSet<String>();

    AccessibleTypes() {
    }

    static int identifyType(String role) {
        if (groupingRoles.contains(role)) {
            return Grouping;
        }
        if (blockLevelRoles.contains(role) || StandardNamespaces.isHnRole(role)) {
            return BlockLevel;
        }
        if (inlineLevelRoles.contains(role)) {
            return InlineLevel;
        }
        if (illustrationRoles.contains(role)) {
            return Illustration;
        }
        return Unknown;
    }

    static {
        groupingRoles.add("Part");
        groupingRoles.add("Art");
        groupingRoles.add("Sect");
        groupingRoles.add("Div");
        groupingRoles.add("BlockQuote");
        groupingRoles.add("Caption");
        groupingRoles.add("TOC");
        groupingRoles.add("TOCI");
        groupingRoles.add("Index");
        groupingRoles.add("NonStruct");
        groupingRoles.add("Private");
        groupingRoles.add("Aside");
        blockLevelRoles.add("P");
        blockLevelRoles.add("H");
        blockLevelRoles.add("H1");
        blockLevelRoles.add("H2");
        blockLevelRoles.add("H3");
        blockLevelRoles.add("H4");
        blockLevelRoles.add("H5");
        blockLevelRoles.add("H6");
        blockLevelRoles.add("L");
        blockLevelRoles.add("Lbl");
        blockLevelRoles.add("LI");
        blockLevelRoles.add("LBody");
        blockLevelRoles.add("Table");
        blockLevelRoles.add("TR");
        blockLevelRoles.add("TH");
        blockLevelRoles.add("TD");
        blockLevelRoles.add("Title");
        blockLevelRoles.add("FENote");
        blockLevelRoles.add("Sub");
        blockLevelRoles.add("Caption");
        inlineLevelRoles.add("Span");
        inlineLevelRoles.add("Quote");
        inlineLevelRoles.add("Note");
        inlineLevelRoles.add("Reference");
        inlineLevelRoles.add("BibEntry");
        inlineLevelRoles.add("Code");
        inlineLevelRoles.add("Link");
        inlineLevelRoles.add("Annot");
        inlineLevelRoles.add("Ruby");
        inlineLevelRoles.add("Warichu");
        inlineLevelRoles.add("RB");
        inlineLevelRoles.add("RT");
        inlineLevelRoles.add("RP");
        inlineLevelRoles.add("WT");
        inlineLevelRoles.add("WP");
        inlineLevelRoles.add("Em");
        inlineLevelRoles.add("Strong");
        illustrationRoles.add("Figure");
        illustrationRoles.add("Formula");
        illustrationRoles.add("Form");
    }
}

