/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.tagging.ITaggingRule;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.List;

class THTaggingRule
implements ITaggingRule {
    THTaggingRule() {
    }

    @Override
    public boolean onTagFinish(LayoutTaggingHelper taggingHelper, TaggingHintKey taggingHintKey) {
        if (taggingHintKey.getAccessibilityProperties() == null) {
            throw new IllegalArgumentException("TaggingHintKey should have accessibility properties");
        }
        List<PdfStructureAttributes> attributesList = taggingHintKey.getAccessibilityProperties().getAttributesList();
        for (PdfStructureAttributes attributes : attributesList) {
            PdfName scopeValue = ((PdfDictionary)attributes.getPdfObject()).getAsName(PdfName.Scope);
            if (scopeValue != null && !PdfName.None.equals(scopeValue)) {
                return true;
            }
            if (!PdfName.None.equals(scopeValue)) continue;
            attributes.removeAttribute(PdfName.Scope.getValue());
            return true;
        }
        if (taggingHintKey.getTagPointer() == null) {
            return true;
        }
        AccessibilityProperties properties = taggingHintKey.getAccessibilityProperties();
        PdfStructureAttributes atr = new PdfStructureAttributes("Table");
        atr.addEnumAttribute(PdfName.Scope.getValue(), PdfName.Column.getValue());
        properties.addAttributes(atr);
        taggingHintKey.getTagPointer().applyProperties(properties);
        return true;
    }
}

