/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfAConformance;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.properties.XMPProperty;
import com.itextpdf.pdfa.PdfAXMPUtil;
import com.itextpdf.pdfa.checker.PdfA3Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import com.itextpdf.pdfa.exceptions.PdfAConformanceException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfA4Checker
extends PdfA3Checker {
    private static final String CALRGB_COLOR_SPACE = "CalRGB";
    private static final Set<PdfName> forbiddenAnnotations4 = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName._3D, PdfName.RichMedia, PdfName.FileAttachment, PdfName.Sound, PdfName.Screen, PdfName.Movie)));
    private static final Set<PdfName> forbiddenAnnotations4E = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.FileAttachment, PdfName.Sound, PdfName.Screen, PdfName.Movie)));
    private static final Set<PdfName> forbiddenAnnotations4F = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName._3D, PdfName.RichMedia, PdfName.Sound, PdfName.Screen, PdfName.Movie)));
    private static final Set<PdfName> apLessAnnotations = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Popup, PdfName.Link, PdfName.Projection)));
    private static final Set<PdfName> allowedBlendModes4 = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Normal, PdfName.Multiply, PdfName.Screen, PdfName.Overlay, PdfName.Darken, PdfName.Lighten, PdfName.ColorDodge, PdfName.ColorBurn, PdfName.HardLight, PdfName.SoftLight, PdfName.Difference, PdfName.Exclusion, PdfName.Hue, PdfName.Saturation, PdfName.Color, PdfName.Luminosity)));
    private static final String TRANSPARENCY_ERROR_MESSAGE = "If the document does not contain a PDF/A output intent, then all pages that contain transparency shall either have a page-level PDF/A output intent or the page dictionary shall include the Group key, and the attribute dictionary that forms the value of that Group key shall include a CS entry whose value shall be used as the default blending colour space.";
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfAChecker.class);
    private static final Set<PdfName> forbiddenActionsE = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Launch, PdfName.Sound, PdfName.Movie, PdfName.ResetForm, PdfName.ImportData, PdfName.JavaScript, PdfName.Hide, PdfName.Rendition, PdfName.Trans)));
    private static final Set<PdfName> allowedEntriesInAAWhenNonWidget = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.E, PdfName.X, PdfName.D, PdfName.U, PdfName.Fo, PdfName.Bl)));
    private Map<PdfObject, List<PdfStream>> iccBasedCmykObjects = new HashMap<PdfObject, List<PdfStream>>();

    public PdfA4Checker(PdfAConformance aConformance) {
        super(aConformance);
    }

    @Override
    public void checkColorSpace(PdfColorSpace colorSpace, PdfObject pdfObject, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        PdfStream iccStream;
        byte[] iccBytes;
        if (colorSpace instanceof PdfCieBasedCs.IccBased && "CMYK".equals(IccProfile.getIccColorSpaceName(iccBytes = (iccStream = ((PdfArray)colorSpace.getPdfObject()).getAsStream(1)).getBytes()))) {
            if (!this.iccBasedCmykObjects.containsKey(pdfObject)) {
                this.iccBasedCmykObjects.put(pdfObject, new ArrayList());
            }
            this.iccBasedCmykObjects.get(pdfObject).add(iccStream);
        }
        super.checkColorSpace(colorSpace, pdfObject, currentColorSpaces, checkAlternate, fill);
    }

    @Override
    protected void checkPageColorsUsages(PdfDictionary pageDict, PdfDictionary pageResources) {
        PdfDictionary pdfAPageOutputIntent;
        PdfStream pageDestOutputProfile = null;
        PdfArray outputIntents = pageDict.getAsArray(PdfName.OutputIntents);
        if (outputIntents != null && (pdfAPageOutputIntent = this.getPdfAOutputIntent(outputIntents)) != null) {
            pageDestOutputProfile = pdfAPageOutputIntent.getAsStream(PdfName.DestOutputProfile);
        }
        if (pageDestOutputProfile == null) {
            pageDestOutputProfile = this.pdfAOutputIntentDestProfile;
        }
        PdfColorSpace pageTransparencyBlendingCS = PdfA4Checker.getDeviceIndependentTransparencyBlendingCSIfRbgOrCmykBased(pageDict);
        if (!(this.rgbUsedObjects.isEmpty() && this.cmykUsedObjects.isEmpty() && this.grayUsedObjects.isEmpty() && this.iccBasedCmykObjects.isEmpty())) {
            this.checkPageContentsForColorUsages(pageDict, pageDestOutputProfile, pageTransparencyBlendingCS);
            this.checkAnnotationsForColorUsages(pageDict.getAsArray(PdfName.Annots), pageDestOutputProfile, pageTransparencyBlendingCS);
            this.checkResourcesForColorUsages(pageResources, pageDestOutputProfile, pageTransparencyBlendingCS);
        }
    }

    @Override
    protected void checkTrailer(PdfDictionary trailer) {
        PdfDictionary info;
        super.checkTrailer(trailer);
        if (trailer.get(PdfName.Info) != null && ((info = trailer.getAsDictionary(PdfName.Info)).size() != 1 || info.get(PdfName.ModDate) == null)) {
            throw new PdfAConformanceException("If a document information dictionary is present, it shall only contain a ModDate entry.");
        }
    }

    @Override
    protected void checkCatalog(PdfCatalog catalog) {
        if ('2' != catalog.getDocument().getPdfVersion().toString().charAt(4)) {
            throw new PdfAConformanceException(MessageFormatUtil.format("The file header shall begin at byte zero and shall consist of \u201c%PDF-{0}.n\u201d", "2"));
        }
        PdfDictionary trailer = catalog.getDocument().getTrailer();
        if (trailer.get(PdfName.Info) != null && ((PdfDictionary)catalog.getPdfObject()).get(PdfName.PieceInfo) == null) {
            throw new PdfAConformanceException("The Info key shall not be present in the trailer dictionary of PDF/A-4 conforming files unless there exists a PieceInfo entry in the document catalog dictionary.");
        }
        if ("F".equals(this.conformance.getLevel()) && !catalog.nameTreeContainsKey(PdfName.EmbeddedFiles)) {
            throw new PdfAConformanceException("Conforming file shall contain an EmbeddedFiles key in the name dictionary of the document catalog dictionary.");
        }
    }

    @Override
    protected void checkPageObject(PdfDictionary pageDict, PdfDictionary pageResources) {
        super.checkPageObject(pageDict, pageResources);
        PdfStream xmpMeta = pageDict.getAsStream(PdfName.Metadata);
        if (xmpMeta != null && !PdfAXMPUtil.isUtf8(xmpMeta.getBytes())) {
            throw new PdfAConformanceException("XMP metadata shall always be UTF-8 encoded.");
        }
    }

    @Override
    protected void checkCatalogValidEntries(PdfDictionary catalogDict) {
        super.checkCatalogValidEntries(catalogDict);
        PdfString version = catalogDict.getAsString(PdfName.Version);
        if (!(version == null || version.toString().charAt(0) == '2' && version.toString().charAt(1) == '.' && Character.isDigit(version.toString().charAt(2)))) {
            throw new PdfAConformanceException(MessageFormatUtil.format("The catalog version key shall begin at byte zero and shall consist of \u201c%PDF-{0}.n\u201d", "2"));
        }
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (fileSpec.getAsName(PdfName.AFRelationship) == null) {
            throw new PdfAConformanceException("Each embedded file\u2019s file specification dictionary shall contain an AFRelationship key.");
        }
        if (!fileSpec.containsKey(PdfName.F) || !fileSpec.containsKey(PdfName.UF)) {
            throw new PdfAConformanceException("File specification dictionary shall contain f key and uf key");
        }
        if (!fileSpec.containsKey(PdfName.Desc)) {
            LOGGER.warn("File specification dictionary should contain desc key");
        }
    }

    @Override
    protected void checkPageTransparency(PdfDictionary pageDict, PdfDictionary pageResources) {
        PdfDictionary pdfAPageOutputIntent = null;
        PdfArray outputIntents = pageDict.getAsArray(PdfName.OutputIntents);
        if (outputIntents != null) {
            pdfAPageOutputIntent = this.getPdfAOutputIntent(outputIntents);
        }
        if (!(this.pdfAOutputIntentColorSpace != null || pdfAPageOutputIntent != null || this.transparencyObjects.isEmpty() || pageDict.getAsDictionary(PdfName.Group) != null && pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS) != null)) {
            this.checkContentsForTransparency(pageDict);
            this.checkAnnotationsForTransparency(pageDict.getAsArray(PdfName.Annots));
            this.checkResourcesForTransparency(pageResources, new HashSet<PdfObject>());
        }
    }

    @Override
    protected void checkCatalogAAConformance(PdfDictionary dict) {
        PdfDictionary aa = dict.getAsDictionary(PdfName.AA);
        if (aa != null && PdfA4Checker.hasAAIllegalEntries(aa)) {
            throw new PdfAConformanceException("If a document catalog dictionary includes an AA entry, its value (which is an additional-actions dictionary) shall only contain keys from the following list: E, X, D, U, Fo, and B");
        }
    }

    @Override
    protected void checkPageAAConformance(PdfDictionary dict) {
        PdfDictionary aa = dict.getAsDictionary(PdfName.AA);
        if (aa != null && PdfA4Checker.hasAAIllegalEntries(aa)) {
            throw new PdfAConformanceException("If page dictionary includes an AA entry, its value (which is an additional-actions dictionary) shall only contain keys from the following list: E, X, D, U, Fo, and B");
        }
    }

    @Override
    protected void checkPdfNumber(PdfNumber number) {
    }

    @Override
    public void checkCanvasStack(char stackOperation) {
    }

    @Override
    public void checkSignatureType(boolean isCAdES) {
        if (!isCAdES) {
            throw new PdfAConformanceException("Signature shall conform to one of the PAdES profiles from either ISO 32000-2 or ISO 14533-3.");
        }
    }

    @Override
    protected int getMaxStringLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void checkNumberOfDeviceNComponents(PdfSpecialCs.DeviceN deviceN) {
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState, PdfStream contentStream) {
        super.checkExtGState(extGState, contentStream);
        if (extGState.getHalftone() instanceof PdfDictionary) {
            PdfDictionary halftoneDict = (PdfDictionary)extGState.getHalftone();
            if (halftoneDict.containsKey(PdfName.TransferFunction)) {
                throw new PdfAConformanceException("The TransferFunction key in a halftone dictionary can only be present if it is a component in a Type 5 halftone dictionary representing a colorant other than Cyan, Magenta, Yellow or Black.");
            }
            int halftoneType = halftoneDict.getAsInt(PdfName.HalftoneType);
            if (halftoneType == 5) {
                for (Map.Entry<PdfName, PdfObject> entry : halftoneDict.entrySet()) {
                    if (PdfName.Type.equals(entry.getKey()) || PdfName.HalftoneType.equals(entry.getKey()) || PdfName.HalftoneName.equals(entry.getKey()) || !(entry.getValue() instanceof PdfDictionary) || !this.isCMYKColorant(entry.getKey()) || !(entry.getValue() instanceof PdfDictionary) || !((PdfDictionary)entry.getValue()).containsKey(PdfName.TransferFunction)) continue;
                    throw new PdfAConformanceException("The TransferFunction key in a halftone dictionary can only be present if it is a component in a Type 5 halftone dictionary representing a colorant other than Cyan, Magenta, Yellow or Black.");
                }
            }
        }
    }

    @Override
    protected void checkFormXObject(PdfStream form, PdfStream contentStream) {
        if (this.isAlreadyChecked(form)) {
            return;
        }
        if (form.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain opi key");
        }
        if (form.containsKey(PdfName.Ref)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain ref key");
        }
        this.checkTransparencyGroup(form, contentStream);
        this.checkResources(form.getAsDictionary(PdfName.Resources), form);
        this.checkContentStream(form);
    }

    @Override
    protected void checkAnnotation(PdfDictionary annotDic) {
        super.checkAnnotation(annotDic);
        PdfName blendMode = annotDic.getAsName(PdfName.BM);
        if (blendMode != null && !allowedBlendModes4.contains(blendMode)) {
            throw new PdfAConformanceException("Only blend modes that are specified in ISO 32000-2:2020 shall be used for the value of the BM key in a graphic state dictionary or an annotation dictionary.");
        }
        if (blendMode != null && !PdfName.Normal.equals(blendMode)) {
            this.transparencyObjects.add(annotDic);
        }
    }

    @Override
    protected Set<PdfName> getForbiddenAnnotations() {
        if ("E".equals(this.conformance.getLevel())) {
            return forbiddenAnnotations4E;
        }
        if ("F".equals(this.conformance.getLevel())) {
            return forbiddenAnnotations4F;
        }
        return forbiddenAnnotations4;
    }

    @Override
    protected Set<PdfName> getAppearanceLessAnnotations() {
        return apLessAnnotations;
    }

    protected void checkWidgetAAConformance(PdfDictionary dict) {
        PdfObject additionalActions;
        if (!PdfName.Widget.equals(dict.getAsName(PdfName.Subtype)) && dict.containsKey(PdfName.AA) && (additionalActions = dict.get(PdfName.AA)).isDictionary() && PdfA4Checker.hasAAIllegalEntries((PdfDictionary)additionalActions)) {
            throw new PdfAConformanceException("If annotation dictionary (other than a Widget annotation dictionary) includes an AA entry, its value (which is an additional-actions dictionary) shall only contain keys from the following list: E, X, D, U, Fo, and B");
        }
    }

    @Override
    protected void checkMetaData(PdfDictionary catalog) {
        super.checkMetaData(catalog);
        try {
            PdfStream xmpMetadata = catalog.getAsStream(PdfName.Metadata);
            byte[] bytes = xmpMetadata.getBytes();
            PdfA4Checker.isValidEncoding(bytes);
            this.checkPacketHeader(bytes);
            XMPMeta meta = XMPMetaFactory.parse(new ByteArrayInputStream(bytes));
            this.checkVersionIdentification(meta);
            this.checkFileProvenanceSpec(meta);
        }
        catch (XMPException ex) {
            throw new PdfException(ex);
        }
    }

    @Override
    protected void checkOutputIntents(PdfDictionary catalog) {
        super.checkOutputIntents(catalog);
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        for (int i = 0; i < outputIntents.size(); ++i) {
            PdfDictionary outputIntent = outputIntents.getAsDictionary(i);
            if (!outputIntent.containsKey(new PdfName("DestOutputProfileRef"))) continue;
            throw new PdfAConformanceException("DestOutputProfileRef shall not be present in output intent");
        }
    }

    @Override
    protected void checkAnnotationAgainstActions(PdfDictionary annotDic) {
        if (PdfName.Widget.equals(annotDic.getAsName(PdfName.Subtype)) && annotDic.containsKey(PdfName.A)) {
            throw new PdfAConformanceException("Widget annotation dictionary or field dictionary shall not include a entry");
        }
        this.checkWidgetAAConformance(annotDic);
    }

    private static boolean hasAAIllegalEntries(PdfDictionary aa) {
        for (PdfName key : aa.keySet()) {
            if (allowedEntriesInAAWhenNonWidget.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<PdfName> getForbiddenActions() {
        if ("E".equals(this.conformance.getLevel())) {
            return forbiddenActionsE;
        }
        return super.getForbiddenActions();
    }

    @Override
    protected void checkContentConfigurationDictAgainstAsKey(PdfDictionary config) {
    }

    @Override
    protected String getTransparencyErrorMessage() {
        return TRANSPARENCY_ERROR_MESSAGE;
    }

    @Override
    protected void checkBlendMode(PdfName blendMode) {
        if (!allowedBlendModes4.contains(blendMode)) {
            throw new PdfAConformanceException("Only standard blend modes shall be used for the value of the BM key in an extended graphic state dictionary");
        }
    }

    @Override
    protected int getMaxNameLength() {
        return Integer.MAX_VALUE;
    }

    private static void isValidEncoding(byte[] data) {
        if (!PdfAXMPUtil.isUtf8(data)) {
            throw new PdfAConformanceException("XMP metadata shall always be UTF-8 encoded.");
        }
    }

    private static boolean isValidXmpConformance(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() != 1) {
            return false;
        }
        return "F".equals(value) || "E".equals(value);
    }

    private static boolean isValidXmpRevision(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() != 4) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private void checkPacketHeader(byte[] meta) {
        if (meta == null) {
            return;
        }
        String metAsStr = new String(meta);
        String regex = "<\\?xpacket.*encoding|bytes.*\\?>";
        Pattern pattern = Pattern.compile("<\\?xpacket.*encoding|bytes.*\\?>");
        if (pattern.matcher(metAsStr).find()) {
            throw new PdfAConformanceException("XMP metadata header packet may not contain bytes or encoding attribute.");
        }
    }

    private void checkFileProvenanceSpec(XMPMeta meta) {
        try {
            XMPProperty history = meta.getProperty("http://ns.adobe.com/xap/1.0/mm/", "History");
            if (history == null) {
                return;
            }
            if (!history.getOptions().isArray()) {
                return;
            }
            int amountOfEntries = meta.countArrayItems("http://ns.adobe.com/xap/1.0/mm/", "History");
            for (int i = 0; i < amountOfEntries; ++i) {
                int nameSpaceIndex = i + 1;
                if (!meta.doesPropertyExist("http://ns.adobe.com/xap/1.0/mm/", "History[" + nameSpaceIndex + "]/stEvt:action")) {
                    throw new PdfAConformanceException(MessageFormatUtil.format("XMP metadata history entry shall contain key {0}", "stEvt:action"));
                }
                if (meta.doesPropertyExist("http://ns.adobe.com/xap/1.0/mm/", "History[" + nameSpaceIndex + "]/stEvt:when")) continue;
                throw new PdfAConformanceException(MessageFormatUtil.format("XMP metadata history entry shall contain key {0}", "stEvt:when"));
            }
        }
        catch (XMPException e) {
            throw new PdfException(e);
        }
    }

    private void checkVersionIdentification(XMPMeta meta) {
        XMPProperty prop;
        try {
            prop = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "part");
            if (prop == null || !this.getAConformance().getPart().equals(prop.getValue())) {
                throw new PdfAConformanceException(MessageFormatUtil.format("XMP metadata header shall contain version identifier pdfaid:part with value {0}", this.getAConformance().getPart()));
            }
        }
        catch (XMPException e) {
            throw new PdfAConformanceException(MessageFormatUtil.format("XMP metadata header shall contain version identifier pdfaid:part with value {0}", this.getAConformance().getPart()));
        }
        try {
            prop = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "rev");
            if (prop == null || !PdfA4Checker.isValidXmpRevision(prop.getValue())) {
                throw new PdfAConformanceException("XMP metadata header shall contain version identifier pdfaid:rev with four digit integer value");
            }
        }
        catch (XMPException e) {
            throw new PdfAConformanceException("XMP metadata header shall contain version identifier pdfaid:rev with four digit integer value");
        }
        try {
            prop = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "conformance");
            if (prop != null && !PdfA4Checker.isValidXmpConformance(prop.getValue())) {
                throw new PdfAConformanceException("XMP metadata header shall contain version identifier pdfaid:rev F or E or absent if no conformance is specified");
            }
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    private boolean isCMYKColorant(PdfName colourant) {
        return PdfName.Cyan.equals(colourant) || PdfName.Magenta.equals(colourant) || PdfName.Yellow.equals(colourant) || PdfName.Black.equals(colourant);
    }

    private void checkPageContentsForColorUsages(PdfDictionary pageDict, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        PdfStream contentStream = pageDict.getAsStream(PdfName.Contents);
        if (contentStream != null) {
            this.checkContentForColorUsages(contentStream, pageIntentProfile, pageTransparencyBlendingCS);
        } else {
            PdfArray contentSteamArray = pageDict.getAsArray(PdfName.Contents);
            if (contentSteamArray != null) {
                for (int i = 0; i < contentSteamArray.size(); ++i) {
                    this.checkContentForColorUsages(contentSteamArray.get(i), pageIntentProfile, pageTransparencyBlendingCS);
                }
            }
        }
    }

    private void checkAnnotationsForColorUsages(PdfArray annotations, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        if (annotations == null) {
            return;
        }
        for (int i = 0; i < annotations.size(); ++i) {
            PdfDictionary annot = annotations.getAsDictionary(i);
            PdfDictionary ap = annot.getAsDictionary(PdfName.AP);
            if (ap == null) continue;
            this.checkAppearanceStreamForColorUsages(ap, pageIntentProfile, pageTransparencyBlendingCS);
        }
    }

    private void checkAppearanceStreamForColorUsages(PdfDictionary ap, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        this.checkContentForColorUsages(ap, pageIntentProfile, pageTransparencyBlendingCS);
        for (PdfObject val2 : ap.values()) {
            this.checkContentForColorUsages(val2, pageIntentProfile, pageTransparencyBlendingCS);
            if (val2.isDictionary()) {
                this.checkAppearanceStreamForColorUsages((PdfDictionary)val2, pageIntentProfile, pageTransparencyBlendingCS);
                continue;
            }
            if (!val2.isStream()) continue;
            this.checkObjectWithResourcesForColorUsages(val2, pageIntentProfile, pageTransparencyBlendingCS);
        }
    }

    private void checkObjectWithResourcesForColorUsages(PdfObject objectWithResources, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        this.checkContentForColorUsages(objectWithResources, pageIntentProfile, pageTransparencyBlendingCS);
        if (objectWithResources instanceof PdfDictionary) {
            this.checkResourcesForColorUsages(((PdfDictionary)objectWithResources).getAsDictionary(PdfName.Resources), pageIntentProfile, pageTransparencyBlendingCS);
        }
    }

    private void checkResourcesForColorUsages(PdfDictionary resources, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        if (resources != null) {
            this.checkSingleResourceTypeForColorUsages(resources.getAsDictionary(PdfName.XObject), pageIntentProfile, pageTransparencyBlendingCS);
            this.checkSingleResourceTypeForColorUsages(resources.getAsDictionary(PdfName.Pattern), pageIntentProfile, pageTransparencyBlendingCS);
        }
    }

    private void checkSingleResourceTypeForColorUsages(PdfDictionary singleResourceDict, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        if (singleResourceDict != null) {
            for (PdfObject resource : singleResourceDict.values()) {
                this.checkObjectWithResourcesForColorUsages(resource, pageIntentProfile, pageTransparencyBlendingCS);
            }
        }
    }

    private void checkContentForColorUsages(PdfObject pdfObject, PdfStream pageIntentProfile, PdfColorSpace pageTransparencyBlendingCS) {
        PdfColorSpace currentTransparencyBlendingCS;
        String pageIntentCSType = pageIntentProfile == null ? null : IccProfile.getIccColorSpaceName(pageIntentProfile.getBytes());
        PdfColorSpace pdfColorSpace = currentTransparencyBlendingCS = pdfObject instanceof PdfDictionary ? PdfA4Checker.getDeviceIndependentTransparencyBlendingCSIfRbgOrCmykBased((PdfDictionary)pdfObject) : null;
        if (pageIntentCSType == null && pageTransparencyBlendingCS == null && currentTransparencyBlendingCS == null) {
            if (this.rgbUsedObjects.contains(pdfObject)) {
                throw new PdfAConformanceException("DeviceRGB shall only be used if a device independent DefaultRGB colour space has been set when the DeviceRGB colour space is used or if the current transparency blending space, when the DeviceRGB colour space is used, is a device independent RGB-based colour space or the current PDF/A OutputIntent, when the DeviceRGB colour space is used, contains an \u2018RGB \u2019 destination profile.");
            }
            if (this.cmykUsedObjects.contains(pdfObject)) {
                throw new PdfAConformanceException("DeviceCMYK shall only be used if a device independent DefaultCMYK colour space has been set when the DeviceCMYK colour space is used or if the current transparency blending space, when the DeviceCMYK colour space is used, is a device independent CMYK-based colour space or the current PDF/A OutputIntent, when the DeviceCMYK colour space is used, contains a \u2018CMYK\u2019 destination profile.");
            }
        }
        if (this.grayUsedObjects.contains(pdfObject) && pageIntentCSType == null) {
            throw new PdfAConformanceException("DeviceGray shall only be used if a device independent DefaultGray colour space has been set when the DeviceGray colour space is used, or if a PDF/A OutputIntent is in effect.");
        }
        String pageTransparencyBlendingCSType = PdfA4Checker.getColorspaceTypeIfIccBasedOrCalRgb(pageTransparencyBlendingCS);
        String currentTransparencyBlendingCSType = PdfA4Checker.getColorspaceTypeIfIccBasedOrCalRgb(currentTransparencyBlendingCS);
        if (!(!this.rgbUsedObjects.contains(pdfObject) || "RGB ".equals(pageIntentCSType) || "RGB ".equals(pageTransparencyBlendingCSType) || "RGB ".equals(currentTransparencyBlendingCSType) || CALRGB_COLOR_SPACE.equals(pageTransparencyBlendingCSType) || CALRGB_COLOR_SPACE.equals(currentTransparencyBlendingCSType))) {
            throw new PdfAConformanceException("DeviceRGB shall only be used if a device independent DefaultRGB colour space has been set when the DeviceRGB colour space is used or if the current transparency blending space, when the DeviceRGB colour space is used, is a device independent RGB-based colour space or the current PDF/A OutputIntent, when the DeviceRGB colour space is used, contains an \u2018RGB \u2019 destination profile.");
        }
        if (this.cmykUsedObjects.contains(pdfObject) && !"CMYK".equals(pageIntentCSType) && !"CMYK".equals(pageTransparencyBlendingCSType) && !"CMYK".equals(currentTransparencyBlendingCSType)) {
            throw new PdfAConformanceException("DeviceCMYK shall only be used if a device independent DefaultCMYK colour space has been set when the DeviceCMYK colour space is used or if the current transparency blending space, when the DeviceCMYK colour space is used, is a device independent CMYK-based colour space or the current PDF/A OutputIntent, when the DeviceCMYK colour space is used, contains a \u2018CMYK\u2019 destination profile.");
        }
        List<PdfStream> currentICCBasedProfiles = this.iccBasedCmykObjects.get(pdfObject);
        if (currentICCBasedProfiles == null) {
            return;
        }
        for (PdfStream currentICCBasedProfile : currentICCBasedProfiles) {
            PdfStream iccStream;
            PdfA4Checker.throwIfIdenticalProfiles(currentICCBasedProfile, pageIntentProfile);
            if ("CMYK".equals(currentTransparencyBlendingCSType)) {
                iccStream = ((PdfArray)currentTransparencyBlendingCS.getPdfObject()).getAsStream(1);
                PdfA4Checker.throwIfIdenticalProfiles(currentICCBasedProfile, iccStream);
            }
            if (!"CMYK".equals(pageTransparencyBlendingCSType)) continue;
            iccStream = ((PdfArray)pageTransparencyBlendingCS.getPdfObject()).getAsStream(1);
            PdfA4Checker.throwIfIdenticalProfiles(currentICCBasedProfile, iccStream);
        }
    }

    private static void throwIfIdenticalProfiles(PdfStream iccBasedProfile1, PdfStream iccBasedProfile2) {
        if (iccBasedProfile1 != null && iccBasedProfile2 != null && (iccBasedProfile1.equals(iccBasedProfile2) || Arrays.equals(iccBasedProfile1.getBytes(), iccBasedProfile2.getBytes()))) {
            throw new PdfAConformanceException("An ICCBased colour space shall not be used where the profile is a CMYK destination profile and is identical to that in the current PDF/A OutputIntent or the current transparency blending colorspace.");
        }
    }

    private static String getColorspaceTypeIfIccBasedOrCalRgb(PdfColorSpace colorspace) {
        if (colorspace instanceof PdfCieBasedCs.CalRgb) {
            return CALRGB_COLOR_SPACE;
        }
        if (colorspace instanceof PdfCieBasedCs.IccBased) {
            PdfStream iccStream = ((PdfArray)colorspace.getPdfObject()).getAsStream(1);
            return IccProfile.getIccColorSpaceName(iccStream.getBytes());
        }
        return null;
    }

    private static PdfColorSpace getDeviceIndependentTransparencyBlendingCSIfRbgOrCmykBased(PdfDictionary pageDict) {
        if (!PdfA4Checker.isContainsTransparencyGroup(pageDict)) {
            return null;
        }
        PdfObject cs = pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS);
        if (cs == null) {
            return null;
        }
        PdfColorSpace transparencyBlendingCS = PdfColorSpace.makeColorSpace(cs);
        if (transparencyBlendingCS instanceof PdfCieBasedCs.CalRgb || transparencyBlendingCS instanceof PdfCieBasedCs.IccBased) {
            return transparencyBlendingCS;
        }
        return null;
    }
}

