/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;

public class PdfUAValidationContext {
    private final PdfDocument pdfDocument;

    public PdfUAValidationContext(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    public String resolveToStandardRole(IStructureNode node) {
        if (node == null) {
            return null;
        }
        PdfName originalRole = node.getRole();
        if (originalRole == null) {
            return null;
        }
        return this.resolveToStandardRole(originalRole.getValue());
    }

    public String resolveToStandardRole(String role) {
        if (role == null) {
            return null;
        }
        IRoleMappingResolver resolver = this.pdfDocument.getTagStructureContext().resolveMappingToStandardOrDomainSpecificRole(role, null);
        if (resolver == null) {
            return role;
        }
        return resolver.getRole();
    }

    public PdfStructElem getElementIfRoleMatches(PdfName role, IStructureNode structureNode) {
        if (structureNode == null) {
            return null;
        }
        if (!(structureNode instanceof PdfStructElem)) {
            return null;
        }
        if (role.equals(structureNode.getRole()) || role.getValue().equals(this.resolveToStandardRole(structureNode))) {
            return (PdfStructElem)structureNode;
        }
        return null;
    }
}

