/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.tables;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.pdfua.checkers.utils.tables.ITableIterator;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class AbstractResultMatrix<T> {
    protected final ITableIterator<T> iterator;
    private final List<T> cellMatrix;
    private final int rows;
    private final int cols;

    protected AbstractResultMatrix(ITableIterator<T> iterator) {
        this.rows = iterator.getAmountOfRowsHeader() + iterator.getAmountOfRowsBody() + iterator.getAmountOfRowsFooter();
        this.cols = iterator.getNumberOfColumns();
        this.iterator = iterator;
        this.cellMatrix = AbstractResultMatrix.createFixedSizedList(this.rows * this.cols, null);
    }

    public void checkValidTableTagging() {
        HashSet<String> knownIds = new HashSet<String>();
        List<Boolean> scopeMatrix = AbstractResultMatrix.createFixedSizedList(this.rows * this.cols, false);
        boolean hasUnknownHeaders = false;
        while (this.iterator.hasNext()) {
            T cell = this.iterator.next();
            String role = this.getRole(cell);
            int rowspan = this.iterator.getRowspan();
            int colspan = this.iterator.getColspan();
            int colIdx = this.iterator.getCol();
            int rowIdx = this.iterator.getRow();
            this.setCell(rowIdx, rowspan, colIdx, colspan, this.cellMatrix, cell);
            if ("TH".equals(role)) {
                byte[] id = this.getElementId(cell);
                if (id != null) {
                    knownIds.add(new String(id, StandardCharsets.UTF_8));
                }
                String scope = this.getScope(cell);
                if (PdfName.Column.getValue().equals(scope)) {
                    this.setColumnValue(colIdx, colspan, scopeMatrix, true);
                    continue;
                }
                if (PdfName.Row.getValue().equals(scope)) {
                    this.setRowValue(rowIdx, rowspan, scopeMatrix, true);
                    continue;
                }
                if (PdfName.Both.getValue().equals(scope)) {
                    this.setColumnValue(colIdx, colspan, scopeMatrix, true);
                    this.setRowValue(rowIdx, rowspan, scopeMatrix, true);
                    continue;
                }
                hasUnknownHeaders = true;
                continue;
            }
            if ("TD".equals(role)) continue;
            String message = MessageFormatUtil.format("Cell: row {0} ({1}) col {2} has invalid role.", this.getNormalizedRow(rowIdx), this.getLocationInTable(rowIdx), colIdx);
            throw new PdfUAConformanceException(message);
        }
        this.validateTableCells(knownIds, scopeMatrix, hasUnknownHeaders);
    }

    private void setRowValue(int row, int rowSpan, List<Boolean> arr, boolean value) {
        this.setCell(row, rowSpan, 0, this.cols, arr, value);
    }

    abstract List<byte[]> getHeaders(T var1);

    abstract String getScope(T var1);

    abstract byte[] getElementId(T var1);

    abstract String getRole(T var1);

    private void validateTableCells(Set<String> knownIds, List<Boolean> scopeMatrix, boolean hasUnknownHeaders) {
        StringBuilder sb = new StringBuilder();
        boolean areAllTDCellsValid = true;
        for (int i = 0; i < this.cellMatrix.size(); ++i) {
            boolean hasConnectedHeader;
            T cell = this.cellMatrix.get(i);
            if (cell == null) {
                String message = MessageFormatUtil.format("Cell: row {0} ({1}) col {2} is empty, each row should have the same amount of columns when taking into account spanning.", this.getNormalizedRow(i), this.getLocationInTable(i), i % this.cols);
                throw new PdfUAConformanceException(message);
            }
            String role = this.getRole(cell);
            if (!"TD".equals(role) || this.hasValidHeaderIds(cell, knownIds) || (hasConnectedHeader = scopeMatrix.get(i).booleanValue()) || !hasUnknownHeaders) continue;
            areAllTDCellsValid = false;
            int row = i / this.cols;
            int col = i % this.cols;
            String location = this.getLocationInTable(row);
            String message = MessageFormatUtil.format("TD cell row:{0} col:{1} in table {2} does not contain a valid Headers attribute, and Headers for this cell cannot be determined algorithmically.", this.getNormalizedRow(row), col, location);
            sb.append(message).append('\n');
        }
        if (!areAllTDCellsValid) {
            throw new PdfUAConformanceException(sb.toString());
        }
    }

    private String getLocationInTable(int row) {
        if (row < this.iterator.getAmountOfRowsHeader()) {
            return "Header";
        }
        if (row < this.iterator.getAmountOfRowsHeader() + this.iterator.getAmountOfRowsBody()) {
            return "Body";
        }
        return "Footer";
    }

    private int getNormalizedRow(int row) {
        if (row < this.iterator.getAmountOfRowsHeader()) {
            return row;
        }
        if (row < this.iterator.getAmountOfRowsHeader() + this.iterator.getAmountOfRowsBody()) {
            return row - this.iterator.getAmountOfRowsHeader();
        }
        return row - this.iterator.getAmountOfRowsHeader() - this.iterator.getAmountOfRowsBody();
    }

    private <Z> void setCell(int row, int rowSpan, int col, int colSpan, List<Z> arr, Z value) {
        for (int i = row; i < row + rowSpan; ++i) {
            for (int j = col; j < col + colSpan; ++j) {
                arr.set(i * this.cols + j, value);
            }
        }
    }

    private void setColumnValue(int col, int colSpan, List<Boolean> arr, boolean value) {
        this.setCell(0, this.rows, col, colSpan, arr, value);
    }

    private boolean hasValidHeaderIds(T cell, Set<String> knownIds) {
        List<byte[]> headers = this.getHeaders(cell);
        if (headers == null) {
            return false;
        }
        if (headers.isEmpty()) {
            return false;
        }
        for (byte[] knownId : headers) {
            if (knownIds.contains(new String(knownId, StandardCharsets.UTF_8))) continue;
            return false;
        }
        return true;
    }

    private static <Z> List<Z> createFixedSizedList(int capacity, Object defaultValue) {
        ArrayList<Object> arr = new ArrayList<Object>(capacity);
        for (int i = 0; i < capacity; ++i) {
            arr.add(defaultValue);
        }
        return arr;
    }
}

