/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.tables;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.AbstractResultMatrix;
import com.itextpdf.pdfua.checkers.utils.tables.TableStructElementIterator;
import java.util.ArrayList;
import java.util.List;

class StructTreeResultMatrix
extends AbstractResultMatrix<PdfStructElem> {
    public StructTreeResultMatrix(PdfStructElem elem, PdfUAValidationContext context) {
        super(new TableStructElementIterator(elem, context));
    }

    @Override
    List<byte[]> getHeaders(PdfStructElem cell) {
        PdfObject object = cell.getAttributes(false);
        PdfArray pdfArr = null;
        if (object instanceof PdfArray) {
            PdfArray array = (PdfArray)object;
            for (PdfObject pdfObject : array) {
                if (!(pdfObject instanceof PdfDictionary)) continue;
                pdfArr = ((PdfDictionary)pdfObject).getAsArray(PdfName.Headers);
            }
        } else if (object instanceof PdfDictionary) {
            pdfArr = ((PdfDictionary)object).getAsArray(PdfName.Headers);
        }
        if (pdfArr == null) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (PdfObject pdfObject : pdfArr) {
            PdfString str = (PdfString)pdfObject;
            list.add(str.getValueBytes());
        }
        return list;
    }

    @Override
    String getScope(PdfStructElem cell) {
        PdfName f;
        PdfObject object = cell.getAttributes(false);
        if (object instanceof PdfArray) {
            PdfArray array = (PdfArray)object;
            for (PdfObject pdfObject : array) {
                PdfName f2;
                if (!(pdfObject instanceof PdfDictionary) || (f2 = ((PdfDictionary)pdfObject).getAsName(PdfName.Scope)) == null) continue;
                return f2.getValue();
            }
        } else if (object instanceof PdfDictionary && (f = ((PdfDictionary)object).getAsName(PdfName.Scope)) != null) {
            return f.getValue();
        }
        return null;
    }

    @Override
    byte[] getElementId(PdfStructElem cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getStructureElementId() == null) {
            return null;
        }
        return cell.getStructureElementId().getValueBytes();
    }

    @Override
    String getRole(PdfStructElem cell) {
        return ((TableStructElementIterator)this.iterator).context.resolveToStandardRole(cell);
    }
}

