/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.tables;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.layout.element.Table;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.CellResultMatrix;
import com.itextpdf.pdfua.checkers.utils.tables.StructTreeResultMatrix;

public final class TableCheckUtil {
    private final PdfUAValidationContext context;

    public TableCheckUtil(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkTable(Table table) {
        new CellResultMatrix(table, this.context);
    }

    public static class TableHandler
    extends ContextAwareTagTreeIteratorHandler {
        public TableHandler(PdfUAValidationContext context) {
            super(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            PdfStructElem table = this.context.getElementIfRoleMatches(PdfName.Table, elem);
            if (table == null) {
                return;
            }
            new StructTreeResultMatrix((PdfStructElem)elem, this.context).checkValidTableTagging();
        }
    }
}

