/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.mac;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IDERSequence;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.AbstractMacIntegrityProtector;
import com.itextpdf.kernel.mac.MacProperties;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEvent;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEventHandler;
import com.itextpdf.signatures.mac.SignatureContainerGenerationEvent;
import com.itextpdf.signatures.mac.SignatureDocumentClosingEvent;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

class SignatureMacIntegrityProtector
extends AbstractMacIntegrityProtector {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final String ID_ATTR_PDF_MAC_DATA = "1.0.32004.1.2";

    SignatureMacIntegrityProtector(PdfDocument document, MacProperties macProperties) {
        super(document, macProperties);
    }

    SignatureMacIntegrityProtector(PdfDocument document, PdfDictionary authDictionary) {
        super(document, authDictionary);
    }

    void prepareDocument() {
        this.document.addEventHandler("StartSignaturePreClose", new SignatureMacPdfObjectAdder());
        this.document.addEventHandler("StartSignatureContainerGeneration", new SignatureMacContainerEmbedder());
    }

    private void embedMacContainerInUnsignedAttributes(IASN1EncodableVector unsignedAttributes, InputStream documentInputStream, byte[] signature) throws IOException {
        IDERSequence mac;
        try {
            byte[] dataDigest = this.digestBytes(documentInputStream);
            mac = this.createMacContainer(dataDigest, SignatureMacIntegrityProtector.generateRandomBytes(32), signature);
        }
        catch (GeneralSecurityException e) {
            throw new PdfException("Exception occurred during MAC container generation.", e);
        }
        IASN1EncodableVector macAttribute = BC_FACTORY.createASN1EncodableVector();
        macAttribute.add(BC_FACTORY.createASN1ObjectIdentifier(ID_ATTR_PDF_MAC_DATA));
        macAttribute.add(BC_FACTORY.createDERSet(mac));
        unsignedAttributes.add(BC_FACTORY.createDERSequence(macAttribute));
    }

    private final class SignatureMacContainerEmbedder
    extends AbstractPdfDocumentEventHandler {
        private SignatureMacContainerEmbedder() {
        }

        @Override
        public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
            if (event instanceof SignatureContainerGenerationEvent) {
                SignatureContainerGenerationEvent signatureEvent = (SignatureContainerGenerationEvent)event;
                try {
                    SignatureMacIntegrityProtector.this.embedMacContainerInUnsignedAttributes(signatureEvent.getUnsignedAttributes(), signatureEvent.getDocumentInputStream(), signatureEvent.getSignature());
                }
                catch (IOException e) {
                    throw new PdfException("IOException occurred while trying to embed MAC container into document output stream.", e);
                }
            }
        }
    }

    private final class SignatureMacPdfObjectAdder
    extends AbstractPdfDocumentEventHandler {
        private SignatureMacPdfObjectAdder() {
        }

        @Override
        public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
            if (event instanceof SignatureDocumentClosingEvent) {
                PdfDictionary signatureMacDictionary = new PdfDictionary();
                signatureMacDictionary.put(PdfName.MACLocation, PdfName.AttachedToSig);
                signatureMacDictionary.put(PdfName.SigObjRef, ((SignatureDocumentClosingEvent)event).getSignatureReference());
                SignatureMacIntegrityProtector.this.document.getTrailer().put(PdfName.AuthCode, signatureMacDictionary);
            }
        }
    }
}

