/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.extensions;

import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class CertificateExtension {
    public static final String EXCEPTION_OCCURRED = " but an exception occurred {0}:{1}.";
    public static final String EXTENSION_NOT_FOUND = " but no extension with that id was found.";
    public static final String FOUND_VALUE = " but found value ";
    public static final String EXPECTED_EXTENSION_ID_AND_VALUE = "Expected extension with id {0} and value {1} {1} {2}";
    private final String extensionOid;
    private final IASN1Primitive extensionValue;
    private String errorMessage = "";

    public CertificateExtension(String extensionOid, IASN1Primitive extensionValue) {
        this.extensionOid = extensionOid;
        this.extensionValue = extensionValue;
    }

    public IASN1Primitive getExtensionValue() {
        return this.extensionValue;
    }

    public String getExtensionOid() {
        return this.extensionOid;
    }

    public String getMessage() {
        return MessageFormatUtil.format(EXPECTED_EXTENSION_ID_AND_VALUE, this.getExtensionOid(), this.getExtensionValue().toString(), this.errorMessage);
    }

    public boolean existsInCertificate(X509Certificate certificate) {
        IASN1Primitive providedExtensionValue;
        try {
            providedExtensionValue = CertificateUtil.getExtensionValue(certificate, this.extensionOid);
        }
        catch (IOException | RuntimeException e) {
            this.errorMessage = MessageFormatUtil.format(EXCEPTION_OCCURRED, e.getClass().getName(), e.getMessage());
            return false;
        }
        if (providedExtensionValue == null) {
            if (this.extensionValue == null) {
                return true;
            }
            this.errorMessage = EXTENSION_NOT_FOUND;
            return false;
        }
        if (Objects.equals(providedExtensionValue, this.extensionValue)) {
            return true;
        }
        this.errorMessage = FOUND_VALUE + MessageFormatUtil.format(" but found value {0}.", this.extensionValue.toString());
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateExtension that = (CertificateExtension)o;
        return Objects.equals(this.extensionOid, that.extensionOid) && Objects.equals(this.extensionValue, that.extensionValue);
    }

    public int hashCode() {
        return Objects.hash(this.extensionOid, this.extensionValue);
    }
}

