/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.media;

import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Objects;

public class MediaExpression {
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private boolean minPrefix;
    private boolean maxPrefix;
    private String feature;
    private String value;

    MediaExpression(String feature, String value) {
        this.feature = feature.trim().toLowerCase();
        if (value != null) {
            this.value = value.trim().toLowerCase();
        }
        String minPref = "min-";
        String maxPref = "max-";
        this.minPrefix = feature.startsWith(minPref);
        if (this.minPrefix) {
            this.feature = feature.substring(minPref.length());
        }
        this.maxPrefix = feature.startsWith(maxPref);
        if (this.maxPrefix) {
            this.feature = feature.substring(maxPref.length());
        }
    }

    public boolean matches(MediaDeviceDescription deviceDescription) {
        switch (this.feature) {
            case "color": {
                Integer val2 = CssDimensionParsingUtils.parseInteger(this.value);
                if (this.minPrefix) {
                    return val2 != null && deviceDescription.getBitsPerComponent() >= val2;
                }
                if (this.maxPrefix) {
                    return val2 != null && deviceDescription.getBitsPerComponent() <= val2;
                }
                return val2 == null ? deviceDescription.getBitsPerComponent() != 0 : val2.intValue() == deviceDescription.getBitsPerComponent();
            }
            case "color-index": {
                Integer val3 = CssDimensionParsingUtils.parseInteger(this.value);
                if (this.minPrefix) {
                    return val3 != null && deviceDescription.getColorIndex() >= val3;
                }
                if (this.maxPrefix) {
                    return val3 != null && deviceDescription.getColorIndex() <= val3;
                }
                return val3 == null ? deviceDescription.getColorIndex() != 0 : val3.intValue() == deviceDescription.getColorIndex();
            }
            case "aspect-ratio": {
                int[] aspectRatio = CssDimensionParsingUtils.parseAspectRatio(this.value);
                if (this.minPrefix) {
                    return aspectRatio != null && (float)aspectRatio[0] * deviceDescription.getHeight() >= (float)aspectRatio[1] * deviceDescription.getWidth();
                }
                if (this.maxPrefix) {
                    return aspectRatio != null && (float)aspectRatio[0] * deviceDescription.getHeight() <= (float)aspectRatio[1] * deviceDescription.getWidth();
                }
                return aspectRatio != null && CssUtils.compareFloats((float)aspectRatio[0] * deviceDescription.getHeight(), (float)aspectRatio[1] * deviceDescription.getWidth());
            }
            case "grid": {
                Integer val4 = CssDimensionParsingUtils.parseInteger(this.value);
                return val4 != null && val4 == 0 && !deviceDescription.isGrid() || deviceDescription.isGrid();
            }
            case "scan": {
                return Objects.equals(this.value, deviceDescription.getScan());
            }
            case "orientation": {
                return Objects.equals(this.value, deviceDescription.getOrientation());
            }
            case "monochrome": {
                Integer val5 = CssDimensionParsingUtils.parseInteger(this.value);
                if (this.minPrefix) {
                    return val5 != null && deviceDescription.getMonochrome() >= val5;
                }
                if (this.maxPrefix) {
                    return val5 != null && deviceDescription.getMonochrome() <= val5;
                }
                return val5 == null ? deviceDescription.getMonochrome() > 0 : val5.intValue() == deviceDescription.getMonochrome();
            }
            case "height": {
                float val6 = MediaExpression.parseAbsoluteLength(this.value);
                if (this.minPrefix) {
                    return deviceDescription.getHeight() >= val6;
                }
                if (this.maxPrefix) {
                    return deviceDescription.getHeight() <= val6;
                }
                return deviceDescription.getHeight() > 0.0f;
            }
            case "width": {
                float val7 = MediaExpression.parseAbsoluteLength(this.value);
                if (this.minPrefix) {
                    return deviceDescription.getWidth() >= val7;
                }
                if (this.maxPrefix) {
                    return deviceDescription.getWidth() <= val7;
                }
                return deviceDescription.getWidth() > 0.0f;
            }
            case "resolution": {
                float val8 = CssDimensionParsingUtils.parseResolution(this.value);
                if (this.minPrefix) {
                    return deviceDescription.getResolution() >= val8;
                }
                if (this.maxPrefix) {
                    return deviceDescription.getResolution() <= val8;
                }
                return deviceDescription.getResolution() > 0.0f;
            }
        }
        return false;
    }

    private static float parseAbsoluteLength(String value) {
        if (CssTypesValidationUtils.isRelativeValue(value)) {
            return CssDimensionParsingUtils.parseRelativeValue(value, 12.0f);
        }
        return CssDimensionParsingUtils.parseAbsoluteLength(value);
    }
}

