/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssEnumValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnRuleShortHandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnRuleShortHandResolver.class);
    private final CssEnumValidator borderStyleValidators = new CssEnumValidator(CommonCssConstants.BORDER_STYLE_VALUES);
    private final CssEnumValidator borderWithValidators = new CssEnumValidator(CommonCssConstants.BORDER_WIDTH_VALUES);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression = shorthandExpression.trim())) {
            return Arrays.asList(new CssDeclaration("column-rule-color", shorthandExpression), new CssDeclaration("column-rule-width", shorthandExpression), new CssDeclaration("column-rule-style", shorthandExpression));
        }
        if (CssTypesValidationUtils.containsInitialOrInheritOrUnset(shorthandExpression)) {
            return ColumnRuleShortHandResolver.handleExpressionError("Invalid css property declaration: {0}", "column-rule", shorthandExpression);
        }
        if (shorthandExpression.isEmpty()) {
            return ColumnRuleShortHandResolver.handleExpressionError("{0} shorthand property cannot be empty.", "column-rule", shorthandExpression);
        }
        int maxProperties = 3;
        List<String> properties = CssUtils.extractShorthandProperties(shorthandExpression).get(0);
        if (properties.size() > 3) {
            return ColumnRuleShortHandResolver.handleExpressionError("Invalid css property declaration: {0}", "column-rule", shorthandExpression);
        }
        ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>(3);
        for (String property : properties) {
            String cleanProperty = property.trim();
            CssDeclaration declaration = this.processProperty(cleanProperty);
            if (declaration != null) {
                result.add(declaration);
            }
            if (declaration != null) continue;
            return ColumnRuleShortHandResolver.handleExpressionError("Invalid css property declaration: {0}", "column-rule-style", shorthandExpression);
        }
        return result;
    }

    private CssDeclaration processProperty(String value) {
        if (CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isRelativeValue(value) || this.borderWithValidators.isValid(value)) {
            return new CssDeclaration("column-rule-width", value);
        }
        if (CssTypesValidationUtils.isColorProperty(value)) {
            return new CssDeclaration("column-rule-color", value);
        }
        if (this.borderStyleValidators.isValid(value)) {
            return new CssDeclaration("column-rule-style", value);
        }
        return null;
    }

    private static List<CssDeclaration> handleExpressionError(String logMessage, String attribute, String shorthandExpression) {
        LOGGER.warn(MessageFormatUtil.format(logMessage, attribute, shorthandExpression));
        return Collections.emptyList();
    }
}

