/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridTemplateShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridTemplateShorthandResolver.class);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        CssDeclarationValueTokenizer.Token token;
        if ((shorthandExpression = shorthandExpression.trim()).isEmpty()) {
            LOGGER.warn(MessageFormatUtil.format("{0} shorthand property cannot be empty.", "grid-template"));
            return new ArrayList<CssDeclaration>();
        }
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression) || "auto".equals(shorthandExpression) || "none".equals(shorthandExpression)) {
            return new ArrayList<CssDeclaration>();
        }
        StringBuilder rowsTemplateBuilder = new StringBuilder();
        StringBuilder areasBuilder = new StringBuilder();
        String columnsTemplate = "";
        String[] values = shorthandExpression.split("/");
        if (values.length == 2) {
            columnsTemplate = values[1];
        }
        CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(values[0]);
        boolean templateRowsEncountered = false;
        boolean previousTokenIsArea = false;
        int i = 0;
        while ((token = tokenizer.getNextValidToken()) != null) {
            if (token.isString() && !token.getValue().startsWith("[")) {
                if (previousTokenIsArea) {
                    rowsTemplateBuilder.append("auto").append(" ");
                }
                areasBuilder.append("'").append(token.getValue()).append("'").append(" ");
                previousTokenIsArea = true;
            } else {
                rowsTemplateBuilder.append(token.getValue()).append(" ");
                templateRowsEncountered = true;
                previousTokenIsArea = false;
            }
            ++i;
        }
        if (previousTokenIsArea) {
            rowsTemplateBuilder.append("auto").append(" ");
        }
        if (!templateRowsEncountered) {
            rowsTemplateBuilder.setLength(0);
        }
        String rowsTemplate = rowsTemplateBuilder.toString();
        String areas = areasBuilder.toString();
        ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>(3);
        if (!rowsTemplate.isEmpty()) {
            result.add(new CssDeclaration("grid-template-rows", rowsTemplate));
        }
        if (!columnsTemplate.isEmpty()) {
            result.add(new CssDeclaration("grid-template-columns", columnsTemplate));
        }
        if (!areas.isEmpty()) {
            result.add(new CssDeclaration("grid-template-areas", areas));
        }
        return result;
    }
}

