/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.jsoup.nodes;

import com.itextpdf.styledxmlparser.jsoup.helper.KeyVal;
import com.itextpdf.styledxmlparser.jsoup.nodes.Attributes;
import com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import com.itextpdf.styledxmlparser.jsoup.nodes.Node;
import com.itextpdf.styledxmlparser.jsoup.parser.Tag;
import com.itextpdf.styledxmlparser.jsoup.select.Elements;
import java.util.ArrayList;
import java.util.List;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String baseUri, Attributes attributes) {
        super(tag, baseUri, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    @Override
    protected void removeChild(Node out) {
        super.removeChild(out);
        this.elements.remove((Element)out);
    }

    public List<KeyVal> formData() {
        ArrayList<KeyVal> data = new ArrayList<KeyVal>();
        for (Element el : this.elements) {
            String type;
            String name;
            if (!el.tag().isFormSubmittable() || el.hasAttr("disabled") || (name = el.attr("name")).length() == 0 || (type = el.attr("type")).equalsIgnoreCase("button")) continue;
            if ("select".equals(el.normalName())) {
                Element option;
                Elements options = el.select("option[selected]");
                boolean set = false;
                for (Element option2 : options) {
                    data.add(KeyVal.create(name, option2.val()));
                    set = true;
                }
                if (set || (option = el.selectFirst("option")) == null) continue;
                data.add(KeyVal.create(name, option.val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase(type) || "radio".equalsIgnoreCase(type)) {
                if (!el.hasAttr("checked")) continue;
                String val2 = el.val().length() > 0 ? el.val() : "on";
                data.add(KeyVal.create(name, val2));
                continue;
            }
            data.add(KeyVal.create(name, el.val()));
        }
        return data;
    }

    @Override
    public Object clone() {
        return (FormElement)super.clone();
    }
}

