/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.css.SvgStrokeParameterConverter;
import com.itextpdf.svg.css.impl.SvgNodeRendererInheritanceResolver;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgPaintServer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractContainerSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSvgNodeRenderer
implements ISvgNodeRenderer {
    private static final MarkerVertexType[] MARKER_VERTEX_TYPES = new MarkerVertexType[]{MarkerVertexType.MARKER_START, MarkerVertexType.MARKER_MID, MarkerVertexType.MARKER_END};
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSvgNodeRenderer.class);
    protected Map<String, String> attributesAndStyles;
    boolean doFill = false;
    boolean doStroke = false;
    private ISvgNodeRenderer parent;

    @Override
    public void setParent(ISvgNodeRenderer parent) {
        this.parent = parent;
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return this.parent;
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
        this.attributesAndStyles = attributesAndStyles;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributesAndStyles.get(key);
    }

    public String getAttributeOrDefault(String key, String defaultValue) {
        String rawValue = this.getAttribute(key);
        return rawValue != null ? rawValue : defaultValue;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributesAndStyles == null) {
            this.attributesAndStyles = new HashMap<String, String>();
        }
        this.attributesAndStyles.put(key, value);
    }

    @Override
    public Map<String, String> getAttributeMapCopy() {
        HashMap<String, String> copy = new HashMap<String, String>();
        if (this.attributesAndStyles == null) {
            return copy;
        }
        copy.putAll(this.attributesAndStyles);
        return copy;
    }

    @Override
    public final void draw(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (this.attributesAndStyles != null) {
            AffineTransform transformation;
            if (this.isHidden()) {
                return;
            }
            String transformString = this.attributesAndStyles.get("transform");
            if (transformString != null && !transformString.isEmpty() && !(transformation = TransformUtils.parseTransform(transformString)).isIdentity()) {
                currentCanvas.concatMatrix(transformation);
                if (this.getParentClipPath() != null) {
                    context.getClippingElementTransform().concatenate(transformation);
                }
            }
            if (this.attributesAndStyles.containsKey("id")) {
                context.addUsedId(this.attributesAndStyles.get("id"));
            }
        }
        if (!this.drawInClipPath(context)) {
            this.preDraw(context);
            this.doDraw(context);
            this.postDraw(context);
        }
        if (this.attributesAndStyles.containsKey("id")) {
            context.removeUsedId(this.attributesAndStyles.get("id"));
        }
    }

    protected boolean canElementFill() {
        return true;
    }

    public boolean canConstructViewPort() {
        return false;
    }

    @Deprecated
    public float getCurrentFontSize() {
        return this.getCurrentFontSize(new SvgDrawContext(null, null));
    }

    public float getCurrentFontSize(SvgDrawContext context) {
        String fontSizeAttribute = this.getAttribute("font-size");
        if (CssTypesValidationUtils.isRemValue(fontSizeAttribute)) {
            return CssDimensionParsingUtils.parseRelativeValue(fontSizeAttribute, context.getCssContext().getRootFontSize());
        }
        if (CssTypesValidationUtils.isEmValue(fontSizeAttribute) && this.getParent() != null && this.getParent() instanceof AbstractSvgNodeRenderer) {
            return CssDimensionParsingUtils.parseRelativeValue(fontSizeAttribute, ((AbstractSvgNodeRenderer)this.getParent()).getCurrentFontSize(context));
        }
        return CssDimensionParsingUtils.parseAbsoluteFontSize(fontSizeAttribute);
    }

    public Rectangle getCurrentViewBox(SvgDrawContext context) {
        if (this instanceof AbstractContainerSvgNodeRenderer) {
            float[] viewBoxValues = SvgCssUtils.parseViewBox(this);
            if (viewBoxValues == null || viewBoxValues.length < 4) {
                Rectangle currentViewPort = context.getCurrentViewPort();
                viewBoxValues = new float[]{0.0f, 0.0f, currentViewPort.getWidth(), currentViewPort.getHeight()};
            }
            return new Rectangle(viewBoxValues[0], viewBoxValues[1], viewBoxValues[2], viewBoxValues[3]);
        }
        if (this.getParent() instanceof AbstractSvgNodeRenderer) {
            return ((AbstractSvgNodeRenderer)this.getParent()).getCurrentViewBox(context);
        }
        return context.getCurrentViewPort();
    }

    protected void deepCopyAttributesAndStyles(ISvgNodeRenderer deepCopy) {
        HashMap<String, String> stylesDeepCopy = new HashMap<String, String>();
        if (this.attributesAndStyles != null) {
            stylesDeepCopy.putAll(this.attributesAndStyles);
            deepCopy.setAttributesAndStyles(stylesDeepCopy);
        }
    }

    protected abstract void doDraw(SvgDrawContext var1);

    String[] retrieveAlignAndMeet() {
        String meetOrSlice = "meet";
        String align = "xmidymid";
        String preserveAspectRatioValue = this.attributesAndStyles.get("preserveAspectRatio");
        if (preserveAspectRatioValue == null) {
            preserveAspectRatioValue = this.attributesAndStyles.get("preserveAspectRatio".toLowerCase());
        }
        if (this.attributesAndStyles.containsKey("preserveAspectRatio") || this.attributesAndStyles.containsKey("preserveAspectRatio".toLowerCase())) {
            List<String> aspectRatioValuesSplitValues = SvgCssUtils.splitValueList(preserveAspectRatioValue);
            align = aspectRatioValuesSplitValues.get(0).toLowerCase();
            if (aspectRatioValuesSplitValues.size() > 1) {
                meetOrSlice = aspectRatioValuesSplitValues.get(1).toLowerCase();
            }
        }
        if (this instanceof MarkerSvgNodeRenderer && !"none".equals(align) && "meet".equals(meetOrSlice)) {
            align = "xminymin";
        }
        return new String[]{align, meetOrSlice};
    }

    protected boolean isHidden() {
        return "none".equals(this.attributesAndStyles.get("display")) || "hidden".equals(this.attributesAndStyles.get("visibility"));
    }

    ClipPathSvgNodeRenderer getParentClipPath() {
        if (this instanceof ClipPathSvgNodeRenderer) {
            return (ClipPathSvgNodeRenderer)this;
        }
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent() instanceof AbstractSvgNodeRenderer) {
            return ((AbstractSvgNodeRenderer)this.getParent()).getParentClipPath();
        }
        return null;
    }

    AffineTransform applyNonScalingStrokeTransform(SvgDrawContext context) {
        boolean isNonScalingStroke;
        AffineTransform transform = null;
        boolean bl = isNonScalingStroke = this.doStroke && "non-scaling-stroke".equals(this.getAttribute("vector-effect"));
        if (isNonScalingStroke) {
            transform = context.getConcatenatedTransform();
            try {
                context.getCurrentCanvas().concatMatrix(transform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                LOGGER.warn("Unable to get inverse transformation matrix and thus apply non-scaling-stroke vector-effect property: some of the transformation matrices, written to the document, have a determinant of zero value.");
                transform = null;
            }
        }
        return transform;
    }

    AffineTransform calculateViewPortTranslation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        AffineTransform transform = AffineTransform.getTranslateInstance(viewPort.getX(), viewPort.getY());
        return transform;
    }

    void postDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this instanceof ISvgTextNodeRenderer) {
                return;
            }
            if (this.getParentClipPath() == null) {
                if (this.doFill && this.canElementFill()) {
                    String fillRuleRawValue = this.getAttribute("fill-rule");
                    this.doStrokeOrFill(fillRuleRawValue, currentCanvas);
                } else if (this.doStroke) {
                    currentCanvas.stroke();
                } else {
                    currentCanvas.endPath();
                }
            } else {
                if ("evenodd".equalsIgnoreCase(this.getAttribute("clip-rule"))) {
                    currentCanvas.eoClip();
                } else {
                    currentCanvas.clip();
                }
                currentCanvas.endPath();
            }
            if (this instanceof IMarkerCapable) {
                for (MarkerVertexType markerVertexType : MARKER_VERTEX_TYPES) {
                    if (!this.attributesAndStyles.containsKey(markerVertexType.toString())) continue;
                    ((IMarkerCapable)((Object)this)).drawMarker(context, markerVertexType);
                }
            }
        }
    }

    void doStrokeOrFill(String fillRuleRawValue, PdfCanvas currentCanvas) {
        if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
            if (this.doStroke) {
                currentCanvas.eoFillStroke();
            } else {
                currentCanvas.eoFill();
            }
        } else if (this.doStroke) {
            currentCanvas.fillStroke();
        } else {
            currentCanvas.fill();
        }
    }

    void preDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.getParentClipPath() == null) {
            FillProperties fillProperties = this.calculateFillProperties(context);
            StrokeProperties strokeProperties = this.calculateStrokeProperties(context);
            this.applyFillAndStrokeProperties(fillProperties, strokeProperties, context);
        }
    }

    void applyFillAndStrokeProperties(FillProperties fillProperties, StrokeProperties strokeProperties, SvgDrawContext context) {
        PdfExtGState opacityGraphicsState = new PdfExtGState();
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (fillProperties != null) {
            currentCanvas.setFillColor(fillProperties.getColor());
            if (!CssUtils.compareFloats(fillProperties.getOpacity(), 1.0f)) {
                opacityGraphicsState.setFillOpacity(fillProperties.getOpacity());
            }
        }
        if (strokeProperties != null) {
            if (strokeProperties.getLineDashParameters() != null) {
                SvgStrokeParameterConverter.PdfLineDashParameters lineDashParameters = strokeProperties.getLineDashParameters();
                currentCanvas.setLineDash(lineDashParameters.getDashArray(), lineDashParameters.getDashPhase());
            }
            if (strokeProperties.getColor() != null) {
                currentCanvas.setStrokeColor(strokeProperties.getColor());
            }
            currentCanvas.setLineWidth(strokeProperties.getWidth());
            if (!CssUtils.compareFloats(strokeProperties.getOpacity(), 1.0f)) {
                opacityGraphicsState.setStrokeOpacity(strokeProperties.getOpacity());
            }
        }
        if (!((PdfDictionary)opacityGraphicsState.getPdfObject()).isEmpty()) {
            currentCanvas.setExtGState(opacityGraphicsState);
        }
    }

    protected float parseHorizontalLength(String length, SvgDrawContext context) {
        return SvgCssUtils.parseAbsoluteHorizontalLength(this, length, 0.0f, context);
    }

    protected float parseVerticalLength(String length, SvgDrawContext context) {
        return SvgCssUtils.parseAbsoluteVerticalLength(this, length, 0.0f, context);
    }

    @Deprecated
    protected float parseAbsoluteLength(String length, float percentBaseValue, float defaultValue, SvgDrawContext context) {
        return SvgCssUtils.parseAbsoluteLength(this, length, percentBaseValue, defaultValue, context);
    }

    private TransparentColor getColorFromAttributeValue(SvgDrawContext context, String rawColorValue, float objectBoundingBoxMargin, float parentOpacity) {
        String value;
        CssDeclarationValueTokenizer tokenizer;
        CssDeclarationValueTokenizer.Token token;
        if (rawColorValue == null) {
            return null;
        }
        if ("currentcolor".equals(rawColorValue.toLowerCase())) {
            rawColorValue = this.getAttributeOrDefault("color", "black");
        }
        if ((token = (tokenizer = new CssDeclarationValueTokenizer(rawColorValue)).getNextValidToken()) == null) {
            return null;
        }
        String tokenValue = token.getValue();
        boolean isUrlInvalid = false;
        if (tokenValue.startsWith("url(") && tokenValue.endsWith(")")) {
            String normalizedName = tokenValue.substring(4, tokenValue.length() - 1).trim();
            if ((normalizedName = CssUtils.extractUnquotedString(normalizedName)).startsWith("#")) {
                Color resolvedColor = null;
                float resolvedOpacity = 1.0f;
                ISvgNodeRenderer colorRenderer = context.getNamedObject(normalizedName = normalizedName.substring(1));
                if (colorRenderer instanceof AbstractSvgNodeRenderer && ((AbstractSvgNodeRenderer)colorRenderer).isHidden()) {
                    colorRenderer = null;
                }
                if (colorRenderer instanceof ISvgPaintServer) {
                    if (colorRenderer.getParent() == null) {
                        colorRenderer.setParent(this);
                    }
                    resolvedColor = ((ISvgPaintServer)colorRenderer).createColor(context, this.getObjectBoundingBox(context), objectBoundingBoxMargin, parentOpacity);
                }
                if (resolvedColor != null) {
                    return new TransparentColor(resolvedColor, resolvedOpacity);
                }
                if (colorRenderer == null) {
                    isUrlInvalid = true;
                }
            } else {
                isUrlInvalid = true;
            }
            token = tokenizer.getNextValidToken();
        } else if (tokenValue.startsWith("url(") && !tokenValue.contains(" ")) {
            isUrlInvalid = true;
            token = tokenizer.getNextValidToken();
        }
        if (token != null && !"none".equalsIgnoreCase(value = token.getValue())) {
            if (!CssDeclarationValidationMaster.checkDeclaration(new CssDeclaration("color", value))) {
                return new TransparentColor(new DeviceRgb(0.0f, 0.0f, 0.0f), 1.0f);
            }
            TransparentColor result = CssDimensionParsingUtils.parseColor(value);
            return new TransparentColor(result.getColor(), result.getOpacity() * parentOpacity);
        }
        if (isUrlInvalid) {
            return new TransparentColor(ColorConstants.BLACK, 0.0f);
        }
        return null;
    }

    private float getOpacityByAttributeName(String attributeName, float generalOpacity) {
        float opacity = generalOpacity;
        String opacityStr = this.getAttribute(attributeName);
        if (opacityStr != null && !"none".equalsIgnoreCase(opacityStr)) {
            float opacityValue = CssTypesValidationUtils.isPercentageValue(opacityStr) ? CssDimensionParsingUtils.parseRelativeValue(opacityStr, 1.0f) : (CssTypesValidationUtils.isNumber(opacityStr) ? CssDimensionParsingUtils.parseFloat(opacityStr).floatValue() : 1.0f);
            opacity *= opacityValue;
        }
        return opacity;
    }

    private boolean drawInClipPath(SvgDrawContext context) {
        String clipPathName;
        ISvgNodeRenderer template;
        if (this.attributesAndStyles.containsKey("clip-path") && (template = context.getNamedObject(this.normalizeLocalUrlName(clipPathName = this.attributesAndStyles.get("clip-path")))) instanceof ClipPathSvgNodeRenderer) {
            ClipPathSvgNodeRenderer clipPath = (ClipPathSvgNodeRenderer)template.createDeepCopy();
            if (clipPath.isHidden()) {
                return false;
            }
            SvgNodeRendererInheritanceResolver.applyInheritanceToSubTree(this, clipPath, context.getCssContext());
            clipPath.setClippedRenderer(this);
            clipPath.draw(context);
            return true;
        }
        return false;
    }

    private String normalizeLocalUrlName(String name) {
        return name.replace("url(#", "").replace(")", "").trim();
    }

    private float getOpacity() {
        float result = 1.0f;
        String opacityValue = this.getAttribute("opacity");
        if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
            result = Float.valueOf(opacityValue).floatValue();
        }
        if (this.parent != null && this.parent instanceof AbstractSvgNodeRenderer) {
            result *= ((AbstractSvgNodeRenderer)this.parent).getOpacity();
        }
        return result;
    }

    private FillProperties calculateFillProperties(SvgDrawContext context) {
        float generalOpacity = this.getOpacity();
        String fillRawValue = this.getAttributeOrDefault("fill", "black");
        boolean bl = this.doFill = !"none".equalsIgnoreCase(fillRawValue);
        if (this.doFill && this.canElementFill()) {
            float fillOpacity = this.getOpacityByAttributeName("fill-opacity", generalOpacity);
            Color fillColor = null;
            TransparentColor transparentColor = this.getColorFromAttributeValue(context, fillRawValue, 0.0f, fillOpacity);
            if (transparentColor != null) {
                fillColor = transparentColor.getColor();
                fillOpacity = transparentColor.getOpacity();
            }
            if (fillColor == null) {
                fillColor = ColorConstants.BLACK;
            }
            return new FillProperties(fillOpacity, fillColor);
        }
        return null;
    }

    private StrokeProperties calculateStrokeProperties(SvgDrawContext context) {
        String strokeRawValue = this.getAttributeOrDefault("stroke", "none");
        if (!"none".equalsIgnoreCase(strokeRawValue)) {
            String strokeWidthRawValue = this.getAttribute("stroke-width");
            float strokeWidth = -1.0f;
            if (strokeWidthRawValue != null) {
                strokeWidth = this.parseHorizontalLength(strokeWidthRawValue, context);
            }
            if (strokeWidth < 0.0f) {
                strokeWidth = 0.75f;
            }
            float generalOpacity = this.getOpacity();
            float strokeOpacity = this.getOpacityByAttributeName("stroke-opacity", generalOpacity);
            Color strokeColor = null;
            TransparentColor transparentColor = this.getColorFromAttributeValue(context, strokeRawValue, (float)((double)strokeWidth / 2.0), strokeOpacity);
            if (transparentColor != null) {
                strokeColor = transparentColor.getColor();
                strokeOpacity = transparentColor.getOpacity();
            }
            String strokeDashArrayRawValue = this.getAttribute("stroke-dasharray");
            String strokeDashOffsetRawValue = this.getAttribute("stroke-dashoffset");
            SvgStrokeParameterConverter.PdfLineDashParameters lineDashParameters = SvgStrokeParameterConverter.convertStrokeDashParameters(strokeDashArrayRawValue, strokeDashOffsetRawValue, this.getCurrentFontSize(context), context);
            if (strokeWidth > 0.0f) {
                this.doStroke = true;
                return new StrokeProperties(strokeColor, strokeWidth, strokeOpacity, lineDashParameters);
            }
        }
        return null;
    }

    static final class StrokeProperties {
        final Color color;
        final float width;
        final float opacity;
        final SvgStrokeParameterConverter.PdfLineDashParameters lineDashParameters;

        public StrokeProperties(Color color, float width, float opacity, SvgStrokeParameterConverter.PdfLineDashParameters lineDashParameters) {
            this.color = color;
            this.width = width;
            this.opacity = opacity;
            this.lineDashParameters = lineDashParameters;
        }

        public Color getColor() {
            return this.color;
        }

        public float getWidth() {
            return this.width;
        }

        public float getOpacity() {
            return this.opacity;
        }

        public SvgStrokeParameterConverter.PdfLineDashParameters getLineDashParameters() {
            return this.lineDashParameters;
        }
    }

    static final class FillProperties {
        final float opacity;
        final Color color;

        public FillProperties(float opacity, Color color) {
            this.opacity = opacity;
            this.color = color;
        }

        public float getOpacity() {
            return this.opacity;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

