/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;

public class ImageSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    public ISvgNodeRenderer createDeepCopy() {
        ImageSvgNodeRenderer copy = new ImageSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfXObject xObject;
        ResourceResolver resourceResolver = context.getResourceResolver();
        if (resourceResolver == null || this.attributesAndStyles == null) {
            return;
        }
        String uri = (String)this.attributesAndStyles.get("href");
        if (uri == null) {
            uri = (String)this.attributesAndStyles.get("xlink:href");
        }
        if ((xObject = resourceResolver.retrieveImage(uri)) == null) {
            return;
        }
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        float x = 0.0f;
        if (this.attributesAndStyles.containsKey("x")) {
            x = this.parseHorizontalLength((String)this.attributesAndStyles.get("x"), context);
        }
        float y = 0.0f;
        if (this.attributesAndStyles.containsKey("y")) {
            y = this.parseVerticalLength((String)this.attributesAndStyles.get("y"), context);
        }
        float width = -1.0f;
        if (this.attributesAndStyles.containsKey("width")) {
            width = this.parseHorizontalLength((String)this.attributesAndStyles.get("width"), context);
        }
        if (width < 0.0f) {
            width = CssUtils.convertPxToPts(xObject.getWidth());
        }
        float height = -1.0f;
        if (this.attributesAndStyles.containsKey("height")) {
            height = this.parseVerticalLength((String)this.attributesAndStyles.get("height"), context);
        }
        if (height < 0.0f) {
            height = CssUtils.convertPxToPts(xObject.getHeight());
        }
        if (width != 0.0f && height != 0.0f) {
            String[] alignAndMeet = this.retrieveAlignAndMeet();
            String align = alignAndMeet[0];
            String meetOrSlice = alignAndMeet[1];
            Rectangle currentViewPort = new Rectangle(0.0f, 0.0f, width, height);
            Rectangle viewBox = new Rectangle(0.0f, 0.0f, xObject.getWidth(), xObject.getHeight());
            Rectangle appliedViewBox = SvgCoordinateUtils.applyViewBox(viewBox, currentViewPort, align, meetOrSlice);
            float scaleWidth = appliedViewBox.getWidth() / viewBox.getWidth();
            float scaleHeight = appliedViewBox.getHeight() / viewBox.getHeight();
            float xOffset = appliedViewBox.getX() / scaleWidth - viewBox.getX();
            float yOffset = appliedViewBox.getY() / scaleHeight - viewBox.getY();
            x += xOffset;
            y += yOffset;
            width = appliedViewBox.getWidth();
            height = appliedViewBox.getHeight();
            if ("slice".equals(meetOrSlice)) {
                currentCanvas.saveState().rectangle(currentViewPort).clip().endPath().addXObjectWithTransformationMatrix(xObject, width, 0.0f, 0.0f, -height, x, y + height).restoreState();
                return;
            }
        }
        currentCanvas.addXObjectWithTransformationMatrix(xObject, width, 0.0f, 0.0f, -height, x, y + height);
    }
}

