/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PolylineSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IMarkerCapable {
    private Vector previousOrientationVector = new Vector(1.0f, 0.0f, 0.0f);
    protected List<Point> points = new ArrayList<Point>();

    protected List<Point> getPoints() {
        return this.points;
    }

    protected void setPoints(String pointsAttribute) {
        if (pointsAttribute == null) {
            return;
        }
        List<String> points = SvgCssUtils.splitValueList(pointsAttribute);
        if (points.size() % 2 != 0) {
            throw new SvgProcessingException("Points attribute {0} on polyline tag does not contain a valid set of points").setMessageParams(pointsAttribute);
        }
        this.points.clear();
        for (int i = 0; i < points.size(); i += 2) {
            float x = CssDimensionParsingUtils.parseAbsoluteLength(points.get(i));
            float y = CssDimensionParsingUtils.parseAbsoluteLength(points.get(i + 1));
            this.points.add(new Point(x, y));
        }
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        this.setPoints(this.getAttribute("points"));
        if (this.points.size() > 1) {
            Point firstPoint = this.points.get(0);
            double minX = firstPoint.getX();
            double minY = firstPoint.getY();
            double maxX = minX;
            double maxY = minY;
            for (int i = 1; i < this.points.size(); ++i) {
                Point current = this.points.get(i);
                double currentX = current.getX();
                minX = Math.min(minX, currentX);
                maxX = Math.max(maxX, currentX);
                double currentY = current.getY();
                minY = Math.min(minY, currentY);
                maxY = Math.max(maxY, currentY);
            }
            double width = maxX - minX;
            double height = maxY - minY;
            return new Rectangle((float)minX, (float)minY, (float)width, (float)height);
        }
        return null;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        String pointsAttribute = this.attributesAndStyles.containsKey("points") ? (String)this.attributesAndStyles.get("points") : null;
        this.setPoints(pointsAttribute);
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% polyline\n");
        if (this.points.size() > 1) {
            AffineTransform transform = this.applyNonScalingStrokeTransform(context);
            if (transform != null) {
                Point[] pt = this.points.toArray(new Point[0]);
                transform.transform(pt, 0, pt, 0, pt.length);
                this.points = Arrays.asList(pt);
            }
            Point currentPoint = this.points.get(0);
            canvas.moveTo(currentPoint.getX(), currentPoint.getY());
            for (int x = 1; x < this.points.size(); ++x) {
                currentPoint = this.points.get(x);
                canvas.lineTo(currentPoint.getX(), currentPoint.getY());
            }
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PolylineSvgNodeRenderer copy = new PolylineSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public void drawMarker(SvgDrawContext context, MarkerVertexType markerVertexType) {
        ArrayList<Point> markerPoints = new ArrayList<Point>();
        int startingPoint = 0;
        if (MarkerVertexType.MARKER_START.equals((Object)markerVertexType)) {
            markerPoints.add(new Point(this.points.get(0)));
        } else if (MarkerVertexType.MARKER_END.equals((Object)markerVertexType)) {
            markerPoints.add(new Point(this.points.get(this.points.size() - 1)));
            startingPoint = this.points.size() - 2;
        } else if (MarkerVertexType.MARKER_MID.equals((Object)markerVertexType)) {
            for (int i = 1; i < this.points.size() - 1; ++i) {
                markerPoints.add(new Point(this.points.get(i)));
            }
            startingPoint = 1;
        }
        for (Point point : markerPoints) {
            point.setLocation(CssUtils.convertPtsToPx(point.getX()), CssUtils.convertPtsToPx(point.getY()));
        }
        if (!markerPoints.isEmpty()) {
            MarkerSvgNodeRenderer.drawMarkers(context, startingPoint, markerPoints, markerVertexType, this);
        }
    }

    @Override
    public double getAutoOrientAngle(MarkerSvgNodeRenderer marker, boolean reverse) {
        int markerIndex = Integer.parseInt(marker.getAttribute("marker-index"));
        if (markerIndex < this.points.size() && this.points.size() > 1) {
            Point firstPoint = this.points.get(markerIndex);
            Point secondPoint = this.points.get(markerIndex + 1);
            Vector v = new Vector((float)(secondPoint.getX() - firstPoint.getX()), (float)(secondPoint.getY() - firstPoint.getY()), 0.0f);
            Vector xAxis = "marker-end".equals(marker.attributesAndStyles.get("marker")) || "marker-start".equals(marker.attributesAndStyles.get("marker")) ? new Vector(1.0f, 0.0f, 0.0f) : new Vector(this.previousOrientationVector.get(1), this.previousOrientationVector.get(0) * -1.0f, 0.0f);
            this.previousOrientationVector = v;
            double rotAngle = SvgCoordinateUtils.calculateAngleBetweenTwoVectors(xAxis, v);
            return v.get(1) >= 0.0f && !reverse ? rotAngle : rotAngle * -1.0;
        }
        return 0.0;
    }
}

