/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.xobject;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgProcessorResult;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;

public class SvgImageXObject
extends PdfFormXObject {
    private final ISvgProcessorResult result;
    private final ResourceResolver resourceResolver;
    private boolean isGenerated = false;
    private boolean isCreatedByImg = false;
    private boolean isCreatedByObject = false;
    private float em;
    private SvgDrawContext svgDrawContext;
    private boolean isRelativeSized = false;

    public SvgImageXObject(Rectangle bBox, ISvgProcessorResult result, ResourceResolver resourceResolver) {
        super(bBox);
        this.result = result;
        this.resourceResolver = resourceResolver;
        this.svgDrawContext = new SvgDrawContext(resourceResolver, result.getFontProvider());
    }

    public SvgImageXObject(ISvgProcessorResult result, SvgDrawContext svgContext, float em, PdfDocument pdfDocument) {
        this(null, result, svgContext.getResourceResolver());
        if (pdfDocument != null) {
            svgContext.pushCanvas(new PdfCanvas(this, pdfDocument));
        }
        this.em = em;
        this.isRelativeSized = true;
        this.svgDrawContext = svgContext;
    }

    public void setIsCreatedByImg(boolean isCreatedByImg) {
        this.isCreatedByImg = isCreatedByImg;
    }

    public boolean isCreatedByImg() {
        return this.isCreatedByImg;
    }

    public void setIsCreatedByObject(boolean isCreatedByObject) {
        this.isCreatedByObject = isCreatedByObject;
    }

    public boolean isCreatedByObject() {
        return this.isCreatedByObject;
    }

    @Override
    public boolean isRelativeSized() {
        return this.isRelativeSized;
    }

    public ISvgProcessorResult getResult() {
        return this.result;
    }

    @Deprecated
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void generate(PdfDocument document) {
        if (!this.isGenerated) {
            if (this.result instanceof SvgProcessorResult) {
                this.svgDrawContext.setCssContext(((SvgProcessorResult)this.result).getContext().getCssContext());
            }
            this.svgDrawContext.setTempFonts(this.result.getTempFonts());
            this.svgDrawContext.addNamedObjects(this.result.getNamedObjects());
            if (this.svgDrawContext.size() == 0) {
                this.svgDrawContext.pushCanvas(new PdfCanvas(this, document));
            }
            PdfRootSvgNodeRenderer root = new PdfRootSvgNodeRenderer(this.result.getRootRenderer());
            root.draw(this.svgDrawContext);
            this.isGenerated = true;
        }
    }

    public void updateBBox(float areaWidth, float areaHeight) {
        this.svgDrawContext.setCustomViewport(new Rectangle(areaWidth, areaHeight));
        Rectangle bbox = SvgCssUtils.extractWidthAndHeight(this.result.getRootRenderer(), this.em, this.svgDrawContext);
        this.setBBox(new PdfArray(bbox));
    }

    public UnitValue getElementWidth() {
        String widthStr = this.result.getRootRenderer().getAttribute("width");
        return CssDimensionParsingUtils.parseLengthValueToPt(widthStr, this.em, this.svgDrawContext.getCssContext().getRootFontSize());
    }

    public UnitValue getElementHeight() {
        String heightStr = this.result.getRootRenderer().getAttribute("height");
        return CssDimensionParsingUtils.parseLengthValueToPt(heightStr, this.em, this.svgDrawContext.getCssContext().getRootFontSize());
    }
}

