/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LineSpacingRule {
    AUTO(1),
    EXACT(2),
    AT_LEAST(3);

    private static final Map<Integer, LineSpacingRule> imap;
    private final int value;

    private LineSpacingRule(int val2) {
        this.value = val2;
    }

    public static LineSpacingRule valueOf(int type) {
        LineSpacingRule lineType = imap.get(type);
        if (lineType == null) {
            throw new IllegalArgumentException("Unknown line type: " + type);
        }
        return lineType;
    }

    public int getValue() {
        return this.value;
    }

    static {
        HashMap<Integer, LineSpacingRule> tempMap = new HashMap<Integer, LineSpacingRule>();
        for (LineSpacingRule p : LineSpacingRule.values()) {
            tempMap.put(p.getValue(), p);
        }
        imap = Collections.unmodifiableMap(tempMap);
    }
}

