/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.controllers;

import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.VerticalAlignment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.CodigosError;
import org.scotiabank.productosGTB.util.BancoConstantes;
import org.scotiabank.productosGTB.util.Normalize;

public class Codigos {
    private String rutaOrigen;
    private String tipoCodigo;
    @FXML
    private TableView<CodigosError> tableCodigos;
    @FXML
    private TableColumn<CodigosError, String> colClaveCodigoError;
    @FXML
    private TableColumn<CodigosError, String> colValorCodigoError;
    List<CodigosError> listaCodigos = new ArrayList<CodigosError>();

    @FXML
    public void initialize() {
        this.colClaveCodigoError.setCellValueFactory(new PropertyValueFactory("clave"));
        this.colValorCodigoError.setCellValueFactory(new PropertyValueFactory("nombre"));
    }

    public void setTipoCodigo(String tipoCodigo) {
        this.tipoCodigo = tipoCodigo;
        this.cargarCodigos();
    }

    public void cargarCodigos() {
        this.listaCodigos.clear();
        if ("dispersionDeFondos".equals(this.tipoCodigo)) {
            BancoConstantes.CODIGOS_ERROR.forEach((clave, nombre) -> this.listaCodigos.add(new CodigosError((String)clave, (String)nombre)));
        } else if ("preregistroDeCuenta".equals(this.tipoCodigo)) {
            BancoConstantes.CODIGOS_ERROR_PREREGISTRO_CUENTA.forEach((clave, nombre) -> this.listaCodigos.add(new CodigosError((String)clave, (String)nombre)));
        }
        Collections.sort(this.listaCodigos, Comparator.comparing(CodigosError::getClave));
        ObservableList<CodigosError> codigosErrors = FXCollections.observableArrayList(this.listaCodigos);
        this.tableCodigos.setItems(codigosErrors);
    }

    @FXML
    private void btnRegresar(ActionEvent event) {
        Stage stage = (Stage)((Node)event.getSource()).getScene().getWindow();
        stage.close();
    }

    @FXML
    private void btnImprimir(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Guardar PDF");
        if ("dispersionDeFondos".equals(this.tipoCodigo)) {
            fileChooser.setInitialFileName("codigo_dispersionFondos.pdf");
        } else if ("preregistroDeCuenta".equals(this.tipoCodigo)) {
            fileChooser.setInitialFileName("codigos_preregistroDeCuenta.pdf");
        } else {
            fileChooser.setInitialFileName("codigos.pdf");
        }
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("PDF Files", "*.pdf"));
        File archivo = fileChooser.showSaveDialog(null);
        if (archivo == null) {
            return;
        }
        if (!Codigos.validarNombreCarpeta(archivo)) {
            return;
        }
        try {
            this.generarPDF(this.listaCodigos, Normalize.parse(archivo.getAbsolutePath()));
            this.mostrarAlerta(Alert.AlertType.INFORMATION, "PDF Guardado", null, "El archivo se guard\u00f3 exitosamente en:\n" + archivo.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mostrarAlerta(Alert.AlertType.ERROR, "Error al guardar", "No se pudo generar el PDF", e.getMessage());
        }
    }

    public static boolean validarNombreCarpeta(File archivo) {
        String regex;
        if (archivo == null) {
            return false;
        }
        File carpeta = archivo.getParentFile();
        if (carpeta == null) {
            return false;
        }
        String nombreCarpeta = carpeta.getName();
        if (!nombreCarpeta.matches(regex = "^[a-zA-Z0-9 _-]+$")) {
            Alert alerta = new Alert(Alert.AlertType.ERROR);
            alerta.setTitle("Carpeta inv\u00e1lida");
            alerta.setHeaderText("Nombre de carpeta no permitido");
            alerta.setContentText("Solo se permiten letras, n\u00fameros, espacios, guiones (-) y guiones bajos (_).");
            alerta.showAndWait();
            return false;
        }
        return true;
    }

    private void mostrarAlerta(Alert.AlertType tipo, String titulo, String encabezado, String mensaje) {
        Alert alert = new Alert(tipo);
        alert.setTitle(titulo);
        alert.setHeaderText(encabezado);
        alert.setContentText(mensaje);
        alert.showAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generarPDF(List<CodigosError> codigosErrors, String rutaArchivoSeleccionado) {
        Document reporte = null;
        InputStream logoStream = null;
        try {
            PdfWriter writer = new PdfWriter(rutaArchivoSeleccionado);
            PdfDocument pdf = new PdfDocument(writer);
            reporte = new Document(pdf, PageSize.A4);
            Paragraph titulo = (Paragraph)((Paragraph)new Paragraph("Cat\u00e1logo de c\u00f3digos").setFontSize(14.0f)).setTextAlignment(TextAlignment.CENTER);
            reporte.add(titulo);
            reporte.add(new Paragraph("\n"));
            Table table = new Table(2);
            table.addHeaderCell(this.crearCeldaHeader("Clave"));
            table.addHeaderCell(this.crearCeldaHeader("Nombre"));
            for (CodigosError error : codigosErrors) {
                table.addCell(new Cell().add(new Paragraph(error.getClave())));
                table.addCell(new Cell().add(new Paragraph(error.getNombre())));
            }
            reporte.add(table);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mostrarAlerta("Error al generar el PDF:\n" + e.getMessage());
        }
        finally {
            try {
                if (logoStream != null) {
                    logoStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (reporte != null) {
                reporte.close();
            }
        }
    }

    private Cell crearCeldaHeader(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add((IBlockElement)new Paragraph(texto).setFontColor(ColorConstants.WHITE)).setBackgroundColor(ColorConstants.RED)).setTextAlignment(TextAlignment.CENTER)).setVerticalAlignment(VerticalAlignment.MIDDLE);
    }

    private void mostrarAlerta(String mensaje) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Resultado");
        alert.setHeaderText(null);
        alert.setContentText(mensaje);
        alert.showAndWait();
    }

    public void setRutaOrigen(String rutaOrigen) {
        this.rutaOrigen = rutaOrigen;
    }
}

