/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.controllers;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.TextAlignment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import org.scotiabank.productosGTB.business.Service;
import org.scotiabank.productosGTB.util.Normalize;

public class GuiaRapida {
    @FXML
    private Button btnpdf;
    @FXML
    private TextFlow textFlowGuia;

    @FXML
    private void regresar(ActionEvent event) {
        String url = "/fxml/Main/main-view.fxml";
        String title = "Productos de global transaction banking (GTB)";
        Service service = new Service();
        Service.navegacion(url, title, event);
    }

    @FXML
    public void initialize() {
        this.textFlowGuia.getChildren().clear();
        this.agregarParrafo("Gu\u00eda r\u00e1pida\n\n", "En Herramientas Scotiabank, podr\u00e1s operar de manera sencilla los servicios de Cash Management desde tu computadora con sistema operativo Windows o macOs. Debes guardar este programa en cualquier carpeta de tu equipo para generar  archivos de las instrucciones de pago o cobro en formato .txt e interpretarlos posteriormente. Estas son algunas de las acciones que podr\u00e1s hacer:\n");
        this.agregarParrafo("Capturar informaci\u00f3n\n\n", "Podr\u00e1s capturar la informaci\u00f3n necesaria para generar los archivos de las instrucciones de pago o cobro y as\u00ed procesarlas correctamente. Algunos campos son obligatorios y otros, opcionales. Al menos, debes proporcionar los datos indispensables y no deben quedar  filas salteadas o incompletas en la tabla para generar los archivos sin omisiones.\nSi lo necesitas, podr\u00e1s imprimir la informaci\u00f3n que capturaste. Herramientas Scotiabank ajustar\u00e1 autom\u00e1ticamente el \u00e1rea de impresi\u00f3n para que solo uses las hojas necesarias.");
        this.agregarParrafo("Emitir archivos\n\n", "Al dar clic en el bot\u00f3n Generar archivo TXT, deber\u00e1s indicar el nombre y la ruta donde quieres guardar la instrucci\u00f3n de pago o cobro.");
        this.agregarParrafo("Consultar reportes \n\n", "En Herramientas Scotiabank tambi\u00e9n puedes leer los archivos .txt de respuesta de los canales transaccionales (banca electr\u00f3nica y host to host) a las instrucciones de pago o cobro independientemente de si su estatus es previo, definitivo o rechazado. En caso de que cuentes con el c\u00f3digo del resultado de alguna instrucci\u00f3n, usa el bot\u00f3n C\u00f3digos para ver el cat\u00e1logo disponible, elegir el correspondiente y as\u00ed consultar el detalle del estatus. Adem\u00e1s, hasta abajo de la pantalla, ver\u00e1s el resumen del archivo que agrupa el resultado de las operaciones por n\u00famero de movimientos e importes.\nSi lo necesitas, podr\u00e1s imprimir los reportes. Herramientas Scotiabank ajustar\u00e1 autom\u00e1ticamente el \u00e1rea de impresi\u00f3n para que solo uses las hojas necesarias.\n");
        this.agregarParrafo("Imprimir avisos de abono\n\n", "Para imprimir los avisos de abono, debes indicar el nombre del cliente o la empresa que genera la instrucci\u00f3n y dar clic en el bot\u00f3n Generar comprobantes PDF. Herramientas Scotiabank ajustar\u00e1 la informaci\u00f3n para imprimir cada aviso en hojas tama\u00f1o carta.\nToma en cuenta que los avisos de abono a cuentas de otros bancos son \u00fanicamente informativos. Scotiabank no se hace responsable si el otro banco no hace el dep\u00f3sito por alguna raz\u00f3n.\n\nPara consultar los t\u00e9rminos, condiciones, comisiones y requisitos de contrataci\u00f3n de nuestros productos y servicios, as\u00ed como nuestro aviso de privacidad, entra a www.scotiabank.com.mx.\nServicio ofrecido por Scotiabank Inverlat, S. A., Instituci\u00f3n de Banca M\u00faltiple, Grupo Financiero Scotiabank Inverlat.\n");
        this.numeros("Centro de atenci\u00f3n telef\u00f3nica: 55 5728 1262 y 55 5728 7205.");
    }

    private void agregarParrafo(String titulo, String contenido) {
        Text tituloText = new Text(titulo);
        tituloText.setStyle("-fx-font-weight: bold; -fx-font-size: 24px;");
        Text contenidoText = new Text(contenido + "\n\n");
        contenidoText.setStyle("-fx-font-size: 16px;");
        this.textFlowGuia.getChildren().addAll((Node[])new Node[]{tituloText, contenidoText});
    }

    private void numeros(String contenido) {
        Text contenidoText = new Text(contenido + "\n\n");
        contenidoText.setStyle("-fx-font-weight: bold; -fx-font-size: 16px;");
        this.textFlowGuia.getChildren().addAll((Node[])new Node[]{contenidoText});
    }

    @FXML
    private void btnImprimir(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Guardar PDF");
        fileChooser.setInitialFileName("Guia-rapida.pdf");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("PDF Files", "*.pdf"));
        File archivo = fileChooser.showSaveDialog(null);
        if (archivo == null) {
            return;
        }
        if (!GuiaRapida.validarNombreCarpeta(archivo)) {
            return;
        }
        try {
            this.generarPDF(Normalize.parse(archivo.getAbsolutePath()));
            this.mostrarAlerta(Alert.AlertType.INFORMATION, "PDF Guardado", null, "El archivo se guard\u00f3 exitosamente en:\n" + archivo.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mostrarAlerta(Alert.AlertType.ERROR, "Error al guardar", "No se pudo generar el PDF", e.getMessage());
        }
    }

    public static boolean validarNombreCarpeta(File archivo) {
        String regex;
        if (archivo == null) {
            return false;
        }
        File carpeta = archivo.getParentFile();
        if (carpeta == null) {
            return false;
        }
        String nombreCarpeta = carpeta.getName();
        if (!nombreCarpeta.matches(regex = "^[a-zA-Z0-9 _-]+$")) {
            Alert alerta = new Alert(Alert.AlertType.ERROR);
            alerta.setTitle("Carpeta inv\u00e1lida");
            alerta.setHeaderText("Nombre de carpeta no permitido");
            alerta.setContentText("Solo se permiten letras, n\u00fameros, espacios, guiones (-) y guiones bajos (_).");
            alerta.showAndWait();
            return false;
        }
        return true;
    }

    public void generarPDF(String rutaArchivo) {
        PdfWriter writer = null;
        PdfDocument pdf = null;
        Document document = null;
        InputStream logoStream = null;
        try {
            writer = new PdfWriter(new File(Normalize.parse(rutaArchivo)));
            pdf = new PdfDocument(writer);
            document = new Document(pdf);
            logoStream = this.getClass().getClassLoader().getResourceAsStream("assets/Scotiabank-logo.png");
            if (logoStream == null) {
                throw new FileNotFoundException("No se encontr\u00f3 el archivo del logo.");
            }
            ImageData imageData = ImageDataFactory.create(logoStream.readAllBytes());
            Image logo = (Image)new Image(imageData).setWidth(120.0f).setHorizontalAlignment(HorizontalAlignment.RIGHT);
            document.add(logo);
            document.add(new Paragraph("\n\n\n"));
            PdfFont helveticaBold = PdfFontFactory.createFont("Helvetica-Bold");
            PdfFont font = PdfFontFactory.createFont("Helvetica");
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("Gu\u00eda r\u00e1pida\n\n").setFontSize(14.0f)).setFont(helveticaBold)).setTextAlignment(TextAlignment.CENTER));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("En Herramientas Scotiabank, podr\u00e1s operar de manera sencilla los servicios de Cash Management desde tu computadora con sistema operativo Windows o macOs. Debes guardar este programa en cualquier carpeta de tu equipo para generar  archivos de las instrucciones de pago o cobro en formato .txt e interpretarlos posteriormente. Estas son algunas de las acciones que podr\u00e1s hacer:\n").setFontSize(12.0f)).setFont(font)).setTextAlignment(TextAlignment.JUSTIFIED));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("\nCapturar informaci\u00f3n\n\n").setFontSize(14.0f)).setFont(helveticaBold)).setTextAlignment(TextAlignment.LEFT));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("Podr\u00e1s capturar la informaci\u00f3n necesaria para generar los archivos de las instrucciones de pago o cobro y as\u00ed procesarlas correctamente. Algunos campos son obligatorios y otros, opcionales. Al menos, debes proporcionar los datos indispensables y no deben quedar  filas salteadas o incompletas en la tabla para generar los archivos sin omisiones.\nSi lo necesitas, podr\u00e1s imprimir la informaci\u00f3n que capturaste. Herramientas Scotiabank ajustar\u00e1 autom\u00e1ticamente el \u00e1rea de impresi\u00f3n para que solo uses las hojas necesarias.").setFontSize(12.0f)).setFont(font)).setTextAlignment(TextAlignment.JUSTIFIED));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("\nEmitir archivos\n\n").setFontSize(14.0f)).setFont(helveticaBold)).setTextAlignment(TextAlignment.LEFT));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("Al dar clic en el bot\u00f3n Generar archivo TXT, deber\u00e1s indicar el nombre y la ruta donde quieres guardar la instrucci\u00f3n de pago o cobro.").setFontSize(12.0f)).setFont(font)).setTextAlignment(TextAlignment.JUSTIFIED));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("\nConsultar reportes \n\n").setFontSize(14.0f)).setFont(helveticaBold)).setTextAlignment(TextAlignment.LEFT));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("En Herramientas Scotiabank tambi\u00e9n puedes leer los archivos .txt de respuesta de los canales transaccionales (banca electr\u00f3nica y host to host) a las instrucciones de pago o cobro independientemente de si su estatus es previo, definitivo o rechazado. En caso de que cuentes con el c\u00f3digo del resultado de alguna instrucci\u00f3n, usa el bot\u00f3n C\u00f3digos para ver el cat\u00e1logo disponible, elegir el correspondiente y as\u00ed consultar el detalle del estatus. Adem\u00e1s, hasta abajo de la pantalla, ver\u00e1s el resumen del archivo que agrupa el resultado de las operaciones por n\u00famero de movimientos e importes.\nSi lo necesitas, podr\u00e1s imprimir los reportes. Herramientas Scotiabank ajustar\u00e1 autom\u00e1ticamente el \u00e1rea de impresi\u00f3n para que solo uses las hojas necesarias.\n").setFontSize(12.0f)).setFont(font)).setTextAlignment(TextAlignment.JUSTIFIED));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("\nImprimir avisos de abono\n\n").setFontSize(14.0f)).setFont(helveticaBold)).setTextAlignment(TextAlignment.LEFT));
            document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph("Para imprimir los avisos de abono, debes indicar el nombre del cliente o la empresa que genera la instrucci\u00f3n y dar clic en el bot\u00f3n Generar comprobantes PDF. Herramientas Scotiabank ajustar\u00e1 la informaci\u00f3n para imprimir cada aviso en hojas tama\u00f1o carta.\nToma en cuenta que los avisos de abono a cuentas de otros bancos son \u00fanicamente informativos. Scotiabank no se hace responsable si el otro banco no hace el dep\u00f3sito por alguna raz\u00f3n.\n\nPara consultar los t\u00e9rminos, condiciones, comisiones y requisitos de contrataci\u00f3n de nuestros productos y servicios, as\u00ed como nuestro aviso de privacidad, entra a www.scotiabank.com.mx.\nServicio ofrecido por Scotiabank Inverlat, S. A., Instituci\u00f3n de Banca M\u00faltiple, Grupo Financiero Scotiabank Inverlat.\n").setFontSize(12.0f)).setFont(font)).setTextAlignment(TextAlignment.JUSTIFIED));
            document.add((IBlockElement)((Paragraph)((Paragraph)((Paragraph)new Paragraph("Centro de atenci\u00f3n telef\u00f3nica: 55 5728 1262 y 55 5728 7205.").setFontSize(12.0f)).setFont(font)).setFont(helveticaBold)).setTextAlignment(TextAlignment.JUSTIFIED));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (logoStream != null) {
                    logoStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (document != null) {
                document.close();
            }
        }
    }

    private void mostrarAlerta(Alert.AlertType tipo, String titulo, String encabezado, String mensaje) {
        Alert alert = new Alert(tipo);
        alert.setTitle(titulo);
        alert.setHeaderText(encabezado);
        alert.setContentText(mensaje);
        alert.showAndWait();
    }
}

