/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.controllers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.scotiabank.productosGTB.business.Service;
import org.scotiabank.productosGTB.data.ErrorData;
import org.scotiabank.productosGTB.enums.MaintOrConsultationEnum;
import org.scotiabank.productosGTB.model.PreRegistroCuentasData;
import org.scotiabank.productosGTB.util.ColumnaConfig;
import org.scotiabank.productosGTB.util.TextFieldValidator;
import org.scotiabank.productosGTB.util.TooltipManager;
import org.scotiabank.productosGTB.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreRegistroCuentasController {
    private static final Logger log = LoggerFactory.getLogger(PreRegistroCuentasController.class);
    @FXML
    private TextField textFieldContractNumber;
    @FXML
    private ComboBox<MaintOrConsultationEnum> comboBoxMaintOrConsultation;
    @FXML
    private TextField textFieldFileNumberOfTheDay;
    @FXML
    private DatePicker datePicketFechaDeSolicitud;
    @FXML
    private TableView<PreRegistroCuentasData> tableViewPreRegistroCuentas;
    private ObservableList<PreRegistroCuentasData> dataList;
    @FXML
    private TableColumn<PreRegistroCuentasData, Integer> num;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> tipoRegistro;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> tipoPago;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> tipoCuenta;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> monedaCuenta;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> claveBanco;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> cuentaAbono;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> limiteTransaccion;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> fechaEliminacion;
    @FXML
    private TableColumn<PreRegistroCuentasData, String> descripcion;
    @FXML
    private Label errorLabelContractNumber;
    @FXML
    private Label errorLabelFechaDeSolicitud;
    @FXML
    private Label errorLabelFileNumberOfTheDay;
    @FXML
    private Hyperlink btnCargar;
    @FXML
    private Button btnAgregarFila;
    @FXML
    private Button btnEliminarFila;
    @FXML
    private Button btnEliminarAll;
    private boolean cargarDesdeExcel = false;
    private boolean campoEditado = false;

    @FXML
    public void initialize() {
        Platform.runLater(() -> this.tableViewPreRegistroCuentas.getScene().getRoot().requestFocus());
        this.agregaTooltips();
        this.restringeTextField();
        this.fillAllComboBox();
        Util.limitarFechasAnteriores(this.datePicketFechaDeSolicitud);
        Platform.runLater(() -> {
            this.dataList = FXCollections.observableArrayList(new PreRegistroCuentasData(1, "", "", "", "", "", "", "", "", ""));
            this.tableViewPreRegistroCuentas.setItems(this.dataList);
            this.btnCargar.setOnAction(e -> this.importarExcel());
            if (this.cargarDesdeExcel) {
                Util.setTablaEditable(this.tableViewPreRegistroCuentas, this.btnAgregarFila, this.btnEliminarFila, true);
            }
        });
        this.comboBoxMaintOrConsultation.valueProperty().addListener((observable, oldValue, newValue) -> {
            boolean editable = "C".equals(newValue.getId());
            Util.activaDesactivaCapturaConBaseCampo(this.tableViewPreRegistroCuentas, this.btnAgregarFila, this.btnEliminarFila, this.btnEliminarAll, this.btnCargar, this.dataList, editable);
        });
        if (this.comboBoxMaintOrConsultation.getValue() != null) {
            boolean editable = "C".equals(((MaintOrConsultationEnum)((Object)this.comboBoxMaintOrConsultation.getValue())).getId());
            Util.activaDesactivaCapturaConBaseCampo(this.tableViewPreRegistroCuentas, this.btnAgregarFila, this.btnEliminarFila, this.btnEliminarAll, this.btnCargar, this.dataList, editable);
        }
        this.fillTable();
    }

    public void fillAllComboBox() {
        this.comboBoxMaintOrConsultation.setItems(FXCollections.observableArrayList(MaintOrConsultationEnum.values()));
        this.comboBoxMaintOrConsultation.getSelectionModel().selectFirst();
        this.datePicketFechaDeSolicitud.setEditable(false);
    }

    public void fillTable() {
        this.tipoRegistro.setCellValueFactory(new PropertyValueFactory("tipoRegistro"));
        this.tipoPago.setCellValueFactory(new PropertyValueFactory("tipoPago"));
        this.tipoCuenta.setCellValueFactory(new PropertyValueFactory("tipoCuenta"));
        this.monedaCuenta.setCellValueFactory(new PropertyValueFactory("monedaCuenta"));
        this.claveBanco.setCellValueFactory(new PropertyValueFactory("claveBanco"));
        this.cuentaAbono.setCellValueFactory(new PropertyValueFactory("cuentaAbono"));
        this.limiteTransaccion.setCellValueFactory(new PropertyValueFactory("limiteTransaccion"));
        this.fechaEliminacion.setCellValueFactory(new PropertyValueFactory("fechaEliminacion"));
        this.descripcion.setCellValueFactory(new PropertyValueFactory("descripcion"));
        this.num.setCellValueFactory(new PropertyValueFactory("num"));
        this.tipoRegistro.setCellFactory(Util.createPersonalizedCellFactory(Arrays.asList("DA", "DC", "DB", "DQ")));
        this.tipoPago.setCellFactory(Util.createPersonalizedCellFactory(Arrays.asList("01", "02", "03", "04")));
        this.tipoCuenta.setCellFactory(Util.createPersonalizedCellFactory(Arrays.asList("01", "02", "03", "09")));
        this.monedaCuenta.setCellFactory(Util.createPersonalizedCellFactory(Arrays.asList("00", "01")));
        this.claveBanco.setCellFactory(Util.createNumericCellFactory(1, 3));
        this.cuentaAbono.setCellFactory(Util.createNumericCellFactory(11, 18));
        this.limiteTransaccion.setCellFactory(Util.createDecimalCellFactory(1, 17));
        this.fechaEliminacion.setCellFactory(Util.createFechaEliminacionCellFactory(8, 8));
        this.descripcion.setCellFactory(Util.createStringWithoutSymbolsCellFactory(1, 50));
        this.tableViewPreRegistroCuentas.setEditable(true);
    }

    @FXML
    private void agregarFila(ActionEvent event) {
        Integer nuevoNumero = this.dataList.size() + 1;
        PreRegistroCuentasData nuevaFila = new PreRegistroCuentasData(nuevoNumero, "", "", "", "", "", "", "", "", "");
        this.dataList.add(nuevaFila);
        this.tableViewPreRegistroCuentas.refresh();
    }

    @FXML
    private void eliminarFila(ActionEvent event) {
        if (this.dataList.size() > 1) {
            this.dataList.removeLast();
            this.tableViewPreRegistroCuentas.refresh();
        } else {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("Error de Eliminaci\u00f3n");
            alert.setHeaderText(null);
            alert.setContentText("No puedes eliminar la \u00faltima fila de la tabla.");
            alert.showAndWait();
        }
    }

    @FXML
    private boolean validateForm(boolean validateAll) {
        boolean allFieldsAreValid = true;
        this.textFieldContractNumber.getStyleClass().remove("error-field");
        this.textFieldFileNumberOfTheDay.getStyleClass().remove("error-field");
        this.datePicketFechaDeSolicitud.getStyleClass().remove("error-field");
        this.errorLabelContractNumber.setVisible(false);
        this.errorLabelFileNumberOfTheDay.setVisible(false);
        this.errorLabelFechaDeSolicitud.setVisible(false);
        if (this.textFieldContractNumber.getText().trim().isEmpty()) {
            this.textFieldContractNumber.getStyleClass().add("error-field");
            this.errorLabelContractNumber.setText("Este campo es requerido.");
            this.errorLabelContractNumber.setVisible(true);
            allFieldsAreValid = false;
        }
        if (this.textFieldFileNumberOfTheDay.getText().trim().isEmpty()) {
            this.textFieldFileNumberOfTheDay.getStyleClass().add("error-field");
            this.errorLabelFileNumberOfTheDay.setText("Este campo es requerido.");
            this.errorLabelFileNumberOfTheDay.setVisible(true);
            allFieldsAreValid = false;
        }
        if (this.datePicketFechaDeSolicitud.getValue() == null) {
            this.datePicketFechaDeSolicitud.getStyleClass().add("error-field");
            this.errorLabelFechaDeSolicitud.setText("Este campo es requerido.");
            this.errorLabelFechaDeSolicitud.setVisible(true);
            allFieldsAreValid = false;
        }
        if (!allFieldsAreValid && this.cargarDesdeExcel) {
            return false;
        }
        if (!validateAll) {
            return true;
        }
        if (this.tableViewPreRegistroCuentas.getItems().isEmpty()) {
            Util.mostrarAlerta("La tabla no contiene infomaci\u00f3n");
            return false;
        }
        StringBuilder errorMessage = new StringBuilder("Por favor, llena los campos obligatorios:\n\n");
        boolean hasTableErrors = false;
        int rowIndex = 0;
        for (PreRegistroCuentasData data : this.tableViewPreRegistroCuentas.getItems()) {
            ++rowIndex;
            if (data.getTipoRegistro() == null || data.getTipoRegistro().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Tipo Registro' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getTipoPago() == null || data.getTipoPago().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Tipo Pago' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getTipoCuenta() == null || data.getTipoCuenta().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Tipo Cuenta' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getMonedaCuenta() == null || data.getMonedaCuenta().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Cuenta' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getClaveBanco() == null || data.getClaveBanco().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Clave Banco' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getCuentaAbono() == null || data.getCuentaAbono().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Cuenta Abono' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getLimiteTransaccion() == null || data.getLimiteTransaccion().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Limite Transaccion' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getFechaEliminacion() == null || data.getFechaEliminacion().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Fecha Eliminacion' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getDescripcion() != null && !data.getDescripcion().trim().isEmpty()) continue;
            errorMessage.append("\u2022 Columna 'Descripcion' del registro ").append(rowIndex).append("\n");
            allFieldsAreValid = false;
            hasTableErrors = true;
        }
        if (hasTableErrors) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("Error de Validaci\u00f3n");
            alert.setHeaderText("Campos de la tabla incompletos.");
            alert.setContentText(errorMessage.toString());
            alert.showAndWait();
        }
        return allFieldsAreValid;
    }

    public void exportarDatosAArchivoOptimizada() {
        this.tableViewPreRegistroCuentas.refresh();
        if (this.validateForm(((MaintOrConsultationEnum)((Object)this.comboBoxMaintOrConsultation.getValue())).getId().equals("M"))) {
            DateTimeFormatter formato = DateTimeFormatter.ofPattern("yyyyMMdd");
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Guardar Archivo de Datos");
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Archivos de texto (*.txt)", "*.txt");
            fileChooser.getExtensionFilters().add(extFilter);
            File file = fileChooser.showSaveDialog(new Stage());
            if (file != null) {
                try (FileWriter fw = new FileWriter(file);
                     BufferedWriter bw = new BufferedWriter(fw);
                     PrintWriter writer = new PrintWriter(bw);){
                    String fillerLinea1;
                    String numContratoCompleto;
                    int contadorAltas = 0;
                    int contadorBajas = 0;
                    int contadorCambios = 0;
                    int contadorConsultas = 0;
                    if (this.textFieldContractNumber.getText().length() >= 6) {
                        numContratoCompleto = Util.rellenarConCerosIzquierda(this.textFieldContractNumber.getText(), 12);
                        fillerLinea1 = Util.rellenarConEspaciosDerecha("", 91);
                    } else {
                        numContratoCompleto = Util.rellenarConCerosIzquierda(this.textFieldContractNumber.getText(), 7);
                        fillerLinea1 = Util.rellenarConEspaciosDerecha("", 96);
                    }
                    writer.print("EEHAJDF" + numContratoCompleto + ((LocalDate)this.datePicketFechaDeSolicitud.getValue()).format(formato) + Util.rellenarConCerosIzquierda(this.textFieldFileNumberOfTheDay.getText(), 3) + ((MaintOrConsultationEnum)((Object)this.comboBoxMaintOrConsultation.getValue())).getId() + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 6) + Util.rellenarConCerosIzquierda("", 3) + fillerLinea1 + "\r\n");
                    if (((MaintOrConsultationEnum)((Object)this.comboBoxMaintOrConsultation.getValue())).getId().equals("M")) {
                        for (PreRegistroCuentasData data : this.dataList) {
                            if (data.getTipoRegistro().equals("DA")) {
                                ++contadorAltas;
                            } else if (data.getTipoRegistro().equals("DC")) {
                                ++contadorCambios;
                            } else if (data.getTipoRegistro().equals("DB")) {
                                ++contadorBajas;
                            } else if (data.getTipoRegistro().equals("DQ")) {
                                ++contadorConsultas;
                            }
                            writer.print("EE" + data.getTipoRegistro() + "A" + Util.rellenarConCerosIzquierda(data.getTipoCuenta(), 2) + Util.rellenarConCerosIzquierda(data.getMonedaCuenta(), 2) + Util.rellenarConCerosIzquierda(data.getClaveBanco(), 3) + Util.rellenarConCerosIzquierda(data.getCuentaAbono(), 20) + Util.rellenarConCerosIzquierda(data.getFechaEliminacion(), 8) + Util.rellenarConEspaciosDerecha(data.getDescripcion(), 50) + Util.rellenarConCerosIzquierda(data.getLimiteTransaccion().replaceAll("\\.", ""), 17) + Util.rellenarConCerosIzquierda(data.getTipoPago(), 2) + Util.rellenarConCerosIzquierda("", 3) + Util.rellenarConEspaciosDerecha("", 27) + "\r\n");
                        }
                    }
                    writer.print("EETA" + Util.rellenarConCerosIzquierda(Integer.toString(contadorAltas), 8) + Util.rellenarConCerosIzquierda(Integer.toString(contadorCambios), 8) + Util.rellenarConCerosIzquierda(Integer.toString(contadorBajas), 8) + Util.rellenarConCerosIzquierda(Integer.toString(contadorConsultas), 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 8) + Util.rellenarConCerosIzquierda("", 3) + Util.rellenarConCerosIzquierda("", 3) + Util.rellenarConEspaciosDerecha("", 33) + "\r\n");
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("Exportaci\u00f3n Exitosa");
                    alert.setHeaderText(null);
                    alert.setContentText("Los datos se han guardado en el archivo: " + file.getAbsolutePath());
                    alert.showAndWait();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Error de Exportaci\u00f3n");
                    alert.setHeaderText("No se pudo guardar el archivo.");
                    alert.setContentText("Ocurri\u00f3 un error al intentar escribir los datos. Por favor, int\u00e9ntelo de nuevo.");
                    alert.showAndWait();
                }
            }
        } else {
            System.out.println("Se omiti\u00f3 exportaci\u00f3n por falta de informaci\u00f3n");
        }
    }

    public void restringeTextField() {
        this.textFieldContractNumber.textProperty().addListener((obs, oldVal, newVal) -> {
            this.campoEditado = true;
        });
        this.textFieldContractNumber.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue() && this.campoEditado) {
                TextFieldValidator.validarNumerosYMaxLength(this.textFieldContractNumber, 12, 1);
            }
        });
        this.textFieldFileNumberOfTheDay.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                TextFieldValidator.validarNumerosYMaxLength(this.textFieldFileNumberOfTheDay, 2, 1);
            }
        });
    }

    @FXML
    private void importarExcel() {
        if (this.validateForm(false)) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Selecciona archivo Excel");
            fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Excel Files", "*.xlsx"));
            File archivo = fileChooser.showOpenDialog(this.btnCargar.getScene().getWindow());
            if (archivo != null) {
                ArrayList<ErrorData> erroresDeFormato = new ArrayList<ErrorData>();
                List<String> allowedTipoRegistro = Arrays.asList("DA", "DC", "DB", "DQ");
                List<String> allowedTipoPago = Arrays.asList("01", "02", "03", "04");
                List<String> allowedTipoCuenta = Arrays.asList("01", "02", "03", "09");
                List<String> allowedMonedaCuenta = Arrays.asList("00", "01");
                List<ColumnaConfig> configuracion = Arrays.asList(new ColumnaConfig("Tipo Registro", 0, Util::isValidAllowedValue, "Contiene valores no permitidos", allowedTipoRegistro), new ColumnaConfig("Tipo Pago", 1, Util::isValidAllowedValue, "Contiene valores no permitidos", allowedTipoPago), new ColumnaConfig("Tipo Cuenta", 2, Util::isValidAllowedValue, "Contiene valores no permitidos", allowedTipoCuenta), new ColumnaConfig("Moneda Cuenta", 3, Util::isValidAllowedValue, "Contiene valores no permitidos", allowedMonedaCuenta), new ColumnaConfig("Clave Banco", 4, (v, l) -> Util.isValidNumeric(v, 1, 3), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Cuenta Abono", 5, (v, l) -> Util.isValidNumeric(v, 11, 18), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Limite Transaccion", 6, (v, l) -> Util.isValidDecimal(v, 1, 18), "Formato incorrecto (solo n\u00fameros y 2 decimales).", null), new ColumnaConfig("Fecha Eliminacion", 7, (v, l) -> Util.isValidNumeric(v, 8, 8), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Descripcion", 8, (v, l) -> Util.isValidStringWithoutSymbols(v, 0, 50), "Contiene s\u00edmbolos, may\u00fasculas o acentos no permitidos o la longitud no es la correcta.", null));
                this.descripcion.setCellFactory(Util.createStringWithoutSymbolsCellFactory(1, 50));
                try (FileInputStream fis = new FileInputStream(archivo);
                     Workbook workbook = WorkbookFactory.create(fis);){
                    Sheet hoja = workbook.getSheetAt(0);
                    this.dataList.clear();
                    int consecutivo = 0;
                    for (int i = 1; i <= hoja.getLastRowNum(); ++i) {
                        Row fila = hoja.getRow(i);
                        if (fila == null) continue;
                        boolean filaTieneErrores = false;
                        String[] valoresCelda = new String[configuracion.size()];
                        for (ColumnaConfig config : configuracion) {
                            String valor = this.getCellValue(fila.getCell(config.indice));
                            boolean esValido = config.validador.apply(valor, config.valoresPermitidos);
                            if (!esValido) {
                                erroresDeFormato.add(new ErrorData(i + 1, config.nombre, valor, config.mensajeError));
                                filaTieneErrores = true;
                                valoresCelda[config.indice] = "";
                                continue;
                            }
                            valoresCelda[config.indice] = valor;
                        }
                        if (filaTieneErrores) continue;
                        this.dataList.add(new PreRegistroCuentasData(++consecutivo, valoresCelda[0], valoresCelda[1], valoresCelda[2], valoresCelda[3], valoresCelda[4], valoresCelda[5], valoresCelda[6], valoresCelda[7], valoresCelda[8]));
                    }
                    if (!erroresDeFormato.isEmpty()) {
                        Util.mostrarAlerta("El excel cargado contiene errores, se descargar\u00e1 un excel con los errores");
                        Util.exportarErroresAExcel(erroresDeFormato);
                    }
                    this.habilitaTabla(false);
                    this.tableViewPreRegistroCuentas.refresh();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @FXML
    private void habilitaTabla(boolean editable) {
        this.tableViewPreRegistroCuentas.setEditable(!editable);
        if (!editable) {
            this.tableViewPreRegistroCuentas.getStyleClass().add("disabled-overlay");
        } else {
            this.tableViewPreRegistroCuentas.getStyleClass().remove("disabled-overlay");
        }
        if (this.btnAgregarFila != null) {
            this.btnAgregarFila.setDisable(editable);
        }
        if (this.btnEliminarFila != null) {
            this.btnEliminarFila.setDisable(editable);
        }
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        return switch (cell.getCellType()) {
            case CellType.STRING -> cell.getStringCellValue();
            case CellType.NUMERIC -> String.valueOf((int)cell.getNumericCellValue());
            case CellType.BOOLEAN -> String.valueOf(cell.getBooleanCellValue());
            default -> "";
        };
    }

    public void borrarTabla() {
        this.dataList.clear();
        PreRegistroCuentasData nuevaFila = new PreRegistroCuentasData(1, "", "", "", "", "", "", "", "", "");
        this.dataList.add(nuevaFila);
        this.textFieldContractNumber.clear();
        this.textFieldFileNumberOfTheDay.clear();
        this.datePicketFechaDeSolicitud.setValue(null);
        this.tableViewPreRegistroCuentas.refresh();
    }

    public void agregaTooltips() {
        TooltipManager.applyTooltip(this.textFieldContractNumber, "REQUERIDO\nSolo n\u00fameros\nMinimo 1 d\u00edgito\nMaximo 12 d\u00edgitos");
        TooltipManager.applyTooltip(this.textFieldFileNumberOfTheDay, "REQUERIDO\nSolo n\u00fameros\nMinimo 1 d\u00edgito\nMaximo 2 d\u00edgitos\nRango del 1 al 99");
        Util.setTooltipOnColumnHeader(this.tipoRegistro, "Tipos de Registros Detalle\nLongitud: 2\nTipo: Alfanum\u00e9rico\nDA Detalle Alta de Datos\nDC Detalle Cambios de Datos\nDB Detalle Baja de Datos");
        Util.setTooltipOnColumnHeader(this.tipoPago, "Tipos de Pagos Disponibles\nLongitud: 2\nTipo: N\u00famerico\n01 N\u00f3mina\n02 Pensiones\n03 Otras Transferencias\n04 Proveedores");
        Util.setTooltipOnColumnHeader(this.tipoCuenta, "Tipos de Cuenta del Banco\nLongitud: 2\nTipo: N\u00famerico\n01 Cuenta Cheques (11 pos)\n02 Cuenta Ahorro (11 pos)\n03 Cuenta Tarjeta D\u00e9bito (16 pos)");
        Util.setTooltipOnColumnHeader(this.monedaCuenta, "Moneda de Cuenta\nLongitud: 2\nTipo: N\u00famerico\n00 Pesos M.N.\n01 USD");
        Util.setTooltipOnColumnHeader(this.claveBanco, "N\u00famero de Banco Receptor\nLongitud:\nMinima 1\nMinima 3\nTipo: N\u00famerico\nConsulte el cat\u00e1logo de Bancos");
        Util.setTooltipOnColumnHeader(this.cuentaAbono, "N\u00famero de Cuenta\nLongitud:\nM\u00ednima 11\nMaxima 20\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.limiteTransaccion, "Importe con punto decimal\nLongitud:\nM\u00ednima 3\nMaxima 17\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.fechaEliminacion, "Fecha de Eliminaci\u00f3n AAAAMMDD\nLongitud:\nM\u00ednima 8\nMaxima 8\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.descripcion, "Descripci\u00f3n\nLongitud:\nM\u00ednima 1\nMaxima 50\nTipo: Alfanum\u00e9rico");
    }

    public void setCargarDesdeExcel(boolean cargarDesdeExcel) {
        this.cargarDesdeExcel = cargarDesdeExcel;
    }

    @FXML
    private void regresar(ActionEvent event) {
        String ruta = "/fxml/PreRegistroDeCuentas/Main/PreRegistroCuentas.fxml";
        String title = "Pre-Registro De Cuentas";
        Service.navegacion(ruta, title, event);
    }
}

