/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.controllers;

import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.scotiabank.productosGTB.business.Service;
import org.scotiabank.productosGTB.controllers.Codigos;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.LecturaReportes.PreregistroCuentasDetalle;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.LecturaReportes.PreregistroCuentasHeader;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.LecturaReportes.PreregistroCuentrasTrailerBloque;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.PreregistroCuentasModel;
import org.scotiabank.productosGTB.services.ReportePreregistroCuentasService;
import org.scotiabank.productosGTB.util.Constantes;
import org.scotiabank.productosGTB.util.Conversiones;
import org.scotiabank.productosGTB.util.Normalize;
import org.scotiabank.productosGTB.util.Util;
import org.scotiabank.productosGTB.util.UtilPDF;

public class PreregistroCuentasLecturaController {
    @FXML
    private Button importarArchivo;
    @FXML
    private TextField numContrato;
    @FXML
    private TextField codigoRespuesta;
    @FXML
    private TextField numDeArchivo;
    @FXML
    private TextField mantenimientoConsulta;
    @FXML
    private TableView<PreregistroCuentasDetalle> tableCodigos;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colTipoCuenta;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colTipoPago;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colCodigoRespuesta;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colMonedaCuenta;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colBancoCuenta;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colCuentaAbono;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colLimiteTransaccion;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colFechaEliminacion;
    @FXML
    private TableColumn<PreregistroCuentasDetalle, String> colDescripcion;
    @FXML
    private TextField cantidadDeMovimientosSolicitadosAltas;
    @FXML
    private TextField cantidadDeMovimientosSolicitadosCambios;
    @FXML
    private TextField cantidadDeMovimientosSolicitadosBajas;
    @FXML
    private TextField cantidadDeMovimientosSolicitadosConsultas;
    @FXML
    private TextField cantidadDeMovimientosAceptadosAltas;
    @FXML
    private TextField cantidadDeMovimientosAceptadosCambios;
    @FXML
    private TextField cantidadDeMovimientosAceptadosBajas;
    @FXML
    private TextField cantidadDeMovimientosAceptadosConsultas;
    @FXML
    private TextField cantidadDeMovimientosRechazadosAltas;
    @FXML
    private TextField cantidadDeMovimientosRechazadosCambios;
    @FXML
    private TextField cantidadDeMovimientosRechazadosBajas;
    @FXML
    private TextField cantidadDeMovimientosRechazadosConsultas;
    public static String rutaArchivoSeleccionado;
    @FXML
    Button btnreportPDF;

    @FXML
    private void cargarArchivo() throws IOException {
        PreregistroCuentasModel reporte = this.lecturaReportes();
        this.reporteHeader(reporte);
        this.llenarTabla(reporte.getPreregistroCuentasDetalle());
        this.reporteFooter(reporte);
        this.importarArchivo.setDisable(true);
    }

    private void llenarTabla(List<PreregistroCuentasDetalle> preregistroCuentasDetalleList) {
        ObservableList<PreregistroCuentasDetalle> data = FXCollections.observableArrayList(preregistroCuentasDetalleList);
        this.colTipoCuenta.setCellValueFactory(new PropertyValueFactory("cveTipoCuenta"));
        this.colTipoPago.setCellValueFactory(new PropertyValueFactory("tipoDePago"));
        this.colCodigoRespuesta.setCellValueFactory(new PropertyValueFactory("codigoRespuesta"));
        this.colMonedaCuenta.setCellValueFactory(new PropertyValueFactory("cveMonedaCuenta"));
        this.colBancoCuenta.setCellValueFactory(new PropertyValueFactory("numBancoCuenta"));
        this.colCuentaAbono.setCellValueFactory(new PropertyValueFactory("numCuenta"));
        this.colLimiteTransaccion.setCellValueFactory(new PropertyValueFactory("limitePorTransaccion"));
        this.colFechaEliminacion.setCellValueFactory(new PropertyValueFactory("fechaEliminacion"));
        this.colDescripcion.setCellValueFactory(new PropertyValueFactory("descripcion"));
        this.tableCodigos.setItems(data);
    }

    public PreregistroCuentasModel lecturaReportes() {
        File archivoReporteTXT = PreregistroCuentasLecturaController.seleccionarArchivoTXT();
        PreregistroCuentasModel reportePreregistro = new PreregistroCuentasModel();
        ReportePreregistroCuentasService rp = new ReportePreregistroCuentasService();
        try (BufferedReader reader = Files.newBufferedReader(archivoReporteTXT.toPath());){
            String linea;
            while ((linea = reader.readLine()) != null) {
                String tipoLinea;
                switch (tipoLinea = this.identificarTipoLinea(linea)) {
                    case "HEADER_FILE": {
                        if (linea.indexOf(32) == 43) {
                            reportePreregistro.preregistroCuentasHeader = rp.lecturaReporteHeader5posiciones(linea);
                            break;
                        }
                        reportePreregistro.preregistroCuentasHeader = rp.lecturaReporteHeader12posiciones(linea);
                        break;
                    }
                    case "DETALLE": {
                        reportePreregistro.preregistroCuentasDetalle.add(rp.lecturaReporteDetalle(linea));
                        break;
                    }
                    case "TRAILER_ARCHIVO": {
                        reportePreregistro.preregistroCuentrasTrailerBloque = rp.lecturaReporteTrailerBloque(linea);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reportePreregistro;
    }

    public static File seleccionarArchivoTXT() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Archivo de Texto", "*.txt"));
        File archivo = fileChooser.showOpenDialog(null);
        if (archivo != null) {
            rutaArchivoSeleccionado = archivo.getParent();
        }
        return archivo;
    }

    private String identificarTipoLinea(String linea) {
        String prefix4;
        String string = prefix4 = linea.length() >= 4 ? linea.substring(0, 4) : linea;
        if (Constantes.HEADER_FILE_PREREGISTRO.contains(prefix4)) {
            return "HEADER_FILE";
        }
        if (Constantes.DETALLE_PREREGISTRO.contains(prefix4)) {
            return "DETALLE";
        }
        if (Constantes.TRAILER_ARCHIVO_PREREGISTRO.contains(prefix4)) {
            return "TRAILER_ARCHIVO";
        }
        return "";
    }

    public void reporteHeader(PreregistroCuentasModel reporte) {
        PreregistroCuentasHeader header = reporte.getPreregistroCuentasHeader();
        if (header != null) {
            Conversiones conversiones = new Conversiones();
            this.numContrato.setText(header.getNumeroDeContrato());
            this.numContrato.setDisable(true);
            this.codigoRespuesta.setText(header.getCodigoRespuesta());
            this.codigoRespuesta.setDisable(true);
            this.numDeArchivo.setText(header.getSecuencia());
            this.numDeArchivo.setDisable(true);
            this.mantenimientoConsulta.setText(header.getMantenimientoOConsulta());
            this.mantenimientoConsulta.setDisable(true);
        } else {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error de carga");
            alert.setHeaderText("Datos no disponibles");
            alert.setContentText("No se pudo cargar la informaci\u00f3n del encabezado porque est\u00e1 erronea.");
            alert.showAndWait();
        }
    }

    public void reporteFooter(PreregistroCuentasModel reporte) {
        PreregistroCuentrasTrailerBloque trailerArchivo = reporte.getPreregistroCuentrasTrailerBloque();
        this.cantidadDeMovimientosSolicitadosAltas.setText(trailerArchivo.getCantidadMovimientosSolicitadosAltas());
        this.cantidadDeMovimientosSolicitadosAltas.setDisable(true);
        this.cantidadDeMovimientosSolicitadosCambios.setText(trailerArchivo.getCantidadMovimientosSolicitadosCambios());
        this.cantidadDeMovimientosSolicitadosCambios.setDisable(true);
        this.cantidadDeMovimientosSolicitadosBajas.setText(trailerArchivo.getCantidadMovimientosSolicitadosAltas());
        this.cantidadDeMovimientosSolicitadosBajas.setDisable(true);
        this.cantidadDeMovimientosSolicitadosConsultas.setText(trailerArchivo.getCantidadDeConsultasMovimientosSolicitados());
        this.cantidadDeMovimientosSolicitadosConsultas.setDisable(true);
        this.cantidadDeMovimientosAceptadosAltas.setText(trailerArchivo.getCantidadMovimientosAceptadosAltas());
        this.cantidadDeMovimientosAceptadosAltas.setDisable(true);
        this.cantidadDeMovimientosAceptadosCambios.setText(trailerArchivo.getCantidadMovimientosAceptadosBajas());
        this.cantidadDeMovimientosAceptadosCambios.setDisable(true);
        this.cantidadDeMovimientosAceptadosBajas.setText(trailerArchivo.getCantidadMovimientosAceptadosCambios());
        this.cantidadDeMovimientosAceptadosBajas.setDisable(true);
        this.cantidadDeMovimientosAceptadosConsultas.setText(trailerArchivo.getCantidadDeConsultasMovimientosAceptados());
        this.cantidadDeMovimientosAceptadosConsultas.setDisable(true);
        this.cantidadDeMovimientosRechazadosAltas.setText(trailerArchivo.getCantidadMovimientosRechazadosAltas());
        this.cantidadDeMovimientosRechazadosAltas.setDisable(true);
        this.cantidadDeMovimientosRechazadosCambios.setText(trailerArchivo.getCantidadMovimientosRechazadosBajas());
        this.cantidadDeMovimientosRechazadosCambios.setDisable(true);
        this.cantidadDeMovimientosRechazadosBajas.setText(trailerArchivo.getCantidadMovimientosRechazadosCambios());
        this.cantidadDeMovimientosRechazadosBajas.setDisable(true);
        this.cantidadDeMovimientosRechazadosConsultas.setText(trailerArchivo.getCantidadDeConsultasMovimientosRechazados());
        this.cantidadDeMovimientosRechazadosConsultas.setDisable(true);
    }

    @FXML
    private void generarReportePDF() {
        rutaArchivoSeleccionado = PreregistroCuentasLecturaController.seleccionarDirectorio(this.btnreportPDF);
        if (rutaArchivoSeleccionado == null) {
            this.mostrarAlerta("No se seleccion\u00f3 ninguna carpeta. Operaci\u00f3n cancelada.");
            return;
        }
        if (!rutaArchivoSeleccionado.endsWith("\\") && !rutaArchivoSeleccionado.endsWith("/")) {
            rutaArchivoSeleccionado = rutaArchivoSeleccionado + File.separator;
        }
        String fechaActual = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String horaActual = LocalTime.now().format(DateTimeFormatter.ofPattern("HH_mm"));
        String nombreArchivo = "reporte_PreRegistro_" + fechaActual + "-" + horaActual + UtilPDF.extencion;
        String rutaCompleta = Normalize.parse(rutaArchivoSeleccionado + nombreArchivo);
        try {
            File carpetaDestino = new File(rutaArchivoSeleccionado);
            if (!carpetaDestino.exists()) {
                carpetaDestino.mkdirs();
            }
            PdfWriter writer = new PdfWriter(rutaCompleta);
            PdfDocument pdf = new PdfDocument(writer);
            Document reporte = new Document(pdf, PageSize.A4.rotate());
            PreregistroCuentasLecturaController.agregarEncabezado(reporte, this.numContrato.getText(), this.numDeArchivo.getText(), this.codigoRespuesta.getText(), this.mantenimientoConsulta.getText());
            ObservableList<PreregistroCuentasDetalle> listado = this.tableCodigos.getItems();
            reporte.add((IBlockElement)new Paragraph("").setMarginTop(10.0f));
            this.reportePDFTabla(reporte, listado);
            reporte.add((IBlockElement)new Paragraph("").setMarginTop(10.0f));
            this.agregarFooter(reporte, this.cantidadDeMovimientosSolicitadosAltas.getText(), this.cantidadDeMovimientosSolicitadosCambios.getText(), this.cantidadDeMovimientosSolicitadosBajas.getText(), this.cantidadDeMovimientosSolicitadosConsultas.getText(), this.cantidadDeMovimientosAceptadosAltas.getText(), this.cantidadDeMovimientosAceptadosCambios.getText(), this.cantidadDeMovimientosAceptadosBajas.getText(), this.cantidadDeMovimientosAceptadosConsultas.getText(), this.cantidadDeMovimientosRechazadosAltas.getText(), this.cantidadDeMovimientosRechazadosCambios.getText(), this.cantidadDeMovimientosRechazadosBajas.getText(), this.cantidadDeMovimientosRechazadosConsultas.getText());
            reporte.close();
            File archivoGenerado = new File(rutaCompleta);
            if (archivoGenerado.exists() && archivoGenerado.length() > 0L) {
                this.mostrarAlerta("PDF generado correctamente en:\n" + rutaCompleta);
            } else {
                this.mostrarAlerta("Hubo un problema al generar el PDF. El archivo est\u00e1 vac\u00edo o no se cre\u00f3.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mostrarAlerta("Error al generar el PDF:\n" + e.getMessage());
        }
    }

    public void agregarFooter(Document doc, String cantidadDeMovimientosSolicitadosAltas, String cantidadDeMovimientosSolicitadosCambios, String cantidadDeMovimientosSolicitadosBajas, String cantidadDeMovimientosSolicitadosConsultas, String cantidadDeMovimientosAceptadosAltas, String cantidadDeMovimientosAceptadosCambios, String cantidadDeMovimientosAceptadosBajas, String cantidadDeMovimientosAceptadosConsultas, String cantidadDeMovimientosRechazadosAltas, String cantidadDeMovimientosRechazadosCambios, String cantidadDeMovimientosRechazadosBajas, String cantidadDeMovimientosRechazadosConsultas) {
        Table tablaIzquierda = new Table(1).useAllAvailableWidth();
        tablaIzquierda.addHeaderCell(PreregistroCuentasLecturaController.encabezadoIzquierda("Movimientos solicitados"));
        tablaIzquierda.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos altas: " + cantidadDeMovimientosSolicitadosAltas, TextAlignment.LEFT));
        tablaIzquierda.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos cambios: " + cantidadDeMovimientosSolicitadosCambios, TextAlignment.LEFT));
        tablaIzquierda.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos bajas: " + cantidadDeMovimientosSolicitadosBajas, TextAlignment.LEFT));
        tablaIzquierda.addCell(PreregistroCuentasLecturaController.celda("Cantidad de consultas: " + cantidadDeMovimientosSolicitadosConsultas, TextAlignment.LEFT));
        Table tablaCentro = new Table(1).useAllAvailableWidth();
        tablaCentro.addHeaderCell(PreregistroCuentasLecturaController.encabezadoCentro("Movimientos aceptados"));
        tablaCentro.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos altas:  " + cantidadDeMovimientosAceptadosAltas, TextAlignment.CENTER));
        tablaCentro.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos cambios: " + cantidadDeMovimientosAceptadosCambios, TextAlignment.CENTER));
        tablaCentro.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos bajas: " + cantidadDeMovimientosAceptadosBajas, TextAlignment.CENTER));
        tablaCentro.addCell(PreregistroCuentasLecturaController.celda("Cantidad de consultas: " + cantidadDeMovimientosAceptadosConsultas, TextAlignment.CENTER));
        Table tablaDerecha = new Table(1).useAllAvailableWidth();
        tablaDerecha.addHeaderCell(PreregistroCuentasLecturaController.encabezadoDerecha("Movimientos rechazados"));
        tablaDerecha.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos altas: " + cantidadDeMovimientosAceptadosAltas, TextAlignment.RIGHT));
        tablaDerecha.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos cambios: " + cantidadDeMovimientosAceptadosCambios, TextAlignment.RIGHT));
        tablaDerecha.addCell(PreregistroCuentasLecturaController.celda("Cantidad de movimientos bajas: " + cantidadDeMovimientosAceptadosBajas, TextAlignment.RIGHT));
        tablaDerecha.addCell(PreregistroCuentasLecturaController.celda("Cantidad de Consultas: " + cantidadDeMovimientosAceptadosConsultas, TextAlignment.RIGHT));
        Table tablaPrincipal = (Table)new Table(new float[]{1.0f, 1.0f, 1.0f}).setWidth(UnitValue.createPercentValue(100.0f));
        tablaPrincipal.addCell((Cell)((Cell)new Cell().add(tablaIzquierda).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT));
        tablaPrincipal.addCell((Cell)((Cell)new Cell().add(tablaCentro).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER));
        tablaPrincipal.addCell((Cell)((Cell)new Cell().add(tablaDerecha).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.RIGHT));
        doc.add(tablaPrincipal);
        doc.add((IBlockElement)new Paragraph(" ").setMarginBottom(25.0f));
    }

    private static Cell encabezadoDerecha(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setTextAlignment(TextAlignment.RIGHT)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
    }

    private static Cell encabezadoCentro(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setTextAlignment(TextAlignment.CENTER)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
    }

    private static Cell encabezadoIzquierda(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setTextAlignment(TextAlignment.LEFT)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
    }

    public void reportePDFTabla(Document doc, List<PreregistroCuentasDetalle> registros) throws IOException {
        PdfFont fontRegular = PdfFontFactory.createFont("Helvetica");
        PdfFont fontBold = PdfFontFactory.createFont("Helvetica-Bold");
        float fontSize = 4.5f;
        float[] columnWidths = new float[9];
        for (int i = 0; i < columnWidths.length; ++i) {
            columnWidths[i] = 1.0f;
        }
        Table tabla = new Table(UnitValue.createPercentArray(columnWidths)).useAllAvailableWidth();
        List<String> encabezados = UtilPDF.encabezadosPreregistro();
        for (String titulo : encabezados) {
            tabla.addHeaderCell((Cell)((Cell)((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(titulo).setFont(fontBold)).setFontSize(fontSize)).setBackgroundColor(ColorConstants.LIGHT_GRAY)).setTextAlignment(TextAlignment.CENTER)).setVerticalAlignment(VerticalAlignment.MIDDLE)).setPadding(2.0f));
        }
        for (PreregistroCuentasDetalle fila : registros) {
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getCveTipoCuenta()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getTipoDePago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getCodigoRespuesta()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getCveMonedaCuenta()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getNumBancoCuenta()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getNumCuenta()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getLimitePorTransaccion()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getFechaEliminacion()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getDescripcion()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
        }
        doc.add(tabla);
    }

    public static void agregarEncabezado(Document doc, String numContrato, String numDeArchivo, String codigoRespuesta, String mantenimientoConsulta) {
        float[] columnWidths = new float[]{1.0f, 1.0f};
        Table tabla = new Table(UnitValue.createPercentArray(columnWidths)).useAllAvailableWidth();
        tabla.addCell(PreregistroCuentasLecturaController.celda("N\u00famero de contrato: " + numContrato, TextAlignment.LEFT));
        tabla.addCell(PreregistroCuentasLecturaController.celda("N\u00famero de archivo del d\u00eda: " + numDeArchivo, TextAlignment.RIGHT));
        tabla.addCell(PreregistroCuentasLecturaController.celda("C\u00f3digo de respuesta: " + codigoRespuesta, TextAlignment.LEFT));
        tabla.addCell(PreregistroCuentasLecturaController.celda("Mantenimiento o consulta: " + mantenimientoConsulta, TextAlignment.RIGHT));
        doc.add(tabla);
    }

    private static Cell celda(String texto, TextAlignment alineacion) {
        return (Cell)((Cell)((Cell)((Cell)((Cell)new Cell().add((IBlockElement)new Paragraph(texto).setFontSize(10.0f)).setTextAlignment(alineacion)).setVerticalAlignment(VerticalAlignment.MIDDLE)).setBorder(Border.NO_BORDER)).setPadding(0.0f)).setMargin(0.0f);
    }

    public static String seleccionarDirectorio(Node nodoReferencia) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Selecciona una carpeta para guardar los archivos");
        Window ventana = nodoReferencia.getScene().getWindow();
        File directorio = directoryChooser.showDialog(ventana);
        if (directorio != null) {
            String ruta = Normalize.parse(directorio.getAbsolutePath());
            String nombreCarpeta = directorio.getName();
            if (!Util.esRutaValida(nombreCarpeta)) {
                Alert alerta = new Alert(Alert.AlertType.ERROR);
                alerta.setTitle("Carpeta inv\u00e1lida");
                alerta.setHeaderText("Nombre de carpeta no permitido");
                alerta.setContentText("Solo se permiten letras, n\u00fameros, espacios, guiones (-) y guiones bajos (_).");
                alerta.showAndWait();
                return null;
            }
            System.out.println("Directorio seleccionado: " + ruta);
            return ruta;
        }
        Alert alerta = new Alert(Alert.AlertType.ERROR);
        alerta.setTitle("Selecci\u00f3n cancelada");
        alerta.setHeaderText("No se seleccion\u00f3 ninguna carpeta");
        alerta.setContentText("Debes seleccionar una carpeta para continuar con el guardado.");
        alerta.showAndWait();
        return null;
    }

    private void mostrarAlerta(String mensaje) {
        Alert alerta = new Alert(Alert.AlertType.INFORMATION);
        alerta.setTitle("Estado del proceso");
        alerta.setHeaderText(null);
        alerta.setContentText(mensaje);
        alerta.showAndWait();
    }

    @FXML
    private void regresar(ActionEvent event) {
        String ruta = "/fxml/PreRegistroDeCuentas/Main/PreRegistroCuentas.fxml";
        String title = "Pre-Registro De Cuentas";
        Service.navegacion(ruta, title, event);
    }

    @FXML
    private void codigos(ActionEvent event) {
        try {
            String ruta = "/fxml/DispersionDeFondos/ResDispersionDeFondos/codigos.fxml";
            String title = "C\u00f3digos";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(ruta));
            Parent root = (Parent)loader.load();
            Codigos codigosController = (Codigos)loader.getController();
            codigosController.setRutaOrigen("/fxml/PreRegistroDeCuentas/resPreRegistroDeCuentas/LecturaReportesPreRegstroDeCuentas.fxml");
            codigosController.setTipoCodigo("preregistroDeCuenta");
            Stage nuevaVentana = new Stage();
            nuevaVentana.setTitle(title);
            nuevaVentana.setScene(new Scene(root));
            nuevaVentana.initModality(Modality.APPLICATION_MODAL);
            Stage ventanaActual = (Stage)((Node)event.getSource()).getScene().getWindow();
            nuevaVentana.initOwner(ventanaActual);
            nuevaVentana.showAndWait();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

