/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.controllers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.scotiabank.productosGTB.business.Service;
import org.scotiabank.productosGTB.data.ErrorData;
import org.scotiabank.productosGTB.enums.FileTypesEnum;
import org.scotiabank.productosGTB.enums.PaymentConceptEnum;
import org.scotiabank.productosGTB.enums.PaymentCurrencyEnum;
import org.scotiabank.productosGTB.model.SistemaDispersionData;
import org.scotiabank.productosGTB.util.ColumnaConfig;
import org.scotiabank.productosGTB.util.TextFieldValidator;
import org.scotiabank.productosGTB.util.TooltipManager;
import org.scotiabank.productosGTB.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SistemaDispercionFondosController {
    private static final Logger log = LoggerFactory.getLogger(SistemaDispercionFondosController.class);
    @FXML
    private TextField textFieldClientNumber;
    @FXML
    private TextField textFieldFileNumberOfTheDay;
    @FXML
    private TextField textFieldChargeAccount;
    @FXML
    private TextField textFieldCompanyReference;
    @FXML
    private ComboBox<FileTypesEnum> comboBoxFileType;
    @FXML
    private ComboBox<PaymentConceptEnum> comboBoxPaymentConcept;
    @FXML
    private ComboBox<PaymentCurrencyEnum> comboBoxPaymentCurrency;
    @FXML
    private DatePicker datePicketFechaAplicacion;
    @FXML
    private TableView<SistemaDispersionData> tableViewDispersionFondos;
    private ObservableList<SistemaDispersionData> dataList;
    @FXML
    private TableColumn<SistemaDispersionData, Integer> num;
    @FXML
    private TableColumn<SistemaDispersionData, String> formaPago;
    @FXML
    private TableColumn<SistemaDispersionData, String> tipoCuenta;
    @FXML
    private TableColumn<SistemaDispersionData, String> cuenta;
    @FXML
    private TableColumn<SistemaDispersionData, String> importePago;
    @FXML
    private TableColumn<SistemaDispersionData, String> claveBeneficiario;
    @FXML
    private TableColumn<SistemaDispersionData, String> rfcBeneficiario;
    @FXML
    private TableColumn<SistemaDispersionData, String> nombreBeneficiario;
    @FXML
    private TableColumn<SistemaDispersionData, String> referenciaPago;
    @FXML
    private TableColumn<SistemaDispersionData, String> conceptoPago;
    @FXML
    private TableColumn<SistemaDispersionData, String> diasVigencia;
    @FXML
    private TableColumn<SistemaDispersionData, String> infoAgruparPagos;
    @FXML
    private TableColumn<SistemaDispersionData, String> detalleMail;
    @FXML
    private TableColumn<SistemaDispersionData, String> referenciaAbonoBanxico;
    @FXML
    private TableColumn<SistemaDispersionData, String> tipoOperacion;
    @FXML
    private TableColumn<SistemaDispersionData, String> bancoReceptor;
    @FXML
    private Label errorLabelClientNumber;
    @FXML
    private Label errorLabelChargeAccount;
    @FXML
    private Label errorLabelFileNumberOfTheDay;
    @FXML
    private Label errorLabelCompanyReference;
    @FXML
    private Label errorLabelFechaAplicacion;
    @FXML
    private Hyperlink btnCargar;
    @FXML
    private Button btnAgregarFila;
    @FXML
    private Button btnEliminarFila;
    private boolean campoEditado = false;
    private final ObservableList<SistemaDispersionData> datos = FXCollections.observableArrayList();
    private boolean cargarDesdeExcel = false;

    @FXML
    public void initialize() {
        Platform.runLater(() -> this.tableViewDispersionFondos.getScene().getRoot().requestFocus());
        this.tableViewDispersionFondos.setOnKeyPressed(event -> {
            if (event.isControlDown() && event.getCode() == KeyCode.V) {
                this.pasteFromClipboard();
            }
        });
        this.restringeTextField();
        this.fillAllComboBox();
        Util.limitarFechas(this.datePicketFechaAplicacion, ((FileTypesEnum)((Object)this.comboBoxFileType.getValue())).getId());
        this.agregaTooltips();
        this.comboBoxFileType.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                Util.limitarFechas(this.datePicketFechaAplicacion, newVal.getId());
                this.datePicketFechaAplicacion.setValue(null);
            }
        });
        Platform.runLater(() -> {
            this.dataList = FXCollections.observableArrayList(new SistemaDispersionData(1, "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""));
            this.tableViewDispersionFondos.setItems(this.dataList);
            this.btnCargar.setOnAction(e -> this.importarExcel());
            if (this.cargarDesdeExcel) {
                Util.setTablaEditable(this.tableViewDispersionFondos, this.btnAgregarFila, this.btnEliminarFila, true);
            }
        });
        this.fillTable();
    }

    public void fillAllComboBox() {
        this.comboBoxFileType.setItems(FXCollections.observableArrayList(FileTypesEnum.values()));
        this.comboBoxFileType.getSelectionModel().selectFirst();
        this.comboBoxPaymentConcept.setItems(FXCollections.observableArrayList(PaymentConceptEnum.values()));
        this.comboBoxPaymentConcept.getSelectionModel().selectFirst();
        this.comboBoxPaymentCurrency.setItems(FXCollections.observableArrayList(PaymentCurrencyEnum.values()));
        this.comboBoxPaymentCurrency.getSelectionModel().selectFirst();
        this.datePicketFechaAplicacion.setEditable(false);
    }

    public void fillTable() {
        this.formaPago.setCellValueFactory(new PropertyValueFactory("formaPago"));
        this.tipoCuenta.setCellValueFactory(new PropertyValueFactory("tipoCuenta"));
        this.bancoReceptor.setCellValueFactory(new PropertyValueFactory("bancoReceptor"));
        this.cuenta.setCellValueFactory(new PropertyValueFactory("cuenta"));
        this.importePago.setCellValueFactory(new PropertyValueFactory("importePago"));
        this.claveBeneficiario.setCellValueFactory(new PropertyValueFactory("claveBeneficiario"));
        this.rfcBeneficiario.setCellValueFactory(new PropertyValueFactory("rfcBeneficiario"));
        this.nombreBeneficiario.setCellValueFactory(new PropertyValueFactory("nombreBeneficiario"));
        this.referenciaPago.setCellValueFactory(new PropertyValueFactory("referenciaPago"));
        this.conceptoPago.setCellValueFactory(new PropertyValueFactory("conceptoPago"));
        this.diasVigencia.setCellValueFactory(new PropertyValueFactory("diasVigencia"));
        this.infoAgruparPagos.setCellValueFactory(new PropertyValueFactory("infoAgruparPagos"));
        this.detalleMail.setCellValueFactory(new PropertyValueFactory("detalleMail"));
        this.referenciaAbonoBanxico.setCellValueFactory(new PropertyValueFactory("referenciaAbonoBanxico"));
        this.tipoOperacion.setCellValueFactory(new PropertyValueFactory("tipoOperacion"));
        this.num.setCellValueFactory(new PropertyValueFactory("num"));
        this.formaPago.setCellFactory(Util.createPersonalizedCellFactory(Arrays.asList("01", "02", "03", "04", "10")));
        this.tipoCuenta.setCellFactory(Util.createPersonalizedCellFactory(Arrays.asList("1", "3", "9")));
        this.bancoReceptor.setCellFactory(Util.createNumericCellFactory(3, 3));
        this.cuenta.setCellFactory(Util.createNumericCellFactory(11, 20));
        this.importePago.setCellFactory(Util.createDecimalCellFactory(1, 15));
        this.claveBeneficiario.setCellFactory(Util.createStringWithoutSymbolsCellFactory(1, 20));
        this.rfcBeneficiario.setCellFactory(Util.createStringWithoutSymbolsCellFactory(12, 13));
        this.nombreBeneficiario.setCellFactory(Util.createStringWithoutSymbolsCellFactory(1, 40));
        this.referenciaPago.setCellFactory(Util.createNumericCellFactory(1, 16));
        this.conceptoPago.setCellFactory(Util.createStringWithoutSymbolsCellFactory(1, 40));
        this.diasVigencia.setCellFactory(Util.createNumericCellFactory(1, 2));
        this.infoAgruparPagos.setCellFactory(Util.createStringWithoutSymbolsCellFactory(1, 60));
        this.detalleMail.setCellFactory(Util.createStringEmailCellFactory(1, 100));
        this.referenciaAbonoBanxico.setCellFactory(Util.createNumericCellFactory(1, 20));
        this.tipoOperacion.setCellFactory(Util.createNumericCellFactory(2, 2));
        this.tableViewDispersionFondos.setEditable(true);
    }

    @FXML
    private void agregarFila(ActionEvent event) {
        System.out.println("MIRA ALAAHAJ -- " + this.dataList.size());
        Integer nuevoNumero = this.dataList.size() + 1;
        SistemaDispersionData nuevaFila = new SistemaDispersionData(nuevoNumero, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        this.dataList.add(nuevaFila);
        this.tableViewDispersionFondos.refresh();
    }

    @FXML
    private void eliminarFila(ActionEvent event) {
        if (this.dataList.size() > 1) {
            this.dataList.removeLast();
            this.tableViewDispersionFondos.refresh();
        } else {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("Error de Eliminaci\u00f3n");
            alert.setHeaderText(null);
            alert.setContentText("No puedes eliminar la \u00faltima fila de la tabla.");
            alert.showAndWait();
        }
    }

    public void agregaTooltips() {
        TooltipManager.applyTooltip(this.textFieldClientNumber, "REQUERIDO\nSolo n\u00fameros\nMinimo 5 d\u00edgitos\nMaximo 12 digitos");
        TooltipManager.applyTooltip(this.textFieldFileNumberOfTheDay, "REQUERIDO\nSolo n\u00fameros\nMinimo 1 d\u00edgito\nMaximo 2 d\u00edgitos\nRango del 1 al 99");
        TooltipManager.applyTooltip(this.textFieldChargeAccount, "REQUERIDO\nSolo n\u00fameros\nMinimo y m\u00e1ximo 11 d\u00edgitos");
        TooltipManager.applyTooltip(this.textFieldCompanyReference, "REQUERIDO\nSolo n\u00fameros\nMinimo y m\u00e1ximo 10 d\u00edgitos");
        Util.setTooltipOnColumnHeader(this.formaPago, "Formas de Pago Disponibles\n01 Efectivo en ventanilla\n02 Cheque de caja ventanilla\n03 Cheque de caja central\n04 Abono a Cuenta\n10 Operacion SPID");
        Util.setTooltipOnColumnHeader(this.tipoCuenta, "Tipo de Cuenta del Banco\n1 Cuenta de Cheques 11 Pos. \n3 Tarjeta D\u00e9bito 16 Pos.\n9 Cuenta Cheques CLABE 18 Pos.");
        Util.setTooltipOnColumnHeader(this.bancoReceptor, "N\u00famero de Banco Receptor\nLongitud:\nMinima 1\nMinima 3\nTipo: N\u00famerico\nConsulte el cat\u00e1logo de Bancos");
        Util.setTooltipOnColumnHeader(this.cuenta, "N\u00famero de Cuenta\nLongitud:\nM\u00ednima 11\nMaxima 20\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.importePago, "Importe sin punto decimal\nLongitud:\nM\u00ednima 3\nMaxima 15\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.claveBeneficiario, "Clave del Beneficiario\nLongitud:\nM\u00ednima 1\nMaxima 20\nTipo: Alfanum\u00e9rico");
        Util.setTooltipOnColumnHeader(this.rfcBeneficiario, "RFC Beneficiario\nLongitud:\nM\u00ednima 12\nMaxima 13\nTipo: Alfanum\u00e9rico");
        Util.setTooltipOnColumnHeader(this.nombreBeneficiario, "Nombre del Beneficiario\nLongitud:\nM\u00ednima 1\nMaxima 40\nTipo: Alfanum\u00e9rico");
        Util.setTooltipOnColumnHeader(this.referenciaPago, "Referencia de Pago\nLongitud:\nM\u00ednima 1\nMaxima 16\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.conceptoPago, "Concepto de Pago - Obligatorio\nLongitud:\nM\u00ednima 1\nMaxima 16\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.diasVigencia, "D\u00edas de Vigencia (Obligatorio)\nLongitud:\nM\u00ednima 1\nMaxima 2\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.infoAgruparPagos, "Campo de Agrupaci\u00f3n - Opcional\nLongitud:\nM\u00ednima 1\nMaxima 60\nTipo: Alfanum\u00e9rico");
        Util.setTooltipOnColumnHeader(this.detalleMail, "Detalle Mail\nLongitud:\nM\u00ednima 100\nTipo:\nAlfanum\u00e9rico");
        Util.setTooltipOnColumnHeader(this.referenciaAbonoBanxico, "Referencia Abono Banxico\nLongitud:\nM\u00ednima 1\nMaxima 20\nTipo: N\u00famerico");
        Util.setTooltipOnColumnHeader(this.tipoOperacion, "Tipo de Operaci\u00f3n\n01 Liquidaci\u00f3n de operaci\u00f3n con valores\n02 Liquidaci\u00f3n de operaci\u00f3n derivada\n03 Liquidaci\u00f3n de operaci\u00f3n cambiaria\n04 Pago de servicios\n05 Pago de bienes\n06 Otorgamiento de pr\u00e9stamo\n07 Pago de pr\u00e9stamo\n07 Pago de pr\u00e9stamo\n08 Otros");
    }

    public void exportarDatosAArchivoOptimizada() {
        this.tableViewDispersionFondos.refresh();
        if (this.validateForm(true)) {
            DateTimeFormatter formato = DateTimeFormatter.ofPattern("yyyyMMdd");
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Guardar Archivo de Datos");
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Archivos de texto (*.txt)", "*.txt");
            fileChooser.getExtensionFilters().add(extFilter);
            File file = fileChooser.showSaveDialog(new Stage());
            if (file != null) {
                try (FileWriter fw = new FileWriter(file);
                     BufferedWriter bw = new BufferedWriter(fw);
                     PrintWriter writer = new PrintWriter(bw);){
                    String fillerLinea1;
                    String numClienteCompleto;
                    int contadorAltasOBajas = 0;
                    double contadorImportes = 0.0;
                    if (this.textFieldClientNumber.getText().length() >= 6) {
                        numClienteCompleto = Util.rellenarConCerosIzquierda(this.textFieldClientNumber.getText(), 12);
                        fillerLinea1 = Util.rellenarConEspaciosDerecha("", 325);
                    } else {
                        numClienteCompleto = Util.rellenarConCerosIzquierda(this.textFieldClientNumber.getText(), 5);
                        fillerLinea1 = Util.rellenarConEspaciosDerecha("", 332);
                    }
                    writer.print("EEHA" + numClienteCompleto + Util.rellenarConCerosIzquierda(this.textFieldFileNumberOfTheDay.getText(), 2) + "000000000000000000000000000" + fillerLinea1 + "\r\n");
                    writer.print("EEHB" + Util.rellenarConCerosIzquierda(((PaymentCurrencyEnum)((Object)this.comboBoxPaymentCurrency.getValue())).getId(), 2) + "0000" + Util.rellenarConCerosIzquierda(this.textFieldChargeAccount.getText(), 11) + Util.rellenarConCerosIzquierda(this.textFieldCompanyReference.getText(), 10) + "000" + Util.rellenarConEspaciosDerecha("", 336) + "\r\n");
                    for (SistemaDispersionData data : this.dataList) {
                        ++contadorAltasOBajas;
                        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
                        symbols.setDecimalSeparator('.');
                        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00", symbols);
                        decimalFormat.setParseBigDecimal(true);
                        try {
                            String cleanedString = data.getImportePago().replaceAll(",", "");
                            Number parsedNumber = decimalFormat.parse(cleanedString);
                            contadorImportes += parsedNumber.doubleValue();
                        }
                        catch (ParseException e) {
                            System.err.println("Error al parsear el importe");
                        }
                        String detalleArchivo = "";
                        detalleArchivo = ((FileTypesEnum)((Object)this.comboBoxFileType.getValue())).getId().equals("1") ? "DA" : "DB";
                        writer.print("EE" + detalleArchivo + Util.rellenarConCerosIzquierda(data.getFormaPago(), 2) + Util.rellenarConCerosIzquierda(((PaymentCurrencyEnum)((Object)this.comboBoxPaymentCurrency.getValue())).getId(), 2) + Util.rellenarConCerosIzquierda(data.getImportePago().replaceAll("\\.", ""), 15) + ((LocalDate)this.datePicketFechaAplicacion.getValue()).format(formato) + Util.rellenarConCerosIzquierda(((PaymentConceptEnum)((Object)this.comboBoxPaymentConcept.getValue())).getId(), 2) + Util.rellenarConEspaciosDerecha(data.getClaveBeneficiario(), 20) + Util.rellenarConCerosIzquierda(data.getRfcBeneficiario(), 13) + Util.rellenarConEspaciosDerecha(data.getNombreBeneficiario(), 40) + Util.rellenarConCerosIzquierda(data.getReferenciaPago(), 16) + Util.rellenarConCerosIzquierda("", 10) + Util.rellenarConCerosIzquierda(data.getCuenta(), 20) + Util.rellenarConCerosIzquierda("", 5) + Util.rellenarConEspaciosDerecha("", 40) + data.getTipoCuenta() + Util.rellenarConEspaciosDerecha("", 1) + Util.rellenarConCerosIzquierda("", 5) + "044" + Util.rellenarConCerosIzquierda(data.getBancoReceptor(), 3) + Util.rellenarConCerosIzquierda(data.getDiasVigencia(), 3) + Util.rellenarConEspaciosDerecha(data.getConceptoPago(), 50) + Util.rellenarConEspaciosDerecha(data.getInfoAgruparPagos(), 60) + Util.rellenarConCerosIzquierda("", 25) + Util.rellenarConEspaciosDerecha("", 16) + Util.rellenarConEspaciosDerecha("", 6) + "\r\n");
                        writer.print("EEDM" + Util.rellenarConEspaciosDerecha(data.getDetalleMail(), 100) + Util.rellenarConCerosIzquierda("", 34) + Util.rellenarConEspaciosDerecha("", 30) + Util.rellenarConCerosIzquierda(data.getReferenciaAbonoBanxico(), 20) + Util.rellenarConCerosIzquierda(data.getTipoOperacion(), 2) + Util.rellenarConEspaciosDerecha("", 180) + "\r\n");
                    }
                    DecimalFormat formatoImporte = new DecimalFormat("0.00");
                    if (Objects.equals(((FileTypesEnum)((Object)this.comboBoxFileType.getValue())).getId(), "1")) {
                        writer.print("EETB" + Util.rellenarConCerosIzquierda(Integer.toString(contadorAltasOBajas), 7) + Util.rellenarConCerosIzquierda(formatoImporte.format(contadorImportes).replaceAll("\\.", ""), 17) + Util.rellenarConCerosIzquierda("", 7) + Util.rellenarConCerosIzquierda("", 17) + Util.rellenarConCerosIzquierda("", 195) + Util.rellenarConEspaciosDerecha("", 123) + "\r\n");
                        writer.print("EETA" + Util.rellenarConCerosIzquierda(Integer.toString(contadorAltasOBajas), 7) + Util.rellenarConCerosIzquierda(formatoImporte.format(contadorImportes).replaceAll("\\.", ""), 17) + Util.rellenarConCerosIzquierda("", 7) + Util.rellenarConCerosIzquierda("", 17) + Util.rellenarConCerosIzquierda("", 195) + Util.rellenarConEspaciosDerecha("", 123) + "\r\n");
                    } else {
                        writer.print("EETB" + Util.rellenarConCerosIzquierda("", 7) + Util.rellenarConCerosIzquierda("", 17) + Util.rellenarConCerosIzquierda(Integer.toString(contadorAltasOBajas), 7) + Util.rellenarConCerosIzquierda(formatoImporte.format(contadorImportes).replaceAll("\\.", ""), 17) + Util.rellenarConCerosIzquierda("", 195) + Util.rellenarConEspaciosDerecha("", 123) + "\r\n");
                        writer.print("EETA" + Util.rellenarConCerosIzquierda("", 7) + Util.rellenarConCerosIzquierda("", 17) + Util.rellenarConCerosIzquierda(Integer.toString(contadorAltasOBajas), 7) + Util.rellenarConCerosIzquierda(formatoImporte.format(contadorImportes).replaceAll("\\.", ""), 17) + Util.rellenarConCerosIzquierda("", 195) + Util.rellenarConEspaciosDerecha("", 123) + "\r\n");
                    }
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("Exportaci\u00f3n Exitosa");
                    alert.setHeaderText(null);
                    alert.setContentText("Los datos se han guardado en el archivo: " + file.getAbsolutePath());
                    alert.showAndWait();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Error de Exportaci\u00f3n");
                    alert.setHeaderText("No se pudo guardar el archivo.");
                    alert.setContentText("Ocurri\u00f3 un error al intentar escribir los datos. Por favor, int\u00e9ntelo de nuevo.");
                    alert.showAndWait();
                }
            }
        } else {
            System.out.println("Se omiti\u00f3 exportaci\u00f3n por falta de informaci\u00f3n");
        }
    }

    public void borrarTabla() {
        this.dataList.clear();
        SistemaDispersionData nuevaFila = new SistemaDispersionData(1, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        this.dataList.add(nuevaFila);
        this.textFieldClientNumber.clear();
        this.textFieldFileNumberOfTheDay.clear();
        this.textFieldChargeAccount.clear();
        this.textFieldCompanyReference.clear();
        this.datePicketFechaAplicacion.setValue(null);
        this.tableViewDispersionFondos.refresh();
    }

    private boolean validateForm(boolean validateAll) {
        boolean allFieldsAreValid = true;
        this.textFieldClientNumber.getStyleClass().remove("error-field");
        this.textFieldFileNumberOfTheDay.getStyleClass().remove("error-field");
        this.textFieldChargeAccount.getStyleClass().remove("error-field");
        this.textFieldCompanyReference.getStyleClass().remove("error-field");
        this.datePicketFechaAplicacion.getStyleClass().remove("error-field");
        this.errorLabelClientNumber.setVisible(false);
        this.errorLabelFileNumberOfTheDay.setVisible(false);
        this.errorLabelChargeAccount.setVisible(false);
        this.errorLabelCompanyReference.setVisible(false);
        this.errorLabelFechaAplicacion.setVisible(false);
        if (this.textFieldClientNumber.getText().trim().isEmpty()) {
            this.textFieldClientNumber.getStyleClass().add("error-field");
            this.errorLabelClientNumber.setText("Este campo es requerido.");
            this.errorLabelClientNumber.setVisible(true);
            allFieldsAreValid = false;
        }
        if (this.textFieldFileNumberOfTheDay.getText().trim().isEmpty()) {
            this.textFieldFileNumberOfTheDay.getStyleClass().add("error-field");
            this.errorLabelFileNumberOfTheDay.setText("Este campo es requerido.");
            this.errorLabelFileNumberOfTheDay.setVisible(true);
            allFieldsAreValid = false;
        }
        if (this.textFieldChargeAccount.getText().trim().isEmpty()) {
            this.textFieldChargeAccount.getStyleClass().add("error-field");
            this.errorLabelChargeAccount.setText("Este campo es requerido.");
            this.errorLabelChargeAccount.setVisible(true);
            allFieldsAreValid = false;
        }
        if (this.textFieldCompanyReference.getText().trim().isEmpty()) {
            this.textFieldCompanyReference.getStyleClass().add("error-field");
            this.errorLabelCompanyReference.setText("Este campo es requerido.");
            this.errorLabelCompanyReference.setVisible(true);
            allFieldsAreValid = false;
        }
        if (this.datePicketFechaAplicacion.getValue() == null) {
            this.datePicketFechaAplicacion.getStyleClass().add("error-field");
            this.errorLabelFechaAplicacion.setText("Este campo es requerido.");
            this.errorLabelFechaAplicacion.setVisible(true);
            allFieldsAreValid = false;
        }
        if (!allFieldsAreValid && this.cargarDesdeExcel) {
            return false;
        }
        if (!validateAll) {
            return true;
        }
        if (this.tableViewDispersionFondos.getItems().isEmpty()) {
            Util.mostrarAlerta("La tabla no contiene infomaci\u00f3n");
            return false;
        }
        StringBuilder errorMessage = new StringBuilder("Por favor, llena los campos obligatorios:\n\n");
        boolean hasTableErrors = false;
        int rowIndex = 0;
        for (SistemaDispersionData data : this.tableViewDispersionFondos.getItems()) {
            ++rowIndex;
            if (data.getFormaPago() == null || data.getFormaPago().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Forma de Pago' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getTipoCuenta() == null || data.getTipoCuenta().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Tipo de Cuenta' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getBancoReceptor() == null || data.getBancoReceptor().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Banco Receptor' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getCuenta() == null || data.getCuenta().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Cuenta' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getImportePago() == null || data.getImportePago().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Importe de Pago' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getClaveBeneficiario() == null || data.getClaveBeneficiario().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Clave Beneficiario' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getRfcBeneficiario() == null || data.getRfcBeneficiario().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'RFC Beneficiario' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getNombreBeneficiario() == null || data.getNombreBeneficiario().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Nombre Beneficiario' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getReferenciaPago() == null || data.getReferenciaPago().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Referencia de Pago' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getConceptoPago() == null || data.getConceptoPago().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Concepto de Pago' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getDiasVigencia().equals("0") || data.getDiasVigencia() == null || data.getDiasVigencia().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Dias Vigencia' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getDetalleMail() == null || data.getDetalleMail().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Detalle Mail' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (!Objects.equals(data.getFormaPago(), "10")) continue;
            if (data.getReferenciaAbonoBanxico() == null || data.getReferenciaAbonoBanxico().trim().isEmpty()) {
                errorMessage.append("\u2022 Columna 'Referencia abono banxico' del registro ").append(rowIndex).append("\n");
                allFieldsAreValid = false;
                hasTableErrors = true;
            }
            if (data.getTipoOperacion() != null && !data.getTipoOperacion().trim().isEmpty()) continue;
            errorMessage.append("\u2022 Columna 'Tipo operaci\u00f3n' del registro ").append(rowIndex).append("\n");
            allFieldsAreValid = false;
            hasTableErrors = true;
        }
        if (hasTableErrors) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("Error de Validaci\u00f3n");
            alert.setHeaderText("Campos de la tabla incompletos. Despl\u00e1zate para ver todos los errores:");
            TextArea textArea = new TextArea(errorMessage.toString());
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            textArea.setPrefHeight(300.0);
            alert.getDialogPane().setExpandableContent(textArea);
            alert.getDialogPane().setExpanded(true);
            alert.showAndWait();
        }
        return allFieldsAreValid;
    }

    private void pasteFromClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String clipboardContent = clipboard.getString();
        if (clipboardContent == null || clipboardContent.trim().isEmpty()) {
            return;
        }
        String[] rows = clipboardContent.split("\n");
        for (int i = 0; i < rows.length; ++i) {
            SistemaDispersionData rowData;
            String[] columns = rows[i].split("\t");
            if (this.tableViewDispersionFondos.getItems().size() > i) {
                rowData = (SistemaDispersionData)this.tableViewDispersionFondos.getItems().get(i);
            } else {
                rowData = new SistemaDispersionData(this.tableViewDispersionFondos.getItems().size() + 1, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
                this.tableViewDispersionFondos.getItems().add(rowData);
            }
            if (columns.length > 0) {
                rowData.setFormaPago(columns[0]);
            }
            if (columns.length > 1) {
                rowData.setTipoCuenta(columns[1]);
            }
            if (columns.length > 2) {
                rowData.setBancoReceptor(columns[2]);
            }
            if (columns.length > 3) {
                rowData.setCuenta(columns[3]);
            }
            if (columns.length > 4) {
                rowData.setImportePago(columns[4]);
            }
            if (columns.length > 5) {
                rowData.setClaveBeneficiario(columns[5]);
            }
            if (columns.length > 6) {
                rowData.setRfcBeneficiario(columns[6]);
            }
            if (columns.length > 7) {
                rowData.setNombreBeneficiario(columns[7]);
            }
            if (columns.length > 8) {
                rowData.setReferenciaPago(columns[8]);
            }
            if (columns.length > 9) {
                rowData.setConceptoPago(columns[9]);
            }
            if (columns.length > 10) {
                rowData.setDiasVigencia(columns[10]);
            }
            if (columns.length > 11) {
                rowData.setInfoAgruparPagos(columns[11]);
            }
            if (columns.length > 12) {
                rowData.setDetalleMail(columns[12]);
            }
            if (columns.length > 13) {
                rowData.setReferenciaAbonoBanxico(columns[13]);
            }
            if (columns.length <= 14) continue;
            rowData.setTipoOperacion(columns[14]);
        }
        this.tableViewDispersionFondos.refresh();
    }

    public void restringeTextField() {
        this.textFieldClientNumber.textProperty().addListener((obs, oldVal, newVal) -> {
            this.campoEditado = true;
        });
        this.textFieldClientNumber.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue() && this.campoEditado) {
                TextFieldValidator.validarNumerosYMaxLength(this.textFieldClientNumber, 12, 1);
            }
        });
        this.textFieldFileNumberOfTheDay.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                TextFieldValidator.validarNumerosYMaxLength(this.textFieldFileNumberOfTheDay, 2, 1);
            }
        });
        this.textFieldCompanyReference.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                TextFieldValidator.validarNumerosYMaxLength(this.textFieldCompanyReference, 10, 10);
            }
        });
        this.textFieldChargeAccount.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                TextFieldValidator.validarNumerosYMaxLength(this.textFieldChargeAccount, 11, 11);
            }
        });
    }

    public void setCargarDesdeExcel(boolean cargarDesdeExcel) {
        this.cargarDesdeExcel = cargarDesdeExcel;
    }

    @FXML
    private void importarExcel() {
        if (this.validateForm(false)) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Selecciona archivo Excel");
            fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Excel Files", "*.xlsx"));
            File archivo = fileChooser.showOpenDialog(this.btnCargar.getScene().getWindow());
            if (archivo != null) {
                ArrayList<ErrorData> erroresDeFormato = new ArrayList<ErrorData>();
                List<String> allowedFormasPago = Arrays.asList("01", "02", "03", "04", "10");
                List<String> allowedTipoPago = Arrays.asList("1", "3", "9");
                List<ColumnaConfig> configuracion = Arrays.asList(new ColumnaConfig("Forma Pago", 0, Util::isValidAllowedValue, "Contiene valores no permitidos", allowedFormasPago), new ColumnaConfig("Tipo de Cuenta", 1, (v, l) -> Util.isValidNumeric(v, 1, 1), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Banco Receptor", 2, (v, l) -> Util.isValidNumeric(v, 3, 3), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Cuenta", 3, (v, l) -> Util.isValidNumeric(v, 11, 20), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Importe Pago", 4, (v, l) -> Util.isValidDecimal(v, 1, 13), "Formato incorrecto (solo n\u00fameros y 2 decimales).", null), new ColumnaConfig("Clave Beneficiario", 5, (v, l) -> Util.isValidStringWithoutSymbols(v, 1, 20), "Contiene s\u00edmbolos, may\u00fasculas o acentos no permitidos o la longitud no es la correcta.", null), new ColumnaConfig("RFC Beneficiario", 6, (v, l) -> Util.isValidStringWithoutSymbols(v, 12, 13), "Contiene s\u00edmbolos, may\u00fasculas o acentos no permitidos o la longitud no es la correcta.", null), new ColumnaConfig("Nombre Beneficiario", 7, (v, l) -> Util.isValidStringWithoutSymbols(v, 1, 40), "Contiene s\u00edmbolos, may\u00fasculas o acentos no permitidos o la longitud no es la correcta.", null), new ColumnaConfig("Referencia Pago", 8, (v, l) -> Util.isValidNumeric(v, 1, 16), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Concepto Pago", 9, (v, l) -> Util.isValidStringWithoutSymbols(v, 1, 40), "Contiene s\u00edmbolos, may\u00fasculas o acentos no permitidos o la longitud no es la correcta.", null), new ColumnaConfig("Dias Vigencia", 10, (v, l) -> Util.isValidNumeric(v, 1, 2), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Info Agrupar Pagos", 11, (v, l) -> Util.isValidStringWithoutSymbols(v, 0, 60), "Contiene s\u00edmbolos, may\u00fasculas o acentos no permitidos o la longitud no es la correcta.", null), new ColumnaConfig("Detalle Mail", 12, (v, l) -> Util.isValidEmail(v, 1, 100), "Contiene s\u00edmbolos o acentos no permitidos o la longitud no es la correcta.", null), new ColumnaConfig("Referencia Abono Banxico", 13, (v, l) -> Util.isValidNumeric(v, 0, 20), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null), new ColumnaConfig("Tipo Operacion", 14, (v, l) -> Util.isValidNumeric(v, 0, 2), "Debe contener solo n\u00fameros o la longitud no es la correcta.", null));
                try (FileInputStream fis = new FileInputStream(archivo);
                     Workbook workbook = WorkbookFactory.create(fis);){
                    Sheet hoja = workbook.getSheetAt(0);
                    this.dataList.clear();
                    int consecutivo = 0;
                    for (int i = 1; i <= hoja.getLastRowNum(); ++i) {
                        Row fila = hoja.getRow(i);
                        if (fila == null) continue;
                        boolean filaTieneErrores = false;
                        String[] valoresCelda = new String[configuracion.size()];
                        for (ColumnaConfig config : configuracion) {
                            String valor = this.getCellValue(fila.getCell(config.indice));
                            boolean esValido = config.validador.apply(valor, config.valoresPermitidos);
                            if (!esValido) {
                                erroresDeFormato.add(new ErrorData(i + 1, config.nombre, valor, config.mensajeError));
                                filaTieneErrores = true;
                                valoresCelda[config.indice] = "";
                                continue;
                            }
                            valoresCelda[config.indice] = valor;
                        }
                        if (valoresCelda[0].equals("10")) {
                            boolean tipoOperacionValida;
                            String referenciaAbono = valoresCelda[13];
                            String tipoOperacion = valoresCelda[14];
                            boolean referenciaValida = referenciaAbono != null && !referenciaAbono.isEmpty();
                            boolean bl = tipoOperacionValida = tipoOperacion != null && !tipoOperacion.isEmpty();
                            if (!referenciaValida) {
                                erroresDeFormato.add(new ErrorData(i + 1, "Referencia Abono Banxico", referenciaAbono, "Campo requerido por ser SPID."));
                                filaTieneErrores = true;
                                valoresCelda[13] = "";
                            }
                            if (!tipoOperacionValida) {
                                erroresDeFormato.add(new ErrorData(i + 1, "Tipo Operacion", tipoOperacion, "Campo requerido por ser SPID."));
                                filaTieneErrores = true;
                                valoresCelda[14] = "";
                            }
                        }
                        if (filaTieneErrores) continue;
                        this.dataList.add(new SistemaDispersionData(++consecutivo, valoresCelda[0], valoresCelda[1], valoresCelda[2], valoresCelda[3], valoresCelda[4], valoresCelda[5], valoresCelda[6], valoresCelda[7], valoresCelda[8], valoresCelda[9], valoresCelda[10], valoresCelda[11], valoresCelda[12], valoresCelda[13], valoresCelda[14]));
                    }
                    if (!erroresDeFormato.isEmpty()) {
                        Util.mostrarAlerta("El excel cargado contiene errores, se descargar\u00e1 un excel con los errores");
                        Util.exportarErroresAExcel(erroresDeFormato);
                    }
                    Util.setTablaEditable(this.tableViewDispersionFondos, this.btnAgregarFila, this.btnEliminarFila, false);
                    this.tableViewDispersionFondos.refresh();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        return switch (cell.getCellType()) {
            case CellType.STRING -> cell.getStringCellValue();
            case CellType.NUMERIC -> String.valueOf((int)cell.getNumericCellValue());
            case CellType.BOOLEAN -> String.valueOf(cell.getBooleanCellValue());
            default -> "";
        };
    }

    @FXML
    private void regresar(ActionEvent event) {
        String ruta = "/fxml/DispersionDeFondos/Main/DispersionFondos.fxml";
        String title = "Dispersion de Fondos";
        Service.navegacion(ruta, title, event);
    }
}

