/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.controllers;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.scotiabank.productosGTB.DTO.ReportePDFFooter;
import org.scotiabank.productosGTB.DTO.ReportePDFHeader;
import org.scotiabank.productosGTB.business.Service;
import org.scotiabank.productosGTB.controllers.Codigos;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.LecturaReportesTEF.LecturaReporteTEFDetMailCuenta;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.LecturaReportesTEF.LecturaReporteTEFDetalle;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.LecturaReportesTEF.LecturaReporteTEFHeader;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.LecturaReportesTEF.LecturaReporteTEFTrailerArchivo;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.BloqueSecuencia;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.Bloques;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.DetalleConMail;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.FilaReporteTablaTEF;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.ReporteTEF;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.report.ReporteTEFBloque;
import org.scotiabank.productosGTB.model.reporteResultadosTEF.reportePDF.reportePDF;
import org.scotiabank.productosGTB.services.Mensajes;
import org.scotiabank.productosGTB.services.ReporteService;
import org.scotiabank.productosGTB.util.Constantes;
import org.scotiabank.productosGTB.util.Conversiones;
import org.scotiabank.productosGTB.util.Normalize;
import org.scotiabank.productosGTB.util.Util;
import org.scotiabank.productosGTB.util.UtilPDF;

public class SistemaDispersionFondosLecturaController {
    @FXML
    private Button importarArchivo;
    @FXML
    private TextField tipoArchivo;
    @FXML
    private TextField codigoRegistro;
    @FXML
    private TextField referenciaEmpresa;
    @FXML
    private TextField cuentaCargo;
    @FXML
    private TextField secuenciaArchivo;
    @FXML
    private TextField nombreEmpresa;
    @FXML
    private TextField cantidadMovimientoAceptadosAltas;
    @FXML
    private TextField importeMovimientoAceptadosAltas;
    @FXML
    private TextField cantidadMovimientoAceptadosBajas;
    @FXML
    private TextField importeMovimientoAceptadosBajas;
    @FXML
    private TextField cantidadMovimientoRechazadosAltas;
    @FXML
    private TextField importeMovimientoRechazadosAltas;
    @FXML
    private TextField cantidadMovimientoRechazadosBajas;
    @FXML
    private TextField importeMovimientoRechazadosBajas;
    @FXML
    private TextField cantidadDeMovimeientosPagados;
    @FXML
    private TextField importeDeMovimientosPagados;
    @FXML
    private TextField cantidadDeMovimientosDevueltos;
    @FXML
    private TextField importeDeMovimientosDevueltos;
    @FXML
    private TextField cantidadDeMovimientosRech;
    @FXML
    private TextField importeDeMovimientosRech;
    @FXML
    private Button btnpdf;
    @FXML
    private TextField numeroBajas;
    @FXML
    private TextField importeBajas;
    @FXML
    Button btnreportPDF;
    @FXML
    private TableView<FilaReporteTablaTEF> tableResultadosPagos;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> tipoInstruccion;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> codigoClave;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> statusPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> fechaAplicacionPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> plazaPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> sucursalPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> formaPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> tipoCuenta;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> bancoReceptor;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> cuentaAbono;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> importePago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> claveBeneficiario;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> rfcBeneficiario;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> nombreBeneficiario;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> referenciaPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> conceptoPago;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> diasVigencia;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> campoParaOrdenarInformacion;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> folioUnico;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> referenciaDeAbonoBanxico;
    @FXML
    private TableColumn<FilaReporteTablaTEF, String> tipoDeOperacion;
    public static String rutaArchivoSeleccionado;
    private List<reportePDF> infPDF;
    ReportePDFHeader reportePDFHeader = new ReportePDFHeader();
    ReportePDFFooter reportePDFFooter = new ReportePDFFooter();
    List<FilaReporteTablaTEF> filas;

    @FXML
    public void initialize() {
        this.tipoInstruccion.setCellValueFactory(new PropertyValueFactory("tipoInstruccion"));
        this.codigoClave.setCellValueFactory(new PropertyValueFactory("codigoClave"));
        this.statusPago.setCellValueFactory(new PropertyValueFactory("statusPago"));
        this.fechaAplicacionPago.setCellValueFactory(new PropertyValueFactory("fechaAplicacionPago"));
        this.plazaPago.setCellValueFactory(new PropertyValueFactory("plazaPago"));
        this.sucursalPago.setCellValueFactory(new PropertyValueFactory("sucursalPago"));
        this.formaPago.setCellValueFactory(new PropertyValueFactory("formaPago"));
        this.tipoCuenta.setCellValueFactory(new PropertyValueFactory("tipoCuenta"));
        this.bancoReceptor.setCellValueFactory(new PropertyValueFactory("bancoReceptor"));
        this.cuentaAbono.setCellValueFactory(new PropertyValueFactory("cuentaAbono"));
        this.importePago.setCellValueFactory(new PropertyValueFactory("importePago"));
        this.claveBeneficiario.setCellValueFactory(new PropertyValueFactory("claveBeneficiario"));
        this.rfcBeneficiario.setCellValueFactory(new PropertyValueFactory("rfcBeneficiario"));
        this.nombreBeneficiario.setCellValueFactory(new PropertyValueFactory("nombreBeneficiario"));
        this.referenciaPago.setCellValueFactory(new PropertyValueFactory("referenciaPago"));
        this.conceptoPago.setCellValueFactory(new PropertyValueFactory("conceptoPago"));
        this.diasVigencia.setCellValueFactory(new PropertyValueFactory("diasVigencia"));
        this.campoParaOrdenarInformacion.setCellValueFactory(new PropertyValueFactory("campoParaOrdenarInformacion"));
        this.folioUnico.setCellValueFactory(new PropertyValueFactory("folioUnico"));
        this.referenciaDeAbonoBanxico.setCellValueFactory(new PropertyValueFactory("referenciaDeAbonoBanxico"));
        this.tipoDeOperacion.setCellValueFactory(new PropertyValueFactory("tipoDeOperacion"));
    }

    @FXML
    private void regresar(ActionEvent event) {
        String ruta = "/fxml/DispersionDeFondos/Main/DispersionFondos.fxml";
        String title = "dispersionFondos";
        Service.navegacion(ruta, title, event);
    }

    @FXML
    private void codigos(ActionEvent event) {
        try {
            String ruta = "/fxml/DispersionDeFondos/ResDispersionDeFondos/codigos.fxml";
            String title = "C\u00f3digos";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(ruta));
            Parent root = (Parent)loader.load();
            Codigos codigosController = (Codigos)loader.getController();
            codigosController.setRutaOrigen("/fxml/DispersionDeFondos/ResDispersionDeFondos/dispersionFondosRespuesta.fxml");
            codigosController.setTipoCodigo("dispersionDeFondos");
            Stage nuevaVentana = new Stage();
            nuevaVentana.setTitle(title);
            nuevaVentana.setScene(new Scene(root));
            nuevaVentana.initModality(Modality.APPLICATION_MODAL);
            Stage ventanaActual = (Stage)((Node)event.getSource()).getScene().getWindow();
            nuevaVentana.initOwner(ventanaActual);
            nuevaVentana.showAndWait();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void cargarArchivo() throws IOException {
        ReporteTEF reporteTEF = this.lecturaReportes();
        boolean valido = this.reporteHeader(reporteTEF);
        if (!valido) {
            return;
        }
        List<BloqueSecuencia> bloques = SistemaDispersionFondosLecturaController.armarBloquesConPares(reporteTEF);
        this.llenarTabla(bloques);
        this.reporteFooter(reporteTEF);
        this.infPDF = this.generarObjetoPDF(bloques);
        this.importarArchivo.setDisable(true);
    }

    @FXML
    private void generarPDF() {
        if (!Conversiones.validarEmpresaPagadora(this.nombreEmpresa)) {
            return;
        }
        String empresaPagadora = this.nombreEmpresa.getText().trim();
        rutaArchivoSeleccionado = SistemaDispersionFondosLecturaController.seleccionarDirectorio(this.btnpdf);
        if (rutaArchivoSeleccionado == null) {
            this.mostrarAlerta("No se seleccion\u00f3 ninguna carpeta. Operaci\u00f3n cancelada.");
            return;
        }
        if (this.infPDF != null && !this.infPDF.isEmpty()) {
            this.mostrarAlerta("Generaci\u00f3n de PDF iniciada.");
            new Thread(() -> {
                this.crearPDFreporte(this.infPDF, empresaPagadora);
                Platform.runLater(() -> this.mostrarAlerta("Generaci\u00f3n de PDF finalizada."));
            }).start();
        } else {
            this.generacionPDF("No hay datos para generar el PDF.");
        }
    }

    public static String seleccionarDirectorio(Node nodoReferencia) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Selecciona una carpeta para guardar los archivos");
        Window ventana = nodoReferencia.getScene().getWindow();
        File directorio = directoryChooser.showDialog(ventana);
        if (directorio != null) {
            String ruta = Normalize.parse(directorio.getAbsolutePath());
            String nombreCarpeta = directorio.getName();
            if (!Util.esRutaValida(nombreCarpeta)) {
                Alert alerta = new Alert(Alert.AlertType.ERROR);
                alerta.setTitle("Carpeta inv\u00e1lida");
                alerta.setHeaderText("Nombre de carpeta no permitido");
                alerta.setContentText("Solo se permiten letras, n\u00fameros, espacios, guiones (-) y guiones bajos (_).");
                alerta.showAndWait();
                return null;
            }
            return ruta;
        }
        Alert alerta = new Alert(Alert.AlertType.ERROR);
        alerta.setTitle("Selecci\u00f3n cancelada");
        alerta.setHeaderText("No se seleccion\u00f3 ninguna carpeta");
        alerta.setContentText("Debes seleccionar una carpeta para continuar con el guardado.");
        alerta.showAndWait();
        return null;
    }

    private void mostrarAlerta(String mensaje) {
        Alert alerta = new Alert(Alert.AlertType.INFORMATION);
        alerta.setTitle("Estado del proceso");
        alerta.setHeaderText(null);
        alerta.setContentText(mensaje);
        alerta.showAndWait();
    }

    private void generacionPDF(String mensaje) {
        Alert alerta = new Alert(Alert.AlertType.ERROR);
        alerta.setTitle("Estado del proceso");
        alerta.setHeaderText(null);
        alerta.setContentText(mensaje);
        alerta.showAndWait();
    }

    private void llenarTabla(List<BloqueSecuencia> bloques) {
        this.filas = this.generarObjetosTabla(bloques);
        ObservableList<FilaReporteTablaTEF> data = FXCollections.observableArrayList(this.filas);
        this.tableResultadosPagos.setItems(data);
    }

    public ReporteTEF lecturaReportes() {
        File archivoReporteTXT = SistemaDispersionFondosLecturaController.seleccionarArchivoTXT();
        if (archivoReporteTXT == null || !archivoReporteTXT.exists()) {
            Alert alerta = new Alert(Alert.AlertType.ERROR);
            alerta.setTitle("Error de archivo");
            alerta.setHeaderText("Archivo no v\u00e1lido");
            alerta.setContentText("No se seleccion\u00f3 un archivo o el archivo no existe.");
            alerta.showAndWait();
            return null;
        }
        ReporteTEF reporteTEF = new ReporteTEF();
        ReporteTEFBloque reporteTEFBloque = null;
        Bloques bloques = null;
        ReporteService rp = new ReporteService();
        try (BufferedReader reader = Files.newBufferedReader(archivoReporteTXT.toPath());){
            String linea;
            while ((linea = reader.readLine()) != null) {
                String tipoLinea;
                switch (tipoLinea = this.identificarTipoLinea(linea)) {
                    case "HEADER_FILE": {
                        if (linea.indexOf(32) == 38) {
                            reporteTEF.lecturaReporteTEFHeader = rp.lecturaReporte5PosTEFHeader(linea);
                            break;
                        }
                        reporteTEF.lecturaReporteTEFHeader = rp.lecturaReporte12PosTEFHeader(linea);
                        break;
                    }
                    case "HEADER_BLOQUE": {
                        reporteTEFBloque = new ReporteTEFBloque();
                        reporteTEF.reportesTEFBloques.add(reporteTEFBloque);
                        reporteTEFBloque.lecturaReporteTEFHeaderBloque = rp.lecturaReporteTEFHeaderBloque(linea);
                        break;
                    }
                    case "DETALLE": {
                        bloques = new Bloques();
                        if (reporteTEFBloque == null) break;
                        reporteTEFBloque.bloques.add(bloques);
                        bloques.addDetalle(rp.lecturaReporteTEFDetalle(linea));
                        break;
                    }
                    case "DETALLE_MAIL_CUENTA": {
                        if (bloques == null) break;
                        bloques.addMail(rp.lecturaReporteTEFDetMailCuenta(linea));
                        break;
                    }
                    case "TRAILER_BLOQUE": {
                        if (reporteTEFBloque == null) break;
                        reporteTEFBloque.lecturaReporteTEFTrailerBloque = rp.lecturaReporteTEFTrailerBloque(linea);
                        break;
                    }
                    case "TRAILER_ARCHIVO": {
                        reporteTEF.lecturaReporteTEFTrailerArchivo = rp.lecturaReporteTEFTrailerArchivo(linea);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reporteTEF;
    }

    public static File seleccionarArchivoTXT() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Archivo de Texto", "*.txt"));
        File archivo = fileChooser.showOpenDialog(null);
        return archivo;
    }

    private boolean validarArchivoTXT(File archivo) {
        if (archivo == null) {
            return false;
        }
        if (!archivo.exists()) {
            return false;
        }
        return archivo.isFile();
    }

    private String identificarTipoLinea(String linea) {
        String prefix6;
        String prefix4 = linea.length() >= 4 ? linea.substring(0, 4) : linea;
        String string = prefix6 = linea.length() >= 6 ? linea.substring(0, 6) : linea;
        if (Constantes.HEADER_FILE.contains(prefix4)) {
            return "HEADER_FILE";
        }
        if (Constantes.HEADER_BLOQUE.contains(prefix4)) {
            return "HEADER_BLOQUE";
        }
        if (Constantes.DETALLE_MAIL_CUENTA.contains(prefix4)) {
            return "DETALLE_MAIL_CUENTA";
        }
        if (Constantes.TRAILER_BLOQUE.contains(prefix4)) {
            return "TRAILER_BLOQUE";
        }
        if (Constantes.TRAILER_ARCHIVO.contains(prefix4)) {
            return "TRAILER_ARCHIVO";
        }
        if (Constantes.DETALLE.contains(prefix6)) {
            return "DETALLE";
        }
        return "";
    }

    public static void imprimirReporteTEF(ReporteTEF reporteTEF) {
        if (reporteTEF.getLecturaReporteTEFHeader() != null) {
            // empty if block
        }
        int numBloque = 1;
        for (ReporteTEFBloque bloque : reporteTEF.getReportesTEFBloques()) {
            if (bloque.getLecturaReporteTEFHeaderBloque() != null) {
                // empty if block
            }
            for (Bloques b : bloque.getBloques()) {
                if (b.getDetalles() != null && !b.getDetalles().isEmpty()) {
                    for (LecturaReporteTEFDetalle lecturaReporteTEFDetalle : b.getDetalles()) {
                    }
                }
                if (b.getMails() == null || b.getMails().isEmpty()) continue;
                for (LecturaReporteTEFDetMailCuenta lecturaReporteTEFDetMailCuenta : b.getMails()) {
                }
            }
            if (bloque.getLecturaReporteTEFTrailerBloque() != null) {
                // empty if block
            }
            ++numBloque;
        }
        if (reporteTEF.getLecturaReporteTEFTrailerArchivo() != null) {
            // empty if block
        }
    }

    private String tipoArchivo(String tipoArchivo) {
        String prefix4;
        String string = prefix4 = tipoArchivo.length() >= 2 ? tipoArchivo.substring(0, 2) : tipoArchivo;
        if ("SP".contains(prefix4)) {
            return "DEFINITIVOS";
        }
        if (Constantes.HEADER_BLOQUE.contains(prefix4)) {
            return "HEADER_BLOQUE";
        }
        if (Constantes.DETALLE_MAIL_CUENTA.contains(prefix4)) {
            return "DETALLE_MAIL_CUENTA";
        }
        return "";
    }

    public static String obtenerDescripcionTipoArchivo(String tipoCodigo) {
        if (tipoCodigo == null) {
            return "TIPO DE ARCHIVO DESCONOCIDO";
        }
        switch (tipoCodigo) {
            case "SV": {
                return "PREVIO";
            }
            case "SP": {
                return "DEFINITIVO";
            }
            case "SR": {
                return "RECHAZADO";
            }
        }
        return "DESCONOCIDO";
    }

    public Boolean reporteHeader(ReporteTEF reporteTEF) {
        LecturaReporteTEFHeader header = reporteTEF.getLecturaReporteTEFHeader();
        if (header == null) {
            Mensajes.mostrarAlertaError("Error: tipo de archivo no v\u00e1lido");
            return false;
        }
        if (header == null || reporteTEF == null || reporteTEF.getReportesTEFBloques() == null || reporteTEF.getReportesTEFBloques().isEmpty() || reporteTEF.getReportesTEFBloques().get(0) == null || reporteTEF.getReportesTEFBloques().get(0).getLecturaReporteTEFHeaderBloque() == null || reporteTEF.getReportesTEFBloques().get(0).getLecturaReporteTEFHeaderBloque().getReferecniaEmpresa() == null) {
            Mensajes.mostrarAlertaError("Error: tipo de archivo no v\u00e1lido");
            return false;
        }
        String tipoDeArchivo = SistemaDispersionFondosLecturaController.obtenerDescripcionTipoArchivo(header.getTipoDeArchivo());
        Conversiones conversiones = new Conversiones();
        this.tipoArchivo.setText(tipoDeArchivo);
        this.tipoArchivo.setDisable(true);
        String statusRegistro = Conversiones.limpiarCeros(header.getCodigoStatusRegistro());
        this.codigoRegistro.setText(statusRegistro);
        String ReferenciaEmpresa = reporteTEF.getReportesTEFBloques().get(0).getLecturaReporteTEFHeaderBloque().getReferecniaEmpresa();
        String CuentaCargo = reporteTEF.getReportesTEFBloques().get(0).getLecturaReporteTEFHeaderBloque().getCuentaDeCargo();
        this.codigoRegistro.setDisable(true);
        this.referenciaEmpresa.setText(ReferenciaEmpresa);
        this.referenciaEmpresa.setDisable(true);
        this.cuentaCargo.setText(CuentaCargo);
        this.cuentaCargo.setDisable(true);
        this.secuenciaArchivo.setText(header.getSecuencia());
        this.secuenciaArchivo.setDisable(true);
        this.reportePDFHeader.setTipoArchivo(tipoDeArchivo);
        this.reportePDFHeader.setCodigoRegistro(statusRegistro);
        this.reportePDFHeader.setReferenciaEmpresa(ReferenciaEmpresa);
        this.reportePDFHeader.setCuentaCargo(CuentaCargo);
        this.reportePDFHeader.setSecuenciaDeArchivo(header.getSecuencia());
        return true;
    }

    public void reporteFooter(ReporteTEF reporteTEF) {
        LecturaReporteTEFTrailerArchivo trailerArchivo = reporteTEF.getLecturaReporteTEFTrailerArchivo();
        this.cantidadMovimientoAceptadosAltas.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoAceptadosAltas()));
        this.importeMovimientoAceptadosAltas.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoAceptadosAltas()));
        this.cantidadMovimientoAceptadosBajas.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoAceptadosBajas()));
        this.importeMovimientoAceptadosBajas.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoAceptadosBajas()));
        this.cantidadMovimientoRechazadosAltas.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoRechazadosAltas()));
        this.importeMovimientoRechazadosAltas.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoRechazadosAltas()));
        this.cantidadMovimientoRechazadosBajas.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoRechazadosBajas()));
        this.importeMovimientoRechazadosBajas.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoRechazadosBajas()));
        this.cantidadDeMovimeientosPagados.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimeientosPagados()));
        this.importeDeMovimientosPagados.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteDeMovimientosPagados()));
        this.cantidadDeMovimientosDevueltos.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimientosDevueltos()));
        this.importeDeMovimientosDevueltos.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteDeMovimientosDevueltos()));
        this.cantidadDeMovimientosRech.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimientosRech()));
        this.importeDeMovimientosRech.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteDeMovimientosRech()));
        this.numeroBajas.setText(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimientosBaja()));
        this.importeBajas.setText(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientosBaja()));
        this.reportePDFFooter.setMovimientosAceptadosNumeroAltas(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoAceptadosAltas()));
        this.reportePDFFooter.setMovimientosAceptadosImporteAltas(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoAceptadosAltas()));
        this.reportePDFFooter.setMovimientosAceptadosNumeroBajas(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoAceptadosBajas()));
        this.reportePDFFooter.setMovimientosAceptadosImporteBajas(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoAceptadosBajas()));
        this.reportePDFFooter.setMovimientosRechazadosNumeroAltas(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoRechazadosAltas()));
        this.reportePDFFooter.setMovimientosRechazadosImporteAltas(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoRechazadosAltas()));
        this.reportePDFFooter.setMovimientosRechazadosNumeroBajas(Conversiones.limpiarCeros(trailerArchivo.getCantidadMovimientoRechazadosBajas()));
        this.reportePDFFooter.setMovimientosRechazadosImporteBajas(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientoRechazadosBajas()));
        this.reportePDFFooter.setNumeroPagos(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimeientosPagados()));
        this.reportePDFFooter.setImportePagos(Conversiones.convertirAPesos(trailerArchivo.getImporteDeMovimientosPagados()));
        this.reportePDFFooter.setNumeroDevueltos(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimientosDevueltos()));
        this.reportePDFFooter.setImporteDevueltos(Conversiones.convertirAPesos(trailerArchivo.getImporteDeMovimientosDevueltos()));
        this.reportePDFFooter.setNumeroRechazos(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimientosRech()));
        this.reportePDFFooter.setImporteRechazos(Conversiones.convertirAPesos(trailerArchivo.getImporteDeMovimientosRech()));
        this.reportePDFFooter.setNumeroBaja(Conversiones.limpiarCeros(trailerArchivo.getCantidadDeMovimientosBaja()));
        this.reportePDFFooter.setImpoteBaja(Conversiones.convertirAPesos(trailerArchivo.getImporteMovimientosBaja()));
    }

    public static List<BloqueSecuencia> armarBloquesConPares(ReporteTEF reporteTEF) {
        ArrayList<BloqueSecuencia> resultado = new ArrayList<BloqueSecuencia>();
        for (ReporteTEFBloque bloque : reporteTEF.getReportesTEFBloques()) {
            ArrayList<DetalleConMail> pares = new ArrayList<DetalleConMail>();
            for (Bloques b : bloque.getBloques()) {
                ArrayList<Object> items = new ArrayList<Object>();
                if (b.getDetalles() != null) {
                    items.addAll(b.getDetalles());
                }
                if (b.getMails() != null) {
                    items.addAll(b.getMails());
                }
                for (int i = 0; i < items.size(); ++i) {
                    Object e = items.get(i);
                    if (!(e instanceof LecturaReporteTEFDetalle)) continue;
                    LecturaReporteTEFDetalle d = (LecturaReporteTEFDetalle)e;
                    LecturaReporteTEFDetMailCuenta m = null;
                    if (i + 1 < items.size() && items.get(i + 1) instanceof LecturaReporteTEFDetMailCuenta) {
                        m = (LecturaReporteTEFDetMailCuenta)items.get(i + 1);
                        ++i;
                    }
                    pares.add(new DetalleConMail(0, d, m));
                }
            }
            resultado.add(new BloqueSecuencia(bloque.getLecturaReporteTEFHeaderBloque(), pares, bloque.getLecturaReporteTEFTrailerBloque()));
        }
        return resultado;
    }

    public List<FilaReporteTablaTEF> generarObjetosTabla(List<BloqueSecuencia> bloques) {
        ArrayList<FilaReporteTablaTEF> filas = new ArrayList<FilaReporteTablaTEF>();
        for (BloqueSecuencia b : bloques) {
            for (DetalleConMail par : b.getPares()) {
                LecturaReporteTEFDetalle d = par.getDetalle();
                LecturaReporteTEFDetMailCuenta m = par.getMail();
                String numeroCuentaBeneficiario = Conversiones.obtenerNumeroCuentaBeneficiario(d.getNumeroCuentaBeneficiario(), d.getTipoCuenta());
                FilaReporteTablaTEF fila = new FilaReporteTablaTEF(Conversiones.obtenerDescripcion(d.getTipoRegistro()), Conversiones.limpiarCeros(d.getCodigoStatusRegistro()), Conversiones.validarEstado(d.getCodigoStatusRegistro()), d.getFechaAplicacion(), d.getPlazaDePagoSBI(), d.getSucursalDelPago(), d.getTipoMovimiento(), d.getTipoCuenta(), d.getNumBancoReceptor(), numeroCuentaBeneficiario, Conversiones.convertirAPesos(d.getImporte()), d.getCVEBeneficiario(), d.getRFCBeneficiario(), d.getNombreBeneficiario(), d.getReferenciaDePago(), d.getConceptoPago(), d.getDiasVigencia(), m != null ? m.getMailBeneficiario() : "", d.getFolioUnico(), m != null ? m.getReferenciaDeAbonoBanxico() : "", m != null ? Conversiones.obtenerTipoOperacion(m.getTipoDeOperacion()) : "");
                filas.add(fila);
            }
        }
        return filas;
    }

    public List<reportePDF> generarObjetoPDF(List<BloqueSecuencia> bloques) {
        ArrayList<reportePDF> filas = new ArrayList<reportePDF>();
        for (BloqueSecuencia b : bloques) {
            String cuentaDeCargo = b.getHeader().getCuentaDeCargo();
            for (DetalleConMail par : b.getPares()) {
                LecturaReporteTEFDetalle d = par.getDetalle();
                LecturaReporteTEFDetMailCuenta m = par.getMail();
                reportePDF fila = new reportePDF(Conversiones.ocultarCadena(cuentaDeCargo), Conversiones.ocultarCadena(Conversiones.obtenerNumeroCuentaBeneficiario(d.getNumeroCuentaBeneficiario(), d.getTipoCuenta())), d.getNumBancoReceptor() + "-" + Conversiones.obtenerNombreBanco(d.getNumBancoReceptor()), d.getNombreBeneficiario(), d.getRFCBeneficiario(), d.getConceptoPago(), Conversiones.transformarFecha(d.getFechaAplicacion()), Conversiones.convertirAPesos(d.getImporte()), m != null ? m.getClaveRastreo() : "", d.getReferenciaDePago(), d.getFolioUnico(), d.getNumBancoEmisor() + "-" + Conversiones.obtenerNombreBanco(d.getNumBancoEmisor()), m != null ? m.getMailBeneficiario() : "", Conversiones.limpiarCeros(d.getCodigoStatusRegistro()), d.getTipoMovimiento());
                filas.add(fila);
            }
        }
        return filas;
    }

    public void crearPDFreporte(List<reportePDF> reportePDFInfo, String empresaPagadora) {
        if (reportePDFInfo == null || reportePDFInfo.isEmpty()) {
            return;
        }
        DateTimeFormatter formato = DateTimeFormatter.ofPattern("yyyyMMdd");
        int contador = SistemaDispersionFondosLecturaController.obtenerSiguienteContador(Normalize.parse(rutaArchivoSeleccionado));
        for (reportePDF fila : reportePDFInfo) {
            LocalDateTime ahora = LocalDateTime.now();
            String referencia = Conversiones.cleanFileName(fila.getNombrebeneficiario());
            String nombreArchivo = String.format("Reporte_%s_%03d_%s.pdf", ahora.format(formato), contador, referencia != null && !referencia.isBlank() ? referencia.trim() : " ");
            String destino = Normalize.parse(rutaArchivoSeleccionado + "/" + nombreArchivo);
            try {
                PdfWriter writer = new PdfWriter(destino);
                PdfDocument pdf = new PdfDocument(writer);
                Document document = new Document(pdf, PageSize.A4);
                PdfFont fontBold = PdfFontFactory.createFont("Helvetica-Bold");
                PdfFont fontHeader = PdfFontFactory.createFont("Helvetica-Bold");
                PdfFont fontBody = PdfFontFactory.createFont("Helvetica");
                this.agregarImagen(document, "assets/Scotiabank_header-pdf.png", 450.0f, 20.0f);
                document.add(new Paragraph("\n"));
                Table principal = new Table(new float[]{5.0f, 95.0f});
                principal.setWidth(UnitValue.createPercentValue(100.0f));
                boolean esCorrecto = fila.getCodigoStatusRegistro() == null || fila.getCodigoStatusRegistro().isBlank() || fila.getCodigoStatusRegistro().equals("0");
                String iconoPath = esCorrecto ? "assets/Icono_aceptado.png" : "assets/Icono_error.png";
                String textoBase = UtilPDF.obtenerTextoBase(esCorrecto, fila.getTipoPago());
                String importeTexto = String.valueOf(fila.getImporteDeAbono());
                Text textoCompleto = (Text)new Text(textoBase).setFontSize(16.0f);
                Text importeNegritas = (Text)((Text)new Text(importeTexto).setFont(fontBold)).setFontSize(16.0f);
                Paragraph mensaje = new Paragraph().add(textoCompleto).add(importeNegritas);
                Cell celdaMensaje = (Cell)((Cell)new Cell().add(mensaje).setBorder(Border.NO_BORDER)).setVerticalAlignment(VerticalAlignment.MIDDLE);
                principal.addCell(celdaMensaje);
                try (InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream(iconoPath);){
                    if (imageStream != null) {
                        ImageData imageData = ImageDataFactory.create(imageStream.readAllBytes());
                        Image icono = (Image)new Image(imageData).scaleToFit(25.0f, 25.0f).setHorizontalAlignment(HorizontalAlignment.RIGHT);
                        Cell celdaIcono = (Cell)((Cell)new Cell().add(icono).setBorder(Border.NO_BORDER)).setVerticalAlignment(VerticalAlignment.MIDDLE);
                        principal.addCell(celdaIcono);
                    } else {
                        principal.addCell((Cell)new Cell().add(new Paragraph(" ")).setBorder(Border.NO_BORDER));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    principal.addCell((Cell)new Cell().add(new Paragraph(" ")).setBorder(Border.NO_BORDER));
                }
                document.add(principal);
                LocalDate fecha = LocalDate.now();
                DateTimeFormatter formatos = DateTimeFormatter.ofPattern("dd 'de' MMMM 'de' yyyy", new Locale("es", "ES"));
                String fechaFormateada = fecha.format(formatos);
                document.add((IBlockElement)((Paragraph)((Paragraph)new Paragraph(fechaFormateada).setFontSize(12.0f)).setFontColor(new DeviceRgb(51, 51, 51))).setTextAlignment(TextAlignment.RIGHT));
                document.add((IBlockElement)((Paragraph)new Paragraph("Este comprobante es meramente informativo y su fecha puede ser distinta a la de la transacci\u00f3n " + Conversiones.ObtenerDescripcion(fila.getCodigoStatusRegistro())).setFontSize(10.0f)).setFontColor(new DeviceRgb(51, 51, 51)));
                Table tabla = (Table)((Table)((Table)((Table)((Table)((Table)new Table(UnitValue.createPercentArray(new float[]{4.0f, 6.0f})).setWidth(UnitValue.createPercentValue(95.0f))).setFontSize(12.0f)).setPadding(2.0f)).setMarginTop(5.0f)).setMarginBottom(25.0f)).setHorizontalAlignment(HorizontalAlignment.CENTER);
                if (fila.getCodigoStatusRegistro() != null && !fila.getCodigoStatusRegistro().isBlank() && !fila.getCodigoStatusRegistro().equals("0")) {
                    tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Motivo de rechazo", true));
                    tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(Conversiones.capitalizarPrimeraLetra(Conversiones.ObtenerDescripcionError(fila.getCodigoStatusRegistro())), true));
                }
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Fecha de la transacci\u00f3n", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(Conversiones.formatearFechaPersonalizada(fila.getFechaDeposito()), true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Desde la cuenta", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getCuentaDeCargo(), true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Del banco emisor", false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(Conversiones.formatearBanco(Conversiones.capitalizarPrimeraLetra(fila.getBancoEmisor())), false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("A nombre de la empresa", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(empresaPagadora, true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Para la cuenta", false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getCuentaBeneficiaria(), false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Del banco receptor", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(Conversiones.formatearBanco(fila.getBancoReceptor()), true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("A nombre del beneficiario", false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getNombrebeneficiario(), false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Con RFC", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getRfcBeneficiario(), true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Con correo electr\u00f3nico", false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getCorreoElectronico(), false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Por concepto de pago", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(Conversiones.capitalizarPrimeraLetra(fila.getConcepto()), true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Clave del beneficiario", false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getClaveBeneficiario(), false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Referencia Pago", true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getReferenciaDePago(), true));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaA("Clave de Rastreo", false));
                tabla.addCell(SistemaDispersionFondosLecturaController.celdaB(fila.getFolioUnicoClaveRastreo(), false));
                document.add(tabla);
                document.add(new Paragraph("\n"));
                this.agregarImagen(document, "assets/messageDesclimer.jpg", 510.0f, 42.0f);
                document.add((IBlockElement)((Paragraph)((Paragraph)((Paragraph)new Paragraph("Aviso de confidencialidad").setTextAlignment(TextAlignment.JUSTIFIED)).setFont(fontHeader)).setFontSize(8.0f)).setFontColor(new DeviceRgb(112, 112, 112)));
                document.add((IBlockElement)((Paragraph)((Paragraph)((Paragraph)new Paragraph("Este correo electr\u00f3nico y/o el material adjunto es para uso exclusivo de la persona o entidad a la que expresamente se le ha enviado y puede contener informaci\u00f3n confidencial o material privilegiado. Si usted no es el destinatario leg\u00edtimo del mismo, rep\u00f3rtelo inmediatamente al remitente del correo y b\u00f3rrelo. Cualquier revisi\u00f3n, retransmisi\u00f3n, difusi\u00f3n o cualquier otro uso de este correo por personas o entidades distintas a las del destinatario leg\u00edtimo queda expresamente prohibido. Este correo electr\u00f3nico no pretende ni debe ser considerado como constitutivo de ninguna relaci\u00f3n legal, contractual o de otra \u00edndole similar.").setTextAlignment(TextAlignment.JUSTIFIED)).setFont(fontBody)).setFontSize(8.0f)).setFontColor(new DeviceRgb(112, 112, 112)));
                document.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++contador;
        }
    }

    private static Cell celdaA(String texto, boolean columna) {
        return (Cell)((Cell)((Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setBackgroundColor(columna ? new DeviceRgb(255, 255, 255) : new DeviceRgb(255, 255, 255))).setBorder(Border.NO_BORDER)).setPaddingTop(10.0f)).setFontColor(new DeviceRgb(112, 112, 112))).setTextAlignment(TextAlignment.LEFT);
    }

    private static Cell celdaB(String texto, boolean columna) {
        return (Cell)((Cell)((Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setBackgroundColor(columna ? new DeviceRgb(255, 255, 255) : new DeviceRgb(255, 255, 255))).setBorder(Border.NO_BORDER)).setFontColor(new DeviceRgb(51, 51, 51))).setPaddingTop(10.0f)).setTextAlignment(TextAlignment.LEFT);
    }

    private void agregarImagen(Document document, String ruta, float ancho, float alto) {
        try (InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream(ruta);){
            if (imageStream != null) {
                ImageData imageData = ImageDataFactory.create(imageStream.readAllBytes());
                Image imagen = new Image(imageData).scaleToFit(ancho, alto);
                document.add(imagen);
            } else {
                System.err.println("No se encontr\u00f3 la imagen en la ruta: " + ruta);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int obtenerSiguienteContador(String ruta) {
        File carpeta = new File(ruta);
        String[] archivos = carpeta.list((dir, name) -> name.startsWith("Reporte_") && name.endsWith(".pdf"));
        return archivos != null ? archivos.length + 1 : 1;
    }

    private static String limpiarParaArchivo(String valor) {
        if (valor == null) {
            return null;
        }
        return valor.replaceAll("[\\\\/:*?\"<>|\\s]+", "_");
    }

    @FXML
    private void generarReportePDF() {
        if (!Conversiones.validarEmpresaPagadora(this.nombreEmpresa)) {
            return;
        }
        String empresaPagadora = this.nombreEmpresa.getText().trim();
        rutaArchivoSeleccionado = SistemaDispersionFondosLecturaController.seleccionarDirectorio(this.btnreportPDF);
        if (rutaArchivoSeleccionado == null) {
            this.mostrarAlerta("No se seleccion\u00f3 ninguna carpeta. Operaci\u00f3n cancelada.");
            return;
        }
        if (!rutaArchivoSeleccionado.endsWith("\\") && !rutaArchivoSeleccionado.endsWith("/")) {
            rutaArchivoSeleccionado = rutaArchivoSeleccionado + File.separator;
        }
        String fechaActual = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String horaActual = LocalTime.now().format(DateTimeFormatter.ofPattern("HH_mm"));
        String nombreArchivo = "reporte_" + empresaPagadora + "_" + fechaActual + "-" + horaActual + UtilPDF.extencion;
        String rutaCompleta = Normalize.parse(rutaArchivoSeleccionado + nombreArchivo);
        try {
            File carpetaDestino = new File(rutaArchivoSeleccionado);
            if (!carpetaDestino.exists()) {
                carpetaDestino.mkdirs();
            }
            PdfWriter writer = new PdfWriter(rutaCompleta);
            PdfDocument pdf = new PdfDocument(writer);
            Document reporte = new Document(pdf, PageSize.A4.rotate());
            SistemaDispersionFondosLecturaController.agregarEncabezado(reporte, this.reportePDFHeader.getTipoArchivo(), this.reportePDFHeader.getReferenciaEmpresa(), empresaPagadora, this.reportePDFHeader.getCodigoRegistro(), this.reportePDFHeader.getCuentaCargo(), this.reportePDFHeader.getSecuenciaDeArchivo());
            reporte.add((IBlockElement)new Paragraph("").setMarginTop(10.0f));
            this.reportePDFTabla(reporte, this.filas);
            reporte.add((IBlockElement)new Paragraph("").setMarginTop(10.0f));
            this.agregarFooter(this.reportePDFFooter, reporte);
            reporte.close();
            File archivoGenerado = new File(rutaCompleta);
            if (archivoGenerado.exists() && archivoGenerado.length() > 0L) {
                this.mostrarAlerta("PDF generado correctamente en:\n" + rutaCompleta);
            } else {
                this.mostrarAlerta("Hubo un problema al generar el PDF. El archivo est\u00e1 vac\u00edo o no se cre\u00f3.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mostrarAlerta("Error al generar el PDF:\n" + e.getMessage());
        }
    }

    public static void agregarEncabezado(Document doc, String tipoArchivo, String referenciaEmpresa, String nombreDeEmpresa, String codigoRegistro, String cuentaCargo, String secuenciaArchivo) {
        float[] columnWidths = new float[]{1.0f, 1.0f, 1.0f};
        Table tabla = new Table(UnitValue.createPercentArray(columnWidths)).useAllAvailableWidth();
        tabla.addCell(SistemaDispersionFondosLecturaController.celda("Tipo Archivo: " + tipoArchivo, TextAlignment.LEFT));
        tabla.addCell(SistemaDispersionFondosLecturaController.celda("Referencia de empresa: " + referenciaEmpresa, TextAlignment.CENTER));
        tabla.addCell(SistemaDispersionFondosLecturaController.celda("Nombre de empresa: " + nombreDeEmpresa, TextAlignment.RIGHT));
        tabla.addCell(SistemaDispersionFondosLecturaController.celda("C\u00f3digo de registro: " + codigoRegistro, TextAlignment.LEFT));
        tabla.addCell(SistemaDispersionFondosLecturaController.celda("Cuenta cargos: " + cuentaCargo, TextAlignment.CENTER));
        tabla.addCell(SistemaDispersionFondosLecturaController.celda("Secuencia Archivo: " + secuenciaArchivo, TextAlignment.RIGHT));
        doc.add(tabla);
    }

    private static Cell celda(String texto, TextAlignment alineacion) {
        return (Cell)((Cell)((Cell)((Cell)((Cell)new Cell().add((IBlockElement)new Paragraph(texto).setFontSize(10.0f)).setTextAlignment(alineacion)).setVerticalAlignment(VerticalAlignment.MIDDLE)).setBorder(Border.NO_BORDER)).setPadding(0.0f)).setMargin(0.0f);
    }

    public void reportePDFTabla(Document doc, List<FilaReporteTablaTEF> registros) throws IOException {
        PdfFont fontRegular = PdfFontFactory.createFont("Helvetica");
        PdfFont fontBold = PdfFontFactory.createFont("Helvetica-Bold");
        float fontSize = 4.5f;
        float[] columnWidths = new float[21];
        for (int i = 0; i < columnWidths.length; ++i) {
            columnWidths[i] = 1.0f;
        }
        Table tabla = new Table(UnitValue.createPercentArray(columnWidths)).useAllAvailableWidth();
        List<String> encabezados = UtilPDF.encabezados();
        for (String titulo : encabezados) {
            tabla.addHeaderCell((Cell)((Cell)((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(titulo).setFont(fontBold)).setFontSize(fontSize)).setBackgroundColor(ColorConstants.LIGHT_GRAY)).setTextAlignment(TextAlignment.CENTER)).setVerticalAlignment(VerticalAlignment.MIDDLE)).setPadding(2.0f));
        }
        for (FilaReporteTablaTEF fila : registros) {
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getTipoInstruccion()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getCodigoClave()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getStatusPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getFechaAplicacionPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getPlazaPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getSucursalPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getFormaPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getTipoCuenta()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getBancoReceptor()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getCuentaAbono()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getImportePago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getClaveBeneficiario()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getRfcBeneficiario()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getNombreBeneficiario()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getReferenciaPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getConceptoPago()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getDiasVigencia()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getCampoParaOrdenarInformacion()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getFolioUnico()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getReferenciaDeAbonoBanxico()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
            tabla.addCell((Cell)((Cell)new Cell().add((IBlockElement)((Paragraph)new Paragraph(fila.getTipoDeOperacion()).setFont(fontRegular)).setFontSize(fontSize)).setPadding(2.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE));
        }
        doc.add(tabla);
    }

    public void agregarFooter(ReportePDFFooter reportePDFFooter, Document doc) {
        Table tablaIzquierda = new Table(1).useAllAvailableWidth();
        tablaIzquierda.addHeaderCell(SistemaDispersionFondosLecturaController.encabezadoIzquierda("Movimientos aceptados en validaci\u00f3n"));
        tablaIzquierda.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de altas: " + reportePDFFooter.getMovimientosAceptadosNumeroAltas(), TextAlignment.LEFT));
        tablaIzquierda.addCell(SistemaDispersionFondosLecturaController.celda("Importe de altas: " + reportePDFFooter.getMovimientosAceptadosImporteAltas(), TextAlignment.LEFT));
        tablaIzquierda.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de bajas: " + reportePDFFooter.getMovimientosAceptadosNumeroBajas(), TextAlignment.LEFT));
        tablaIzquierda.addCell(SistemaDispersionFondosLecturaController.celda("Importe de bajas: " + reportePDFFooter.getMovimientosAceptadosImporteBajas(), TextAlignment.LEFT));
        Table tablaDerecha = new Table(1).useAllAvailableWidth();
        tablaDerecha.addHeaderCell(SistemaDispersionFondosLecturaController.encabezadoDerecha("Movimientos rechazados en validaci\u00f3n"));
        tablaDerecha.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de altas rechazadas: " + reportePDFFooter.getMovimientosRechazadosNumeroAltas(), TextAlignment.RIGHT));
        tablaDerecha.addCell(SistemaDispersionFondosLecturaController.celda("Importe de altas rechazadas: " + reportePDFFooter.getMovimientosRechazadosImporteAltas(), TextAlignment.RIGHT));
        tablaDerecha.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de bajas rechazadas: " + reportePDFFooter.getMovimientosRechazadosNumeroBajas(), TextAlignment.RIGHT));
        tablaDerecha.addCell(SistemaDispersionFondosLecturaController.celda("Importe de bajas rechazadas: " + reportePDFFooter.getMovimientosRechazadosImporteBajas(), TextAlignment.RIGHT));
        Table tablaPrincipal = (Table)new Table(new float[]{1.0f, 1.0f}).setWidth(UnitValue.createPercentValue(100.0f));
        tablaPrincipal.addCell((Cell)new Cell().add(tablaIzquierda).setBorder(Border.NO_BORDER));
        tablaPrincipal.addCell((Cell)new Cell().add(tablaDerecha).setBorder(Border.NO_BORDER));
        doc.add(tablaPrincipal);
        doc.add((IBlockElement)new Paragraph(" ").setMarginBottom(25.0f));
        Table tablaIzquierda_1 = new Table(1).useAllAvailableWidth();
        tablaIzquierda_1.addHeaderCell(SistemaDispersionFondosLecturaController.encabezadoIzquierda("Movimientos Pagados"));
        tablaIzquierda_1.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de pagos: " + reportePDFFooter.getNumeroPagos(), TextAlignment.LEFT));
        tablaIzquierda_1.addCell(SistemaDispersionFondosLecturaController.celda("Importe de pagos: " + reportePDFFooter.getImportePagos(), TextAlignment.LEFT));
        Table tablaDerecha_1 = new Table(1).useAllAvailableWidth();
        tablaDerecha_1.addHeaderCell(SistemaDispersionFondosLecturaController.encabezadoDerecha("Movimientos de baja"));
        tablaDerecha_1.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de bajas: " + reportePDFFooter.getNumeroBaja(), TextAlignment.RIGHT));
        tablaDerecha_1.addCell(SistemaDispersionFondosLecturaController.celda("Importe de bajas: " + reportePDFFooter.getImpoteBaja(), TextAlignment.RIGHT));
        Table tablaPrincipal_1 = (Table)new Table(new float[]{1.0f, 1.0f}).setWidth(UnitValue.createPercentValue(100.0f));
        tablaPrincipal_1.addCell((Cell)new Cell().add(tablaIzquierda_1).setBorder(Border.NO_BORDER));
        tablaPrincipal_1.addCell((Cell)new Cell().add(tablaDerecha_1).setBorder(Border.NO_BORDER));
        doc.add(tablaPrincipal_1);
        doc.add((IBlockElement)new Paragraph(" ").setMarginBottom(25.0f));
        Table tablaIzquierda_2 = new Table(1).useAllAvailableWidth();
        tablaIzquierda_2.addHeaderCell(SistemaDispersionFondosLecturaController.encabezadoCenter("Movimientos devueltos"));
        tablaIzquierda_2.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de devueltos: " + reportePDFFooter.getNumeroDevueltos(), TextAlignment.LEFT));
        tablaIzquierda_2.addCell(SistemaDispersionFondosLecturaController.celda("Importe de devueltos: " + reportePDFFooter.getImporteDevueltos(), TextAlignment.LEFT));
        Table tablaDerecha_2 = new Table(1).useAllAvailableWidth();
        tablaDerecha_2.addHeaderCell(SistemaDispersionFondosLecturaController.encabezadoDerecha("Movimientos rechazados en aplicaci\u00f3n"));
        tablaDerecha_2.addCell(SistemaDispersionFondosLecturaController.celda("N\u00famero de rechazos: " + reportePDFFooter.getNumeroRechazos(), TextAlignment.RIGHT));
        tablaDerecha_2.addCell(SistemaDispersionFondosLecturaController.celda("Importe de rechazos: " + reportePDFFooter.getImporteRechazos(), TextAlignment.RIGHT));
        Table tablaPrincipal_2 = (Table)new Table(new float[]{1.0f, 1.0f}).setWidth(UnitValue.createPercentValue(100.0f));
        tablaPrincipal_2.addCell((Cell)new Cell().add(tablaIzquierda_2).setBorder(Border.NO_BORDER));
        tablaPrincipal_2.addCell((Cell)new Cell().add(tablaDerecha_2).setBorder(Border.NO_BORDER));
        doc.add(tablaPrincipal_2);
    }

    private static Cell encabezadoCenter(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setTextAlignment(TextAlignment.CENTER)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
    }

    private static Cell encabezadoDerecha(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setTextAlignment(TextAlignment.RIGHT)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
    }

    private static Cell encabezadoIzquierda(String texto) {
        return (Cell)((Cell)((Cell)new Cell().add(new Paragraph(texto)).setTextAlignment(TextAlignment.LEFT)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
    }
}

