/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.services;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.LecturaReportes.PreregistroCuentasDetalle;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.LecturaReportes.PreregistroCuentasHeader;
import org.scotiabank.productosGTB.model.ReportePreregistroCuentas.LecturaReportes.PreregistroCuentrasTrailerBloque;
import org.scotiabank.productosGTB.util.Constantes;
import org.scotiabank.productosGTB.util.Conversiones;

public class ReportePreregistroCuentasService {
    public PreregistroCuentasHeader lecturaReporteHeader12posiciones(String linea) {
        if (linea == null) {
            throw new IllegalArgumentException("La l\u00ednea es inv\u00e1lida o demasiado corta.");
        }
        if (linea.length() < 370) {
            int espaciosFaltantes = 370 - linea.length();
            StringBuilder sb = new StringBuilder(linea);
            for (int i = 0; i < espaciosFaltantes; ++i) {
                sb.append(' ');
            }
            linea = sb.toString();
        }
        PreregistroCuentasHeader lecturaReporteTEFHeader = new PreregistroCuentasHeader();
        lecturaReporteTEFHeader.setTipoDeArchivo(linea.substring(0, 2));
        lecturaReporteTEFHeader.setTipoDeRegistro(linea.substring(2, 4));
        lecturaReporteTEFHeader.setSistemaCentral(linea.substring(4, 7));
        lecturaReporteTEFHeader.setNumeroDeContrato(linea.substring(7, 19));
        lecturaReporteTEFHeader.setFechaSolicitud(linea.substring(19, 27));
        lecturaReporteTEFHeader.setSecuencia(Conversiones.numeroArchivoDia(linea.substring(27, 30)));
        lecturaReporteTEFHeader.setMantenimientoOConsulta(linea.substring(30, 31));
        lecturaReporteTEFHeader.setFechaGeneracionArchivo(linea.substring(31, 39));
        lecturaReporteTEFHeader.setHoraGeneracionArchivo(linea.substring(39, 45));
        lecturaReporteTEFHeader.setCodigoRespuesta(linea.substring(45, 48));
        lecturaReporteTEFHeader.setFiller(linea.substring(48, 145));
        return lecturaReporteTEFHeader;
    }

    public PreregistroCuentasHeader lecturaReporteHeader5posiciones(String linea) {
        if (linea == null) {
            throw new IllegalArgumentException("La l\u00ednea es inv\u00e1lida o demasiado corta.");
        }
        if (linea.length() < 140) {
            int espaciosFaltantes = 140 - linea.length();
            StringBuilder sb = new StringBuilder(linea);
            for (int i = 0; i < espaciosFaltantes; ++i) {
                sb.append(' ');
            }
            linea = sb.toString();
        }
        PreregistroCuentasHeader lecturaReporteTEFHeader = new PreregistroCuentasHeader();
        lecturaReporteTEFHeader.setTipoDeArchivo(linea.substring(0, 2));
        lecturaReporteTEFHeader.setTipoDeRegistro(linea.substring(2, 4));
        lecturaReporteTEFHeader.setSistemaCentral(linea.substring(4, 7));
        lecturaReporteTEFHeader.setNumeroDeContrato(linea.substring(7, 14));
        lecturaReporteTEFHeader.setFechaSolicitud(linea.substring(14, 22));
        lecturaReporteTEFHeader.setSecuencia(Conversiones.numeroArchivoDia(linea.substring(22, 25)));
        lecturaReporteTEFHeader.setMantenimientoOConsulta(linea.substring(25, 26));
        lecturaReporteTEFHeader.setFechaGeneracionArchivo(linea.substring(26, 34));
        lecturaReporteTEFHeader.setHoraGeneracionArchivo(linea.substring(34, 40));
        lecturaReporteTEFHeader.setCodigoRespuesta(linea.substring(40, 43));
        lecturaReporteTEFHeader.setFiller(linea.substring(43, 140));
        return lecturaReporteTEFHeader;
    }

    public PreregistroCuentasDetalle lecturaReporteDetalle(String linea) {
        if (linea == null) {
            throw new IllegalArgumentException("La l\u00ednea es inv\u00e1lida o demasiado corta.");
        }
        if (linea.length() < 140) {
            int espaciosFaltantes = 140 - linea.length();
            StringBuilder sb = new StringBuilder(linea);
            for (int i = 0; i < espaciosFaltantes; ++i) {
                sb.append(' ');
            }
            linea = sb.toString();
        }
        PreregistroCuentasDetalle lecturaReporteDetalle = new PreregistroCuentasDetalle();
        lecturaReporteDetalle.setTipoDeArchivo(linea.substring(0, 2));
        lecturaReporteDetalle.setTipoDeRegistro(linea.substring(2, 4));
        lecturaReporteDetalle.setCveMovimientoCuenta(linea.substring(4, 5));
        lecturaReporteDetalle.setCveTipoCuenta(linea.substring(5, 7));
        String monedacuentas = linea.substring(7, 9);
        String monedacuenta = Constantes.TIPOMONEDA.getOrDefault(monedacuentas, "Desconocido");
        lecturaReporteDetalle.setCveMonedaCuenta(monedacuenta);
        lecturaReporteDetalle.setNumBancoCuenta(linea.substring(9, 12));
        String numeroCuenta = Conversiones.obtenerNumeroCuentaAbono(linea.substring(12, 32), lecturaReporteDetalle.getCveTipoCuenta());
        lecturaReporteDetalle.setNumCuenta(numeroCuenta);
        lecturaReporteDetalle.setFechaEliminacion(linea.substring(32, 40));
        lecturaReporteDetalle.setDescripcion(linea.substring(40, 90));
        String limiteRaw = linea.substring(90, 107).trim();
        BigDecimal limiteDecimal = new BigDecimal(limiteRaw).movePointLeft(2);
        DecimalFormat formato = new DecimalFormat("#,##0.00");
        String limiteFormateado = formato.format(limiteDecimal);
        lecturaReporteDetalle.setLimitePorTransaccion(limiteFormateado);
        String tipoPagos = linea.substring(107, 109);
        String tipoPago = Constantes.TIPOPAGO.getOrDefault(tipoPagos, "Desconocido");
        lecturaReporteDetalle.setTipoDePago(tipoPago);
        lecturaReporteDetalle.setCodigoRespuesta(linea.substring(109, 112));
        lecturaReporteDetalle.setFiller(linea.substring(112, 140));
        return lecturaReporteDetalle;
    }

    public PreregistroCuentrasTrailerBloque lecturaReporteTrailerBloque(String linea) {
        if (linea == null) {
            throw new IllegalArgumentException("La l\u00ednea es inv\u00e1lida o demasiado corta.");
        }
        if (linea.length() < 140) {
            int espaciosFaltantes = 140 - linea.length();
            StringBuilder sb = new StringBuilder(linea);
            for (int i = 0; i < espaciosFaltantes; ++i) {
                sb.append(' ');
            }
            linea = sb.toString();
        }
        PreregistroCuentrasTrailerBloque lecturaReporteTrailerBloque = new PreregistroCuentrasTrailerBloque();
        lecturaReporteTrailerBloque.setTipoDeArchivo(linea.substring(0, 2));
        lecturaReporteTrailerBloque.setTipoDeRegistro(linea.substring(2, 4));
        lecturaReporteTrailerBloque.setCantidadMovimientosSolicitadosAltas(linea.substring(4, 12));
        lecturaReporteTrailerBloque.setCantidadMovimientosSolicitadosCambios(linea.substring(12, 20));
        lecturaReporteTrailerBloque.setCantidadMovimientosSolicitadosBajas(linea.substring(20, 28));
        lecturaReporteTrailerBloque.setCantidadDeConsultasMovimientosSolicitados(linea.substring(28, 36));
        lecturaReporteTrailerBloque.setCantidadMovimientosAceptadosAltas(linea.substring(36, 44));
        lecturaReporteTrailerBloque.setCantidadMovimientosAceptadosCambios(linea.substring(44, 52));
        lecturaReporteTrailerBloque.setCantidadMovimientosAceptadosBajas(linea.substring(52, 60));
        lecturaReporteTrailerBloque.setCantidadDeConsultasMovimientosAceptados(linea.substring(60, 68));
        lecturaReporteTrailerBloque.setCantidadMovimientosRechazadosAltas(linea.substring(68, 76));
        lecturaReporteTrailerBloque.setCantidadMovimientosRechazadosCambios(linea.substring(76, 84));
        lecturaReporteTrailerBloque.setCantidadMovimientosRechazadosBajas(linea.substring(84, 92));
        lecturaReporteTrailerBloque.setCantidadDeConsultasMovimientosRechazados(linea.substring(92, 100));
        lecturaReporteTrailerBloque.setCodigoRespuesta(linea.substring(100, 103));
        lecturaReporteTrailerBloque.setCodigoRespuestaArchivo(linea.substring(103, 106));
        lecturaReporteTrailerBloque.setFiller(linea.substring(106, 140));
        return lecturaReporteTrailerBloque;
    }
}

