/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import javafx.scene.control.Alert;
import javafx.scene.control.TextField;
import org.scotiabank.productosGTB.util.BancoConstantes;

public class Conversiones {
    public static String limpiarCeros(String input) {
        try {
            int numero = Integer.parseInt(String.valueOf(input));
            return String.valueOf(numero);
        }
        catch (NumberFormatException e) {
            return "0";
        }
    }

    public static String convertirAPesos(String cantidad) {
        long longValue;
        if (cantidad == null || cantidad.trim().isEmpty()) {
            return "$0.00";
        }
        try {
            longValue = Long.parseLong(cantidad);
        }
        catch (NumberFormatException e) {
            System.out.println("Error en la cadena no es un n\u00famero valido: " + cantidad);
            return "$0.00";
        }
        double amount = (double)longValue / 100.0;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setCurrencySymbol("$");
        DecimalFormat format = new DecimalFormat("\u00a4#,##0.00", symbols);
        return format.format(amount);
    }

    public static String validarTipoCuenta(String numeroCuenta) {
        if (numeroCuenta == null) {
            return "";
        }
        int longitud = numeroCuenta.length();
        switch (longitud) {
            case 11: {
                return "1";
            }
            case 16: {
                return "3";
            }
            case 18: {
                return "9";
            }
        }
        return "";
    }

    public static String obtenerNumeroCuentaBeneficiario(String cuentaOriginal, String tipoCuenta) {
        int longitud;
        if (cuentaOriginal == null || cuentaOriginal.trim().isEmpty()) {
            return "";
        }
        if (tipoCuenta == null || tipoCuenta.trim().isEmpty()) {
            return "";
        }
        switch (tipoCuenta.trim()) {
            case "1": {
                longitud = 11;
                break;
            }
            case "3": {
                longitud = 16;
                break;
            }
            case "9": {
                longitud = 18;
                break;
            }
            default: {
                return "";
            }
        }
        if (cuentaOriginal.length() < longitud) {
            return "";
        }
        return cuentaOriginal.substring(cuentaOriginal.length() - longitud);
    }

    public static String obtenerNumeroCuentaAbono(String cuentaOriginal, String tipoCuenta) {
        int longitud;
        if (cuentaOriginal == null || cuentaOriginal.trim().isEmpty()) {
            return "";
        }
        if (tipoCuenta == null || tipoCuenta.trim().isEmpty()) {
            return "";
        }
        switch (tipoCuenta.trim()) {
            case "01": {
                longitud = 11;
                break;
            }
            case "02": {
                longitud = 11;
                break;
            }
            case "03": {
                longitud = 16;
                break;
            }
            case "09": {
                longitud = 18;
                break;
            }
            default: {
                return "Tipo cuenta no valido";
            }
        }
        if (cuentaOriginal.length() < longitud) {
            return "";
        }
        return cuentaOriginal.substring(cuentaOriginal.length() - longitud);
    }

    public static String transformarFecha(String fechaOriginal) {
        DateTimeFormatter entrada = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter salida = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        LocalDate fecha = LocalDate.parse(fechaOriginal, entrada);
        return fecha.format(salida);
    }

    public static String obtenerNombreBanco(String claveBanco) {
        return BancoConstantes.SPEI_BANKS.getOrDefault(claveBanco, "Banco desconocido");
    }

    public static boolean validarEmpresaPagadora(TextField nombreEmpresa) {
        String texto = nombreEmpresa.getText().trim();
        if (texto.length() < 2) {
            Alert alerta = new Alert(Alert.AlertType.WARNING);
            alerta.setTitle("Validaci\u00f3n");
            alerta.setHeaderText(null);
            alerta.setContentText("El campo 'Empresa Pagadora' debe tener al menos dos caracteres.");
            alerta.showAndWait();
            return false;
        }
        return true;
    }

    public static String ocultarCadena(String entrada) {
        if (entrada == null) {
            return "";
        }
        if ((entrada = entrada.trim()).isEmpty()) {
            return "";
        }
        if (entrada.length() <= 4) {
            return entrada;
        }
        String ultimos5 = entrada.length() >= 5 ? entrada.substring(entrada.length() - 5) : entrada;
        return "*" + ultimos5.substring(1);
    }

    public static String obtenerDescripcion(String codigo) {
        if (codigo == null) {
            return "C\u00d3DIGO INV\u00c1LIDO";
        }
        switch (codigo) {
            case "DA": {
                return "ALTA";
            }
            case "DB": {
                return "BAJA";
            }
            case "DR": {
                return "DETALLE RECHAZO";
            }
            case "RB": {
                return "BAJA RECHAZADA";
            }
            case "DP": {
                return "DETALLE PAGO";
            }
            case "DD": {
                return "DETALLE DEVOLUCION";
            }
            case "DM": {
                return "DETALLE DE MAIL - CUENTA";
            }
        }
        return "DESCONOCIDO";
    }

    public static String validarEstado(String valor) {
        try {
            int numero = Integer.parseInt(valor.trim());
            return numero == 0 ? "ACEPTADO" : "RECHAZADO";
        }
        catch (NumberFormatException e) {
            return "VALOR INV\u00c1LIDO";
        }
    }

    public static String ObtenerDescripcionError(String codigoStatusRegistro) {
        return BancoConstantes.CODIGOS_ERROR.getOrDefault(codigoStatusRegistro, "Error desconocido");
    }

    public static String ObtenerDescripcion(String codigoStatusRegistro) {
        return codigoStatusRegistro.equals("0") ? "exitosa" : "rechazada";
    }

    public static String conversionFechaDia(LocalDate fechadia) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        return fechadia.format(formatter);
    }

    public static String obtenerTipoOperacion(String codigo) {
        if (codigo == null) {
            return "C\u00d3DIGO INV\u00c1LIDO";
        }
        switch (codigo) {
            case "01": {
                return "Liquidaci\u00f3n de operaci\u00f3n con valores";
            }
            case "02": {
                return "Liquidaci\u00f3n de operaci\u00f3n derivada";
            }
            case "03": {
                return "Liquidaci\u00f3n de operaci\u00f3n cambiara";
            }
            case "04": {
                return "Pago de servicios";
            }
            case "05": {
                return "Pago de bienes";
            }
            case "06": {
                return "Otorgamiento de pr\u00e9stamo";
            }
            case "07": {
                return "Pago de pr\u00e9stamo ";
            }
            case "08": {
                return "otro";
            }
        }
        return " ";
    }

    public static String numeroArchivoDia(String linea) {
        return linea.substring(1);
    }

    public static String capitalizarPrimeraLetra(String texto) {
        if (texto == null || texto.isBlank()) {
            return "";
        }
        texto = texto.trim().toLowerCase();
        return texto.substring(0, 1).toUpperCase() + texto.substring(1);
    }

    public static String formatearFechaPersonalizada(String fechaOriginal) {
        if (fechaOriginal == null || fechaOriginal.isBlank()) {
            return "";
        }
        try {
            SimpleDateFormat formatoEntrada = new SimpleDateFormat("dd/MM/yyyy");
            Date fecha = formatoEntrada.parse(fechaOriginal.trim());
            SimpleDateFormat formatoSalida = new SimpleDateFormat("d 'de' MMMM 'del' yyyy", new Locale("es", "ES"));
            return formatoSalida.format(fecha);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String formatearBanco(String banco) {
        if (banco == null || banco.isBlank()) {
            return "";
        }
        String[] partes = banco.trim().split("-", 2);
        if (partes.length < 2) {
            return banco.trim();
        }
        String codigo = partes[0].trim();
        String nombre = partes[1].trim().toLowerCase();
        String nombreFormateado = nombre.substring(0, 1).toUpperCase() + nombre.substring(1);
        return codigo + " - " + nombreFormateado;
    }

    public static String cleanFileName(String texto) {
        if (texto == null || texto.isBlank()) {
            return "";
        }
        texto = texto.replace("\u00f1", "n").replace("\u00d1", "N");
        texto = Normalizer.normalize(texto, Normalizer.Form.NFD);
        texto = texto.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        texto = texto.replace("\u00fc", "u").replace("\u00dc", "U");
        texto = texto.replaceAll("[\\\\/:*?\"<>|&#;]", "");
        texto = texto.trim().replaceAll("\\s+", "_");
        texto = texto.replaceAll("_+$", "");
        return texto;
    }
}

