/*
 * Decompiled with CFR 0.152.
 */
package org.scotiabank.productosGTB.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.scotiabank.productosGTB.data.ErrorData;
import org.scotiabank.productosGTB.model.PreRegistroCuentasData;

public class Util {
    static boolean mostroAlerta = false;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> createNumericCellFactory(final int minLength, final int maxLength) {
        return column -> new TableCell<S, String>(){
            private TextField textField;

            @Override
            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    if (this.textField == null) {
                        this.createTextField(minLength, maxLength);
                    }
                    this.textField.setText(this.getString());
                    this.setGraphic(this.textField);
                    this.setText(null);
                    this.textField.selectAll();
                    this.textField.requestFocus();
                }
            }

            @Override
            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getString());
                this.setGraphic(null);
            }

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.trim().isEmpty()) {
                    this.setText(null);
                    this.setGraphic(null);
                    if (!this.getStyleClass().contains("error-cell")) {
                        this.getStyleClass().add("error-cell");
                    }
                } else {
                    this.getStyleClass().remove("error-cell");
                    if (this.isEditing()) {
                        if (this.textField != null) {
                            this.textField.setText(this.getString());
                        }
                        this.setGraphic(this.textField);
                        this.setText(null);
                    } else {
                        this.setText(this.getString());
                        this.setGraphic(null);
                    }
                }
            }

            private void createTextField(int minLength2, int maxLength2) {
                this.textField = new TextField();
                UnaryOperator filter = change -> {
                    String newText = change.getControlNewText();
                    if (!newText.matches("\\d*")) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("No se permiten caracteres especiales y/o letras.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    if (newText.length() > maxLength2) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("La longitud m\u00e1xima permitida es de " + maxLength2 + " d\u00edgitos.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    return change;
                };
                this.textField.setTextFormatter(new TextFormatter(filter));
                this.textField.setOnAction(event -> this.commitEdit(this.textField.getText()));
                this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                    if (!isNowFocused.booleanValue()) {
                        Platform.runLater(() -> {
                            String value = this.textField.getText();
                            if (value.length() < minLength2) {
                                if (!value.isEmpty()) {
                                    Util.mostrarAlerta("La longitud m\u00ednima requerida es de " + minLength2 + " d\u00edgitos.");
                                }
                                this.cancelEdit();
                            } else {
                                this.commitEdit(value);
                            }
                        });
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
                    if (event.getCode() == KeyCode.TAB) {
                        int nextColumnIndex;
                        String value = this.textField.getText();
                        if (value.length() >= minLength2 && value.length() <= maxLength2) {
                            this.commitEdit(value);
                        }
                        TableView tableView = this.getTableView();
                        ObservableList visibleColumns = tableView.getVisibleLeafColumns();
                        int currentColumnIndex = visibleColumns.indexOf(this.getTableColumn());
                        int nextRowIndex = this.getIndex();
                        if (event.isShiftDown()) {
                            nextColumnIndex = currentColumnIndex - 1;
                            if (nextColumnIndex < 0) {
                                nextColumnIndex = visibleColumns.size() - 1;
                                --nextRowIndex;
                            }
                        } else {
                            nextColumnIndex = currentColumnIndex + 1;
                            if (nextColumnIndex >= visibleColumns.size()) {
                                nextColumnIndex = 0;
                                ++nextRowIndex;
                            }
                        }
                        if (nextRowIndex >= 0 && nextRowIndex < tableView.getItems().size()) {
                            TableColumn nextColumn = (TableColumn)visibleColumns.get(nextColumnIndex);
                            tableView.edit(nextRowIndex, nextColumn);
                        }
                        event.consume();
                    } else if (event.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        event.consume();
                    }
                });
            }

            private String getString() {
                return this.getItem() == null ? "" : ((String)this.getItem()).toString();
            }
        };
    }

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> createDecimalCellFactory(final int minLength, final int maxLength) {
        return column -> new TableCell<S, String>(){
            private TextField textField;

            @Override
            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    if (this.textField == null) {
                        this.createTextField(minLength, maxLength);
                    }
                    this.textField.setText(this.getString().replace(".", ""));
                    this.setGraphic(this.textField);
                    this.setText(null);
                    this.textField.selectAll();
                    this.textField.requestFocus();
                }
            }

            @Override
            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getString());
                this.setGraphic(null);
            }

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.trim().isEmpty()) {
                    this.setText(null);
                    this.setGraphic(null);
                    if (!this.getStyleClass().contains("error-cell")) {
                        this.getStyleClass().add("error-cell");
                    }
                } else {
                    this.getStyleClass().remove("error-cell");
                    if (this.isEditing()) {
                        if (this.textField != null) {
                            this.textField.setText(this.getString());
                        }
                        this.setGraphic(this.textField);
                        this.setText(null);
                    } else {
                        this.setText(this.getString());
                        this.setGraphic(null);
                    }
                }
            }

            private void createTextField(int minLength2, int maxLength2) {
                this.textField = new TextField();
                UnaryOperator filter = change -> {
                    String newText = change.getControlNewText();
                    if (!newText.matches("\\d*")) {
                        Platform.runLater(() -> Util.mostrarAlerta("No se permiten caracteres especiales y/o letras."));
                        return null;
                    }
                    if (newText.length() > maxLength2) {
                        Platform.runLater(() -> Util.mostrarAlerta("La longitud m\u00e1xima permitida es de " + maxLength2 + " d\u00edgitos."));
                        return null;
                    }
                    return change;
                };
                this.textField.setTextFormatter(new TextFormatter(filter));
                this.textField.setOnAction(event -> this.commitEdit(this.formatDecimal(this.textField.getText())));
                this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                    if (!isNowFocused.booleanValue()) {
                        Platform.runLater(() -> {
                            String value = this.textField.getText();
                            if (value.length() < minLength2) {
                                if (!value.isEmpty()) {
                                    Util.mostrarAlerta("La longitud m\u00ednima requerida es de " + minLength2 + " d\u00edgitos.");
                                }
                                this.cancelEdit();
                            } else {
                                this.commitEdit(this.formatDecimal(value));
                            }
                        });
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
                    if (event.getCode() == KeyCode.TAB) {
                        int nextColumnIndex;
                        String value = this.textField.getText();
                        if (value.length() >= minLength2 && value.length() <= maxLength2) {
                            this.commitEdit(this.formatDecimal(value));
                        }
                        TableView tableView = this.getTableView();
                        ObservableList visibleColumns = tableView.getVisibleLeafColumns();
                        int currentColumnIndex = visibleColumns.indexOf(this.getTableColumn());
                        int nextRowIndex = this.getIndex();
                        if (event.isShiftDown()) {
                            nextColumnIndex = currentColumnIndex - 1;
                            if (nextColumnIndex < 0) {
                                nextColumnIndex = visibleColumns.size() - 1;
                                --nextRowIndex;
                            }
                        } else {
                            nextColumnIndex = currentColumnIndex + 1;
                            if (nextColumnIndex >= visibleColumns.size()) {
                                nextColumnIndex = 0;
                                ++nextRowIndex;
                            }
                        }
                        if (nextRowIndex >= 0 && nextRowIndex < tableView.getItems().size()) {
                            TableColumn nextColumn = (TableColumn)visibleColumns.get(nextColumnIndex);
                            tableView.edit(nextRowIndex, nextColumn);
                        }
                        event.consume();
                    } else if (event.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        event.consume();
                    }
                });
            }

            private String getString() {
                return this.getItem() == null ? "" : ((String)this.getItem()).toString();
            }

            private String formatDecimal(String value) {
                if (value == null || value.trim().isEmpty()) {
                    return "0.00";
                }
                String digitsOnly = value.replace(".", "");
                if (!digitsOnly.matches("\\d+")) {
                    return "0.00";
                }
                int length = digitsOnly.length();
                if (length <= 2) {
                    digitsOnly = String.format("%03d", Integer.parseInt(digitsOnly));
                    length = digitsOnly.length();
                }
                return digitsOnly.substring(0, length - 2) + "." + digitsOnly.substring(length - 2);
            }
        };
    }

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> createStringWithoutSymbolsCellFactory(final int minLength, final int maxLength) {
        return column -> new TableCell<S, String>(){
            private TextField textField;

            @Override
            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    if (this.textField == null) {
                        this.createTextField(minLength, maxLength);
                    }
                    this.textField.setText(this.getString());
                    this.setGraphic(this.textField);
                    this.setText(null);
                    this.textField.selectAll();
                    this.textField.requestFocus();
                }
            }

            @Override
            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getString());
                this.setGraphic(null);
            }

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.trim().isEmpty()) {
                    this.setText(null);
                    this.setGraphic(null);
                    if (!this.getStyleClass().contains("error-cell")) {
                        this.getStyleClass().add("error-cell");
                    }
                } else {
                    this.getStyleClass().remove("error-cell");
                    if (this.isEditing()) {
                        if (this.textField != null) {
                            this.textField.setText(this.getString());
                        }
                        this.setGraphic(this.textField);
                        this.setText(null);
                    } else {
                        this.setText(this.getString());
                        this.setGraphic(null);
                    }
                }
            }

            private void createTextField(int minLength2, int maxLength2) {
                this.textField = new TextField();
                UnaryOperator filter = change -> {
                    String newText = change.getControlNewText();
                    if (newText.length() > maxLength2) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("La longitud m\u00e1xima permitida es de " + maxLength2 + " caracteres.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    if (!newText.matches("[a-zA-Z0-9 ]*")) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("Solo se permiten letras sin acentos, n\u00fameros y espacios.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    return change;
                };
                this.textField.setTextFormatter(new TextFormatter(filter));
                this.textField.setOnAction(event -> this.commitEdit(this.textField.getText()));
                this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                    if (!isNowFocused.booleanValue()) {
                        Platform.runLater(() -> {
                            String value = this.textField.getText();
                            if (value.length() < minLength2) {
                                if (!value.isEmpty()) {
                                    Util.mostrarAlerta("La longitud m\u00ednima requerida es de " + minLength2 + " caracteres.");
                                }
                                this.cancelEdit();
                            } else {
                                this.commitEdit(value);
                            }
                        });
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
                    if (event.getCode() == KeyCode.TAB) {
                        int nextColumnIndex;
                        String value = this.textField.getText();
                        if (value.length() >= minLength2 && value.length() <= maxLength2) {
                            this.commitEdit(value);
                        }
                        TableView tableView = this.getTableView();
                        ObservableList visibleColumns = tableView.getVisibleLeafColumns();
                        int currentColumnIndex = visibleColumns.indexOf(this.getTableColumn());
                        int nextRowIndex = this.getIndex();
                        if (event.isShiftDown()) {
                            nextColumnIndex = currentColumnIndex - 1;
                            if (nextColumnIndex < 0) {
                                nextColumnIndex = visibleColumns.size() - 1;
                                --nextRowIndex;
                            }
                        } else {
                            nextColumnIndex = currentColumnIndex + 1;
                            if (nextColumnIndex >= visibleColumns.size()) {
                                nextColumnIndex = 0;
                                ++nextRowIndex;
                            }
                        }
                        if (nextRowIndex >= 0 && nextRowIndex < tableView.getItems().size()) {
                            TableColumn nextColumn = (TableColumn)visibleColumns.get(nextColumnIndex);
                            tableView.edit(nextRowIndex, nextColumn);
                        }
                        event.consume();
                    } else if (event.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        event.consume();
                    }
                });
            }

            private String getString() {
                return this.getItem() == null ? "" : ((String)this.getItem()).toString();
            }
        };
    }

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> createStringEmailCellFactory(final int minLength, final int maxLength) {
        return column -> new TableCell<S, String>(){
            private TextField textField;

            @Override
            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    if (this.textField == null) {
                        this.createTextField(minLength, maxLength);
                    }
                    this.textField.setText(this.getString());
                    this.setGraphic(this.textField);
                    this.setText(null);
                    this.textField.selectAll();
                    this.textField.requestFocus();
                }
            }

            @Override
            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getString());
                this.setGraphic(null);
            }

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.trim().isEmpty()) {
                    this.setText(null);
                    this.setGraphic(null);
                    if (!this.getStyleClass().contains("error-cell")) {
                        this.getStyleClass().add("error-cell");
                    }
                } else {
                    this.getStyleClass().remove("error-cell");
                    if (this.isEditing()) {
                        if (this.textField != null) {
                            this.textField.setText(this.getString());
                        }
                        this.setGraphic(this.textField);
                        this.setText(null);
                    } else {
                        this.setText(this.getString());
                        this.setGraphic(null);
                    }
                }
            }

            private void createTextField(int minLength2, int maxLength2) {
                this.textField = new TextField();
                UnaryOperator filter = change -> {
                    String newText = change.getControlNewText();
                    if (newText.length() > maxLength2) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("La longitud m\u00e1xima permitida es de " + maxLength2 + " caracteres.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    if (!newText.matches("[a-zA-Z0-9@._+\\-;,]*") || newText.contains(":") || newText.chars().filter(ch -> ch == 44 || ch == 59).count() > 2L) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("Solo se permiten caracteres v\u00e1lidos en una direcci\u00f3n de correo electr\u00f3nico. M\u00e1ximo tres correos, y no se permite el uso de ':'.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    return change;
                };
                this.textField.setTextFormatter(new TextFormatter(filter));
                this.textField.setOnAction(event -> this.commitEdit(this.textField.getText()));
                this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                    if (!isNowFocused.booleanValue()) {
                        Platform.runLater(() -> {
                            String value = this.textField.getText();
                            if (value.length() < minLength2) {
                                if (!value.isEmpty()) {
                                    Util.mostrarAlerta("La longitud m\u00ednima requerida es de " + minLength2 + " caracteres.");
                                }
                                this.cancelEdit();
                            } else {
                                this.commitEdit(value);
                            }
                        });
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
                    if (event.getCode() == KeyCode.TAB) {
                        int nextColumnIndex;
                        String value = this.textField.getText();
                        if (value.length() >= minLength2 && value.length() <= maxLength2) {
                            this.commitEdit(value);
                        }
                        TableView tableView = this.getTableView();
                        ObservableList visibleColumns = tableView.getVisibleLeafColumns();
                        int currentColumnIndex = visibleColumns.indexOf(this.getTableColumn());
                        int nextRowIndex = this.getIndex();
                        if (event.isShiftDown()) {
                            nextColumnIndex = currentColumnIndex - 1;
                            if (nextColumnIndex < 0) {
                                nextColumnIndex = visibleColumns.size() - 1;
                                --nextRowIndex;
                            }
                        } else {
                            nextColumnIndex = currentColumnIndex + 1;
                            if (nextColumnIndex >= visibleColumns.size()) {
                                nextColumnIndex = 0;
                                ++nextRowIndex;
                            }
                        }
                        if (nextRowIndex >= 0 && nextRowIndex < tableView.getItems().size()) {
                            TableColumn nextColumn = (TableColumn)visibleColumns.get(nextColumnIndex);
                            tableView.edit(nextRowIndex, nextColumn);
                        }
                        event.consume();
                    } else if (event.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        event.consume();
                    }
                });
            }

            private String getString() {
                return this.getItem() == null ? "" : ((String)this.getItem()).toString();
            }
        };
    }

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> createPersonalizedCellFactory(final List<String> allowedValues) {
        return column -> new TableCell<S, String>(){
            private TextField textField;

            @Override
            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    if (this.textField == null) {
                        this.createTextField();
                    }
                    this.textField.setText(this.getString());
                    this.setGraphic(this.textField);
                    this.setText(null);
                    Platform.runLater(() -> this.textField.requestFocus());
                }
            }

            @Override
            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getString());
                this.setGraphic(null);
            }

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.trim().isEmpty()) {
                    this.setText(null);
                    this.setGraphic(null);
                    if (!this.getStyleClass().contains("error-cell")) {
                        this.getStyleClass().add("error-cell");
                    }
                } else {
                    this.getStyleClass().remove("error-cell");
                    this.setText(item);
                    this.setGraphic(null);
                }
            }

            private void createTextField() {
                this.textField = new TextField(this.getString());
                this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                    if (!isNowFocused.booleanValue()) {
                        String value = this.textField.getText();
                        if (this.validate(value)) {
                            this.commitEdit(value);
                        } else {
                            this.mostrarAlerta("Solo se permiten los siguientes valores en la celda: " + String.join((CharSequence)", ", allowedValues));
                            this.cancelEdit();
                        }
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
                    if (event.getCode() == KeyCode.TAB) {
                        int nextColumnIndex;
                        String value = this.textField.getText();
                        if (this.validate(value)) {
                            this.commitEdit(value);
                        }
                        TableView tableView = this.getTableView();
                        ObservableList visibleColumns = tableView.getVisibleLeafColumns();
                        int currentColumnIndex = visibleColumns.indexOf(this.getTableColumn());
                        int nextRowIndex = this.getIndex();
                        if (event.isShiftDown()) {
                            nextColumnIndex = currentColumnIndex - 1;
                            if (nextColumnIndex < 0) {
                                nextColumnIndex = visibleColumns.size() - 1;
                                --nextRowIndex;
                            }
                        } else {
                            nextColumnIndex = currentColumnIndex + 1;
                            if (nextColumnIndex >= visibleColumns.size()) {
                                nextColumnIndex = 0;
                                ++nextRowIndex;
                            }
                        }
                        if (nextRowIndex >= 0 && nextRowIndex < tableView.getItems().size()) {
                            TableColumn nextColumn = (TableColumn)visibleColumns.get(nextColumnIndex);
                            tableView.edit(nextRowIndex, nextColumn);
                        }
                        event.consume();
                    } else if (event.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        event.consume();
                    }
                });
            }

            private boolean validate(String value) {
                return allowedValues.contains(value);
            }

            private String getString() {
                return this.getItem() == null ? "" : (String)this.getItem();
            }

            private void mostrarAlerta(String mensaje) {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Valor inv\u00e1lido");
                alert.setHeaderText(null);
                alert.setContentText(mensaje);
                alert.showAndWait();
            }
        };
    }

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> createFechaEliminacionCellFactory(final int minLength, final int maxLength) {
        return column -> new TableCell<S, String>(){
            private TextField textField;

            @Override
            public void startEdit() {
                if (!this.isEmpty()) {
                    super.startEdit();
                    if (this.textField == null) {
                        this.createTextField(minLength, maxLength);
                    }
                    this.textField.setText(this.getString());
                    this.setGraphic(this.textField);
                    this.setText(null);
                    this.textField.selectAll();
                    this.textField.requestFocus();
                }
            }

            @Override
            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getString());
                this.setGraphic(null);
            }

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.trim().isEmpty()) {
                    this.setText(null);
                    this.setGraphic(null);
                    if (!this.getStyleClass().contains("error-cell")) {
                        this.getStyleClass().add("error-cell");
                    }
                } else {
                    this.getStyleClass().remove("error-cell");
                    if (this.isEditing()) {
                        if (this.textField != null) {
                            this.textField.setText(this.getString());
                        }
                        this.setGraphic(this.textField);
                        this.setText(null);
                    } else {
                        this.setText(this.getString());
                        this.setGraphic(null);
                    }
                }
            }

            private void createTextField(int minLength2, int maxLength2) {
                this.textField = new TextField();
                UnaryOperator filter = change -> {
                    String newText = change.getControlNewText();
                    if (!newText.matches("\\d*")) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("No se permiten caracteres especiales y/o letras.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    if (newText.length() > maxLength2) {
                        Platform.runLater(() -> {
                            Util.mostrarAlerta("La longitud m\u00e1xima permitida es de " + maxLength2 + " d\u00edgitos.");
                            this.textField.clear();
                        });
                        return null;
                    }
                    return change;
                };
                this.textField.setTextFormatter(new TextFormatter(filter));
                this.textField.setOnAction(event -> this.commitEdit(this.textField.getText()));
                this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
                    if (!isNowFocused.booleanValue()) {
                        Platform.runLater(() -> {
                            String value = this.textField.getText();
                            if (value.length() < minLength2) {
                                if (!value.isEmpty()) {
                                    Util.mostrarAlerta("La longitud m\u00ednima requerida es de " + minLength2 + " d\u00edgitos.");
                                }
                                this.cancelEdit();
                            } else {
                                this.commitEdit(Util.fromString(value));
                            }
                        });
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
                    if (event.getCode() == KeyCode.TAB) {
                        int nextColumnIndex;
                        String value = this.textField.getText();
                        if (value.length() >= minLength2 && value.length() <= maxLength2 && mostroAlerta) {
                            this.commitEdit(value);
                        }
                        TableView tableView = this.getTableView();
                        ObservableList visibleColumns = tableView.getVisibleLeafColumns();
                        int currentColumnIndex = visibleColumns.indexOf(this.getTableColumn());
                        int nextRowIndex = this.getIndex();
                        if (event.isShiftDown()) {
                            nextColumnIndex = currentColumnIndex - 1;
                            if (nextColumnIndex < 0) {
                                nextColumnIndex = visibleColumns.size() - 1;
                                --nextRowIndex;
                            }
                        } else {
                            nextColumnIndex = currentColumnIndex + 1;
                            if (nextColumnIndex >= visibleColumns.size()) {
                                nextColumnIndex = 0;
                                ++nextRowIndex;
                            }
                        }
                        if (nextRowIndex >= 0 && nextRowIndex < tableView.getItems().size()) {
                            TableColumn nextColumn = (TableColumn)visibleColumns.get(nextColumnIndex);
                            tableView.edit(nextRowIndex, nextColumn);
                        }
                        event.consume();
                    } else if (event.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        event.consume();
                    }
                });
            }

            private String getString() {
                return this.getItem() == null ? "" : ((String)this.getItem()).toString();
            }
        };
    }

    public static String fromString(String string) {
        try {
            LocalDate inputDate = LocalDate.parse(string, formatter);
            LocalDate today = LocalDate.now();
            LocalDate oneYearLater = today.plusYears(1L);
            if (inputDate.isBefore(today)) {
                Util.mostrarAlerta("La fecha no puede ser anterior al d\u00eda de hoy.");
                mostroAlerta = true;
                return null;
            }
            if (inputDate.isAfter(oneYearLater)) {
                Util.mostrarAlerta("La fecha no puede ser mayor a un a\u00f1o desde hoy.");
                mostroAlerta = true;
                return null;
            }
            return string;
        }
        catch (DateTimeParseException e) {
            Util.mostrarAlerta("Formato de fecha inv\u00e1lido. Usa AAAAMMDD.");
            mostroAlerta = true;
            return null;
        }
    }

    public static String rellenarConCerosIzquierda(String cadena, int longitudTotal) {
        if (cadena.length() >= longitudTotal) {
            return cadena;
        }
        int cantidadDeCeros = longitudTotal - cadena.length();
        StringBuilder ceros = new StringBuilder();
        for (int i = 0; i < cantidadDeCeros; ++i) {
            ceros.append("0");
        }
        return ceros.toString() + cadena;
    }

    public static String rellenarConEspaciosDerecha(String cadena, int longitudTotal) {
        if (cadena.length() >= longitudTotal) {
            return cadena;
        }
        int cantidadDeEspacios = longitudTotal - cadena.length();
        StringBuilder espacios = new StringBuilder();
        for (int i = 0; i < cantidadDeEspacios; ++i) {
            espacios.append(" ");
        }
        return cadena + espacios.toString();
    }

    public static void limitarFechas(DatePicker miDatePicker, final String tipoSeleccionado) {
        final LocalDate hoy = LocalDate.now();
        miDatePicker.setDayCellFactory(picker -> new DateCell(){

            @Override
            public void updateItem(LocalDate item, boolean empty) {
                boolean esFinDeSemana;
                super.updateItem(item, empty);
                boolean bl = esFinDeSemana = item.getDayOfWeek() == DayOfWeek.SATURDAY || item.getDayOfWeek() == DayOfWeek.SUNDAY;
                if (tipoSeleccionado.equals("1")) {
                    if (item.isBefore(hoy) || esFinDeSemana) {
                        this.setDisable(true);
                        this.setStyle("-fx-background-color: #A39E9E;");
                    }
                } else if (tipoSeleccionado.equals("2") && esFinDeSemana) {
                    this.setDisable(true);
                    this.setStyle("-fx-background-color: #A39E9E;");
                }
            }
        });
    }

    public static void limitarFechasAnteriores(DatePicker miDatePicker) {
        final LocalDate hoy = LocalDate.now();
        miDatePicker.setDayCellFactory(picker -> new DateCell(){

            @Override
            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                if (item.isBefore(hoy)) {
                    this.setDisable(true);
                    this.setStyle("-fx-background-color: #A39E9E;");
                }
            }
        });
    }

    public static boolean isValidNumeric(String value, int minLength, int maxLength) {
        if (value == null || value.trim().isEmpty()) {
            return Util.isLengthValid(value, minLength, maxLength);
        }
        boolean formatValid = value.matches("\\d*\\.?\\d*");
        boolean lengthValid = Util.isLengthValid(value, minLength, maxLength);
        return formatValid && lengthValid;
    }

    public static boolean isValidDecimal(String value, int minLength, int maxLength) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        boolean formatValid = value.matches("\\d+\\.\\d{1,2}");
        boolean lengthValid = Util.isLengthValid(value, minLength, maxLength);
        return formatValid && lengthValid;
    }

    public static boolean isValidStringWithoutSymbols(String value, int minLength, int maxLength) {
        if (value == null || value.trim().isEmpty()) {
            return Util.isLengthValid(value, minLength, maxLength);
        }
        boolean formatValid = value.matches("[a-zA-Z0-9 ]*");
        boolean lengthValid = Util.isLengthValid(value, minLength, maxLength);
        return formatValid && lengthValid;
    }

    public static boolean isValidEmail(String value, int minLength, int maxLength) {
        if (value == null || value.trim().isEmpty()) {
            return Util.isLengthValid(value, minLength, maxLength);
        }
        boolean formatValid = Util.validarCorreos(value);
        boolean lengthValid = Util.isLengthValid(value, minLength, maxLength);
        return formatValid && lengthValid;
    }

    public static boolean validarCorreos(String value) {
        if (!value.matches("[a-zA-Z0-9@._%+\\-;,]*") || value.contains(":")) {
            return false;
        }
        long separadores = value.chars().filter(ch -> ch == 44 || ch == 59).count();
        if (separadores > 2L) {
            return false;
        }
        String[] correos = value.split("[,;]");
        String regexCorreo = "^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,6}$";
        for (String correo : correos) {
            if (correo.matches(regexCorreo)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidAllowedValue(String value, List<String> allowedValues) {
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        return allowedValues.contains(value);
    }

    private static boolean isLengthValid(String value, int minLength, int maxLength) {
        if (value == null || value.trim().isEmpty()) {
            return minLength == 0;
        }
        int length = value.length();
        return length >= minLength && length <= maxLength;
    }

    public static void mostrarAlerta(String mensaje) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("Advertencia");
        alert.setHeaderText(null);
        alert.setContentText(mensaje);
        alert.showAndWait();
    }

    public static void exportarErroresAExcel(List<ErrorData> errores) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("Reporte de Errores");
        Row headerRow = sheet.createRow(0);
        headerRow.createCell(0).setCellValue("Fila Original");
        headerRow.createCell(1).setCellValue("Columna");
        headerRow.createCell(2).setCellValue("Mensaje de Error");
        int rowNum = 1;
        for (ErrorData error : errores) {
            Row row = sheet.createRow(rowNum++);
            row.createCell(0).setCellValue(error.fila);
            row.createCell(1).setCellValue(error.columna);
            row.createCell(2).setCellValue(error.mensaje);
        }
        for (int i = 0; i < 4; ++i) {
            sheet.autoSizeColumn(i);
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Guardar Reporte de Errores");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", "*.xlsx"));
        fileChooser.setInitialFileName("Reporte_Errores_Importacion_" + System.currentTimeMillis() + ".xlsx");
        File file = fileChooser.showSaveDialog(new Stage());
        if (file != null) {
            try (FileOutputStream fileOut = new FileOutputStream(file);){
                workbook.write(fileOut);
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Reporte Generado");
                alert.setHeaderText(null);
                alert.setContentText("El archivo de errores se ha generado exitosamente en:\n" + file.getAbsolutePath());
                alert.showAndWait();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setTablaEditable(TableView<?> tableView, Button btnAgregar, Button btnEliminar, boolean editable) {
        boolean isEditable = !editable;
        tableView.setEditable(isEditable);
        if (!isEditable) {
            tableView.getStyleClass().add("disabled-overlay");
        } else {
            tableView.getStyleClass().remove("disabled-overlay");
        }
        if (btnAgregar != null) {
            btnAgregar.setDisable(!isEditable);
        }
        if (btnEliminar != null) {
            btnEliminar.setDisable(!isEditable);
        }
    }

    public static void activaDesactivaCapturaConBaseCampo(TableView<?> tableView, Button btnAgregar, Button btnEliminar, Button btnEliminarAll, Hyperlink btnCargar, ObservableList<PreRegistroCuentasData> dataList, boolean editable) {
        boolean isEditable = !editable;
        tableView.setEditable(isEditable);
        if (!isEditable) {
            dataList.clear();
            PreRegistroCuentasData nuevaFila = new PreRegistroCuentasData(1, "", "", "", "", "", "", "", "", "");
            dataList.add(nuevaFila);
            tableView.getStyleClass().add("disabled-overlay");
        } else {
            tableView.getStyleClass().remove("disabled-overlay");
        }
        if (btnAgregar != null) {
            btnAgregar.setDisable(!isEditable);
        }
        if (btnEliminar != null) {
            btnEliminar.setDisable(!isEditable);
        }
        if (btnEliminarAll != null) {
            btnEliminarAll.setDisable(!isEditable);
        }
        if (btnCargar != null) {
            btnCargar.setDisable(!isEditable);
        }
    }

    public static void setTooltipOnColumnHeader(TableColumn<?, ?> column, String tooltipText) {
        Label headerLabel = new Label(column.getText());
        headerLabel.setStyle("-fx-padding: 0 5 0 5;");
        headerLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Tooltip tooltip = new Tooltip(tooltipText);
        Tooltip.install(headerLabel, tooltip);
        column.setText(null);
        column.setGraphic(headerLabel);
    }

    public static boolean esRutaValida(String ruta) {
        String regex = "^[a-zA-Z0-9 _-]+$";
        return ruta.matches(regex);
    }
}

